/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.signature;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.signature.AsmTypeFactory;
import org.jetbrains.kotlin.load.kotlin.JvmDescriptorTypeWriter;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class JvmSignatureWriter
extends JvmDescriptorTypeWriter<Type> {
    private final List<JvmMethodParameterSignature> kotlinParameterTypes = new ArrayList<JvmMethodParameterSignature>();
    private Type jvmReturnType;
    private JvmMethodParameterKind currentParameterKind;
    private int currentSignatureSize = 0;

    public JvmSignatureWriter() {
        super(AsmTypeFactory.INSTANCE);
    }

    @Override
    public void writeClass(@NotNull Type objectType) {
        if (objectType == null) {
            JvmSignatureWriter.$$$reportNull$$$0(0);
        }
        this.writeClassBegin(objectType);
        this.writeClassEnd();
    }

    public void writeAsmType(@NotNull Type asmType) {
        if (asmType == null) {
            JvmSignatureWriter.$$$reportNull$$$0(1);
        }
        switch (asmType.getSort()) {
            case 10: {
                this.writeClassBegin(asmType);
                this.writeClassEnd();
                return;
            }
            case 9: {
                this.writeArrayType();
                this.writeAsmType(AsmUtil.correctElementType(asmType));
                this.writeArrayEnd();
                return;
            }
        }
        this.writeJvmTypeAsIs(asmType);
    }

    public void writeClassBegin(Type asmType) {
        this.writeJvmTypeAsIs(asmType);
    }

    public void writeOuterClassBegin(Type resultingAsmType, String outerInternalName) {
        this.writeJvmTypeAsIs(resultingAsmType);
    }

    public void writeInnerClass(String name2) {
    }

    public void writeClassEnd() {
    }

    public void writeTypeArgument(@NotNull Variance projectionKind) {
        if (projectionKind == null) {
            JvmSignatureWriter.$$$reportNull$$$0(2);
        }
    }

    public void writeUnboundedWildcard() {
    }

    public void writeTypeArgumentEnd() {
    }

    public void writeFormalTypeParameter(String name2) {
    }

    public void writeClassBound() {
    }

    public void writeClassBoundEnd() {
    }

    public void writeInterfaceBound() {
    }

    public void writeInterfaceBoundEnd() {
    }

    public void writeParametersStart() {
        this.clearCurrentType();
    }

    public void writeParameterType(JvmMethodParameterKind parameterKind) {
        this.currentParameterKind = parameterKind;
    }

    public void writeParameterTypeEnd() {
        this.kotlinParameterTypes.add(new JvmMethodParameterSignature((Type)this.getJvmCurrentType(), this.currentParameterKind));
        this.currentSignatureSize += ((Type)this.getJvmCurrentType()).getSize();
        this.currentParameterKind = null;
        this.clearCurrentType();
    }

    public void writeReturnType() {
    }

    public void writeReturnTypeEnd() {
        this.jvmReturnType = (Type)this.getJvmCurrentType();
        this.clearCurrentType();
    }

    public void writeSuperclass() {
    }

    public void writeSuperclassEnd() {
    }

    public void writeInterface() {
    }

    public void writeInterfaceEnd() {
    }

    @Nullable
    public String makeJavaGenericSignature() {
        return null;
    }

    @NotNull
    public JvmMethodGenericSignature makeJvmMethodSignature(@NotNull String name2) {
        if (name2 == null) {
            JvmSignatureWriter.$$$reportNull$$$0(3);
        }
        ArrayList<Type> types = new ArrayList<Type>(this.kotlinParameterTypes.size());
        for (JvmMethodParameterSignature parameter : this.kotlinParameterTypes) {
            types.add(parameter.getAsmType());
        }
        Method asmMethod2 = new Method(name2, this.jvmReturnType, types.toArray(new Type[types.size()]));
        JvmMethodGenericSignature jvmMethodGenericSignature = new JvmMethodGenericSignature(asmMethod2, this.kotlinParameterTypes, this.makeJavaGenericSignature());
        if (jvmMethodGenericSignature == null) {
            JvmSignatureWriter.$$$reportNull$$$0(4);
        }
        return jvmMethodGenericSignature;
    }

    public int getCurrentSignatureSize() {
        return this.currentSignatureSize;
    }

    public boolean skipGenericSignature() {
        return true;
    }

    public String toString() {
        return "empty";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectionKind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/signature/JvmSignatureWriter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/signature/JvmSignatureWriter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "makeJvmMethodSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeAsmType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeTypeArgument";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "makeJvmMethodSignature";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

