/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

public class DelegationFieldsInfo {
    private final Type classAsmType;
    private final ClassDescriptor classDescriptor;
    private final GenerationState state;
    private final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final Map<KtDelegatedSuperTypeEntry, Field> fields;

    public DelegationFieldsInfo(@NotNull Type type2, @NotNull ClassDescriptor descriptor2, @NotNull GenerationState state2, @NotNull BindingContext context) {
        if (type2 == null) {
            DelegationFieldsInfo.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            DelegationFieldsInfo.$$$reportNull$$$0(1);
        }
        if (state2 == null) {
            DelegationFieldsInfo.$$$reportNull$$$0(2);
        }
        if (context == null) {
            DelegationFieldsInfo.$$$reportNull$$$0(3);
        }
        this.fields = new HashMap<KtDelegatedSuperTypeEntry, Field>();
        this.classAsmType = type2;
        this.classDescriptor = descriptor2;
        this.state = state2;
        this.typeMapper = state2.getTypeMapper();
        this.bindingContext = context;
    }

    @Nullable
    public Field getInfo(KtDelegatedSuperTypeEntry specifier) {
        Field field = this.fields.get(specifier);
        assert (field != null || this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) : "No field for " + specifier.getText();
        return field;
    }

    private void addField(KtDelegatedSuperTypeEntry specifier, PropertyDescriptor propertyDescriptor2) {
        this.fields.put(specifier, new Field(this.typeMapper.mapType(propertyDescriptor2), propertyDescriptor2.getName().asString(), false));
    }

    private void addField(KtDelegatedSuperTypeEntry specifier, Type type2, String name2) {
        this.fields.put(specifier, new Field(type2, name2, true));
    }

    @NotNull
    public DelegationFieldsInfo getDelegationFieldsInfo(@NotNull List<KtSuperTypeListEntry> delegationSpecifiers) {
        if (delegationSpecifiers == null) {
            DelegationFieldsInfo.$$$reportNull$$$0(4);
        }
        DelegationFieldsInfo result2 = new DelegationFieldsInfo(this.classAsmType, this.classDescriptor, this.state, this.bindingContext);
        int n = 0;
        for (KtSuperTypeListEntry specifier : delegationSpecifiers) {
            KtExpression expression2;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry) || (expression2 = ((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression()) == null) continue;
            PropertyDescriptor propertyDescriptor2 = CodegenUtil.getDelegatePropertyIfAny(expression2, this.classDescriptor, this.bindingContext);
            if (CodegenUtil.isFinalPropertyWithBackingField(propertyDescriptor2, this.bindingContext)) {
                result2.addField((KtDelegatedSuperTypeEntry)specifier, propertyDescriptor2);
            } else {
                Type asmType;
                KotlinType expressionType = this.bindingContext.getType(expression2);
                ClassDescriptor superClass = JvmCodegenUtil.getSuperClass(specifier, this.state, this.bindingContext);
                Type type2 = expressionType != null ? this.typeMapper.mapType(expressionType) : (asmType = superClass != null ? this.typeMapper.mapType(superClass) : null);
                if (asmType == null) continue;
                result2.addField((KtDelegatedSuperTypeEntry)specifier, asmType, "$$delegate_" + n);
            }
            ++n;
        }
        DelegationFieldsInfo delegationFieldsInfo = result2;
        if (delegationFieldsInfo == null) {
            DelegationFieldsInfo.$$$reportNull$$$0(5);
        }
        return delegationFieldsInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegationSpecifiers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/DelegationFieldsInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/DelegationFieldsInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegationFieldsInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDelegationFieldsInfo";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class Field {
        public final Type type;
        public final String name;
        public final boolean generateField;

        private Field(Type type2, String name2, boolean generateField) {
            this.type = type2;
            this.name = name2;
            this.generateField = generateField;
        }

        @NotNull
        public StackValue getStackValue() {
            StackValue.Field field = StackValue.field(this.type, DelegationFieldsInfo.this.classAsmType, this.name, false, StackValue.none());
            if (field == null) {
                Field.$$$reportNull$$$0(0);
            }
            return field;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/DelegationFieldsInfo$Field", "getStackValue"));
        }
    }
}

