/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.phaser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0001\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010#\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tj\u0002`\n0\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001e\u0010$\u001a\u00020%2\u0016\u0010&\u001a\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tj\u0002`\nJ\u001e\u0010'\u001a\u00020%2\u0016\u0010&\u001a\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tj\u0002`\nJ\u000e\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u0015J\u0006\u0010*\u001a\u00020%J:\u0010+\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tj\u0002`\n0\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\b0-H\u0002J&\u0010.\u001a\u00020%2\u0016\u0010&\u001a\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tj\u0002`\n2\u0006\u0010/\u001a\u00020\u0010R\u001a\u0010\u0002\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0007\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tj\u0002`\n0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tj\u0002`\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R1\u0010\u0013\u001a\"\u0012\u0004\u0012\u00020\u0015\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R'\u0010\u0019\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tj\u0002`\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR'\u0010\u001b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tj\u0002`\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR'\u0010\u001d\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tj\u0002`\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\fR'\u0010\u001f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tj\u0002`\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\fR'\u0010!\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tj\u0002`\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\f\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "", "compoundPhase", "Lorg/jetbrains/kotlin/backend/common/phaser/CompilerPhase;", "config", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lorg/jetbrains/kotlin/backend/common/phaser/CompilerPhase;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "enabled", "", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "Lorg/jetbrains/kotlin/backend/common/phaser/AnyNamedPhase;", "getEnabled", "()Ljava/util/Set;", "enabledMut", "", "needProfiling", "", "getNeedProfiling", "()Z", "phases", "", "", "", "getPhases", "()Ljava/util/Map;", "toDumpStateAfter", "getToDumpStateAfter", "toDumpStateBefore", "getToDumpStateBefore", "toValidateStateAfter", "getToValidateStateAfter", "toValidateStateBefore", "getToValidateStateBefore", "verbose", "getVerbose", "computeEnabled", "disable", "", "phase", "enable", "known", "name", "list", "phaseSetFromConfiguration", "key", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "switch", "onOff", "ir.backend.common"})
public final class PhaseConfig {
    @NotNull
    private final Map<String, NamedCompilerPhase<?, ?, Object>> phases;
    private final Set<NamedCompilerPhase<?, ?, ?>> enabledMut;
    @NotNull
    private final Set<NamedCompilerPhase<?, ?, ?>> verbose;
    @NotNull
    private final Set<NamedCompilerPhase<?, ?, ?>> toDumpStateBefore;
    @NotNull
    private final Set<NamedCompilerPhase<?, ?, ?>> toDumpStateAfter;
    @NotNull
    private final Set<NamedCompilerPhase<?, ?, ?>> toValidateStateBefore;
    @NotNull
    private final Set<NamedCompilerPhase<?, ?, ?>> toValidateStateAfter;
    private final boolean needProfiling;
    private final CompilerPhase<?, ?, ?> compoundPhase;

    @NotNull
    public final Map<String, NamedCompilerPhase<?, ?, Object>> getPhases() {
        return this.phases;
    }

    @NotNull
    public final Set<NamedCompilerPhase<?, ?, ?>> getEnabled() {
        return this.enabledMut;
    }

    @NotNull
    public final Set<NamedCompilerPhase<?, ?, ?>> getVerbose() {
        return this.verbose;
    }

    @NotNull
    public final Set<NamedCompilerPhase<?, ?, ?>> getToDumpStateBefore() {
        return this.toDumpStateBefore;
    }

    @NotNull
    public final Set<NamedCompilerPhase<?, ?, ?>> getToDumpStateAfter() {
        return this.toDumpStateAfter;
    }

    @NotNull
    public final Set<NamedCompilerPhase<?, ?, ?>> getToValidateStateBefore() {
        return this.toValidateStateBefore;
    }

    @NotNull
    public final Set<NamedCompilerPhase<?, ?, ?>> getToValidateStateAfter() {
        return this.toValidateStateAfter;
    }

    public final boolean getNeedProfiling() {
        return this.needProfiling;
    }

    @NotNull
    public final String known(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (this.phases.get(name2) == null) {
            String string = "Unknown phase: " + name2 + ". Use -Xlist-phases to see the list of phases.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return name2;
    }

    public final void list() {
        Iterable $this$forEach$iv = CompilerPhase.DefaultImpls.getNamedSubphases$default(this.compoundPhase, 0, 1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$depth$phase = (Pair)element$iv;
            boolean bl = false;
            int depth = ((Number)$dstr$depth$phase.component1()).intValue();
            NamedCompilerPhase phase = (NamedCompilerPhase)$dstr$depth$phase.component2();
            String enabled = this.getEnabled().contains(phase) ? "(Enabled)" : "";
            String verbose = this.verbose.contains(phase) ? "(Verbose)" : "";
            Object object = StringCompanionObject.INSTANCE;
            String string = "%1$-50s %2$-50s %3$-10s";
            Object[] objectArray = new Object[]{StringsKt.repeat((CharSequence)"\t", (int)depth) + phase.getName() + ':', phase.getDescription(), enabled + ' ' + verbose};
            boolean bl2 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            object = string2;
            boolean bl3 = false;
            System.out.println(object);
        }
    }

    private final Set<NamedCompilerPhase<?, ?, ?>> computeEnabled(CompilerConfiguration config) {
        CommonConfigurationKeys commonConfigurationKeys = CommonConfigurationKeys.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        CommonConfigurationKeys $this$with = commonConfigurationKeys;
        boolean bl3 = false;
        Set<NamedCompilerPhase<?, ?, ?>> disabledPhases = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.DISABLED_PHASES);
        return SetsKt.minus((Set)CollectionsKt.toSet((Iterable)this.phases.values()), (Iterable)disabledPhases);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<NamedCompilerPhase<?, ?, ?>> phaseSetFromConfiguration(CompilerConfiguration config, CompilerConfigurationKey<Set<String>> key) {
        void $this$mapTo$iv$iv;
        Set phaseNames;
        Set set = config.get(key);
        if (set == null) {
            set = phaseNames = SetsKt.emptySet();
        }
        if (phaseNames.contains("ALL")) {
            return CollectionsKt.toSet((Iterable)this.phases.values());
        }
        Iterable $this$map$iv = phaseNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            NamedCompilerPhase<?, ?, Object> namedCompilerPhase;
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (this.phases.get(it) == null) {
                Intrinsics.throwNpe();
            }
            collection.add(namedCompilerPhase);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final void enable(@NotNull NamedCompilerPhase<?, ?, ?> phase) {
        Intrinsics.checkParameterIsNotNull(phase, (String)"phase");
        this.enabledMut.add(phase);
    }

    public final void disable(@NotNull NamedCompilerPhase<?, ?, ?> phase) {
        Intrinsics.checkParameterIsNotNull(phase, (String)"phase");
        this.enabledMut.remove(phase);
    }

    public final void switch(@NotNull NamedCompilerPhase<?, ?, ?> phase, boolean onOff) {
        Intrinsics.checkParameterIsNotNull(phase, (String)"phase");
        if (onOff) {
            this.enable(phase);
        } else {
            this.disable(phase);
        }
    }

    /*
     * WARNING - void declaration
     */
    public PhaseConfig(@NotNull CompilerPhase<?, ?, ?> compoundPhase, @NotNull CompilerConfiguration config) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkParameterIsNotNull(compoundPhase, (String)"compoundPhase");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.compoundPhase = compoundPhase;
        Object object2 = CompilerPhase.DefaultImpls.getNamedSubphases$default(this.compoundPhase, 0, 1, null);
        PhaseConfig phaseConfig = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$_u24__u24$phase;
            NamedCompilerPhase phase;
            Pair pair = (Pair)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            NamedCompilerPhase namedCompilerPhase = phase = (NamedCompilerPhase)$dstr$_u24__u24$phase.component2();
            object.add(namedCompilerPhase);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = (Iterable)object;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl = destination$iv$iv2;
            NamedCompilerPhase it = (NamedCompilerPhase)element$iv$iv;
            boolean bl2 = false;
            it = TuplesKt.to((Object)it.getName(), (Object)it);
            bl2 = false;
            bl.put(it.getFirst(), it.getSecond());
        }
        phaseConfig.phases = object = destination$iv$iv2;
        this.enabledMut = CollectionsKt.toMutableSet((Iterable)this.computeEnabled(config));
        this.verbose = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.VERBOSE_PHASES);
        object2 = CommonConfigurationKeys.INSTANCE;
        boolean bl = false;
        boolean bl3 = false;
        Object $this$with = object2;
        boolean bl4 = false;
        Set<NamedCompilerPhase<?, ?, ?>> beforeDumpSet = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.PHASES_TO_DUMP_STATE_BEFORE);
        Set<NamedCompilerPhase<?, ?, ?>> afterDumpSet = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.PHASES_TO_DUMP_STATE_AFTER);
        Set<NamedCompilerPhase<?, ?, ?>> bothDumpSet = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.PHASES_TO_DUMP_STATE);
        this.toDumpStateBefore = SetsKt.plus(beforeDumpSet, (Iterable)bothDumpSet);
        this.toDumpStateAfter = SetsKt.plus(afterDumpSet, (Iterable)bothDumpSet);
        Set<NamedCompilerPhase<?, ?, ?>> beforeValidateSet = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.PHASES_TO_VALIDATE_BEFORE);
        Set<NamedCompilerPhase<?, ?, ?>> afterValidateSet = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.PHASES_TO_VALIDATE_AFTER);
        Set<NamedCompilerPhase<?, ?, ?>> bothValidateSet = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.PHASES_TO_VALIDATE);
        this.toValidateStateBefore = SetsKt.plus(beforeValidateSet, (Iterable)bothValidateSet);
        this.toValidateStateAfter = SetsKt.plus(afterValidateSet, (Iterable)bothValidateSet);
        this.needProfiling = config.getBoolean(CommonConfigurationKeys.PROFILE_PHASES);
    }
}

