/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathMacroUtil {
    @NonNls
    public static final String PROJECT_DIR_MACRO_NAME = "PROJECT_DIR";
    @NonNls
    public static final String MODULE_DIR_MACRO_NAME = "MODULE_DIR";
    public static final String DEPRECATED_MODULE_DIR = "$MODULE_DIR$";
    public static final String MODULE_WORKING_DIR_NAME = "MODULE_WORKING_DIR";
    public static final String MODULE_WORKING_DIR = "$MODULE_WORKING_DIR$";
    @NonNls
    public static final String DIRECTORY_STORE_NAME = ".idea";
    @NonNls
    public static final String APPLICATION_HOME_DIR = "APPLICATION_HOME_DIR";
    @NonNls
    public static final String APPLICATION_CONFIG_DIR = "APPLICATION_CONFIG_DIR";
    @NonNls
    public static final String APPLICATION_PLUGINS_DIR = "APPLICATION_PLUGINS_DIR";
    @NonNls
    public static final String USER_HOME_NAME = "USER_HOME";
    private static volatile Map<String, String> ourGlobalMacrosForIde;
    private static volatile Map<String, String> ourGlobalMacrosForStandalone;

    @Nullable
    public static String getModuleDir(@NotNull String moduleFilePath) {
        String moduleDir;
        if (moduleFilePath == null) {
            PathMacroUtil.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)(moduleDir = PathUtilRt.getParentPath((String)moduleFilePath)))) {
            return null;
        }
        String moduleDirParent = PathUtilRt.getParentPath((String)moduleDir);
        if (!StringUtil.isEmpty((String)moduleDirParent) && PathUtilRt.getFileName((String)moduleDir).equals(DIRECTORY_STORE_NAME)) {
            moduleDir = moduleDirParent;
        }
        if ((moduleDir = FileUtilRt.toSystemIndependentName((String)moduleDir)).endsWith(":/")) {
            moduleDir = moduleDir.substring(0, moduleDir.length() - 1);
        }
        return moduleDir;
    }

    @NotNull
    public static String getUserHomePath() {
        String string = (String)ObjectUtils.assertNotNull((Object)PathMacroUtil.getGlobalSystemMacroValue(USER_HOME_NAME));
        if (string == null) {
            PathMacroUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static Map<String, String> getGlobalSystemMacros() {
        Map<String, String> map2 = PathMacroUtil.getGlobalSystemMacros(true);
        if (map2 == null) {
            PathMacroUtil.$$$reportNull$$$0(2);
        }
        return map2;
    }

    @NotNull
    public static Map<String, String> getGlobalSystemMacros(boolean insideIde) {
        if (insideIde) {
            if (ourGlobalMacrosForIde == null) {
                ourGlobalMacrosForIde = PathMacroUtil.computeGlobalPathMacrosInsideIde();
            }
            Map<String, String> map2 = ourGlobalMacrosForIde;
            if (map2 == null) {
                PathMacroUtil.$$$reportNull$$$0(3);
            }
            return map2;
        }
        if (ourGlobalMacrosForStandalone == null) {
            ourGlobalMacrosForStandalone = PathMacroUtil.computeGlobalPathMacrosForStandaloneCode();
        }
        Map<String, String> map3 = ourGlobalMacrosForStandalone;
        if (map3 == null) {
            PathMacroUtil.$$$reportNull$$$0(4);
        }
        return map3;
    }

    private static Map<String, String> computeGlobalPathMacrosForStandaloneCode() {
        ContainerUtil.ImmutableMapBuilder builder = ContainerUtil.immutableMapBuilder();
        String homePath = PathManager.getHomePath((boolean)false);
        if (homePath != null) {
            builder.put((Object)APPLICATION_HOME_DIR, (Object)FileUtilRt.toSystemIndependentName((String)homePath)).put((Object)APPLICATION_CONFIG_DIR, (Object)FileUtilRt.toSystemIndependentName((String)PathManager.getConfigPath())).put((Object)APPLICATION_PLUGINS_DIR, (Object)FileUtilRt.toSystemIndependentName((String)PathManager.getPluginsPath()));
        }
        builder.put((Object)USER_HOME_NAME, (Object)PathMacroUtil.computeUserHomePath());
        return builder.build();
    }

    private static Map<String, String> computeGlobalPathMacrosInsideIde() {
        return ContainerUtil.immutableMapBuilder().put((Object)APPLICATION_HOME_DIR, (Object)FileUtilRt.toSystemIndependentName((String)PathManager.getHomePath())).put((Object)APPLICATION_CONFIG_DIR, (Object)FileUtilRt.toSystemIndependentName((String)PathManager.getConfigPath())).put((Object)APPLICATION_PLUGINS_DIR, (Object)FileUtilRt.toSystemIndependentName((String)PathManager.getPluginsPath())).put((Object)USER_HOME_NAME, (Object)PathMacroUtil.computeUserHomePath()).build();
    }

    @NotNull
    private static String computeUserHomePath() {
        String string = StringUtil.trimEnd((String)FileUtilRt.toSystemIndependentName((String)SystemProperties.getUserHome()), (String)"/");
        if (string == null) {
            PathMacroUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static String getGlobalSystemMacroValue(String name2) {
        return PathMacroUtil.getGlobalSystemMacroValue(name2, true);
    }

    @Nullable
    public static String getGlobalSystemMacroValue(String name2, boolean insideIde) {
        return PathMacroUtil.getGlobalSystemMacros(insideIde).get(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFilePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/PathMacroUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/PathMacroUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserHomePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalSystemMacros";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeUserHomePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDir";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

