/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor;

import com.android.tools.build.jetifier.core.config.Config;
import com.android.tools.build.jetifier.core.type.JavaType;
import com.android.tools.build.jetifier.processor.archive.Archive;
import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.archive.ArchiveItem;
import com.android.tools.build.jetifier.processor.archive.ArchiveItemVisitor;
import com.android.tools.build.jetifier.processor.transform.bytecode.InvalidByteCodeException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0000J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000e\"\u0004\b\u0015\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/build/jetifier/processor/AndroidXRefScanner;", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveItemVisitor;", "library", "Lcom/android/tools/build/jetifier/processor/archive/Archive;", "config", "Lcom/android/tools/build/jetifier/core/config/Config;", "(Lcom/android/tools/build/jetifier/processor/archive/Archive;Lcom/android/tools/build/jetifier/core/config/Config;)V", "androidSupportDetected", "", "getAndroidSupportDetected", "()Z", "androidSupportRefExample", "", "getAndroidSupportRefExample", "()Ljava/lang/String;", "setAndroidSupportRefExample", "(Ljava/lang/String;)V", "androidXDetected", "getAndroidXDetected", "androidXRefExample", "getAndroidXRefExample", "setAndroidXRefExample", "scan", "visit", "", "archive", "archiveFile", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "AndroidXTrackingRemapper", "jetifier-processor"})
public final class AndroidXRefScanner
implements ArchiveItemVisitor {
    @Nullable
    private String androidXRefExample;
    @Nullable
    private String androidSupportRefExample;
    private final Archive library;
    private final Config config;

    public final boolean getAndroidXDetected() {
        return this.androidXRefExample != null;
    }

    public final boolean getAndroidSupportDetected() {
        return this.androidSupportRefExample != null;
    }

    @Nullable
    public final String getAndroidXRefExample() {
        return this.androidXRefExample;
    }

    public final void setAndroidXRefExample(@Nullable String string) {
        this.androidXRefExample = string;
    }

    @Nullable
    public final String getAndroidSupportRefExample() {
        return this.androidSupportRefExample;
    }

    public final void setAndroidSupportRefExample(@Nullable String string) {
        this.androidSupportRefExample = string;
    }

    @NotNull
    public final AndroidXRefScanner scan() {
        this.library.accept(this);
        return this;
    }

    @Override
    public void visit(@NotNull Archive archive) {
        Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
        Iterable $this$forEach$iv = archive.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArchiveItem it = (ArchiveItem)element$iv;
            boolean bl = false;
            if (this.getAndroidXDetected() && this.getAndroidSupportDetected()) continue;
            it.accept(this);
        }
    }

    @Override
    public void visit(@NotNull ArchiveFile archiveFile) {
        Intrinsics.checkParameterIsNotNull((Object)archiveFile, (String)"archiveFile");
        if (!archiveFile.isClassFile()) {
            return;
        }
        ClassReader reader = new ClassReader(archiveFile.getData());
        ClassWriter writer = new ClassWriter(0);
        AndroidXTrackingRemapper androidXTrackingRemapper = new AndroidXTrackingRemapper(this.config);
        ClassRemapper classRemapper = new ClassRemapper((ClassVisitor)writer, (Remapper)androidXTrackingRemapper);
        try {
            reader.accept((ClassVisitor)classRemapper, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw (Throwable)new InvalidByteCodeException("Error processing '" + archiveFile.getRelativePath() + "' bytecode.", e);
        }
        if (androidXTrackingRemapper.getAndroidXRefExample() != null) {
            this.androidXRefExample = androidXTrackingRemapper.getAndroidXRefExample();
        }
        if (androidXTrackingRemapper.getAndroidSupportRefExample() != null) {
            this.androidSupportRefExample = androidXTrackingRemapper.getAndroidSupportRefExample();
        }
    }

    public AndroidXRefScanner(@NotNull Archive library, @NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.library = library;
        this.config = config;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/build/jetifier/processor/AndroidXRefScanner$AndroidXTrackingRemapper;", "Lorg/objectweb/asm/commons/Remapper;", "config", "Lcom/android/tools/build/jetifier/core/config/Config;", "(Lcom/android/tools/build/jetifier/core/config/Config;)V", "androidSupportRefExample", "", "getAndroidSupportRefExample", "()Ljava/lang/String;", "setAndroidSupportRefExample", "(Ljava/lang/String;)V", "androidXRefExample", "getAndroidXRefExample", "setAndroidXRefExample", "map", "typeName", "jetifier-processor"})
    public static final class AndroidXTrackingRemapper
    extends Remapper {
        @Nullable
        private String androidXRefExample;
        @Nullable
        private String androidSupportRefExample;
        private final Config config;

        @Nullable
        public final String getAndroidXRefExample() {
            return this.androidXRefExample;
        }

        public final void setAndroidXRefExample(@Nullable String string) {
            this.androidXRefExample = string;
        }

        @Nullable
        public final String getAndroidSupportRefExample() {
            return this.androidSupportRefExample;
        }

        public final void setAndroidSupportRefExample(@Nullable String string) {
            this.androidSupportRefExample = string;
        }

        @NotNull
        public String map(@NotNull String typeName) {
            Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
            if (StringsKt.startsWith$default((String)typeName, (String)"androidx/", (boolean)false, (int)2, null)) {
                this.androidXRefExample = typeName;
            } else if (this.config.isEligibleForRewrite(new JavaType(typeName))) {
                this.androidSupportRefExample = typeName;
            }
            return typeName;
        }

        public AndroidXTrackingRemapper(@NotNull Config config) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            this.config = config;
        }
    }
}

