/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.Version;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.tasks.AarMetadataTaskKt;
import com.android.build.gradle.internal.tasks.AarMetadataWorkParameters;
import com.android.ide.common.repository.AgpVersion;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.RegularFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/AarMetadataWorkAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/AarMetadataWorkParameters;", "()V", "run", "", "gradle-core"})
public abstract class AarMetadataWorkAction
extends ProfileAwareWorkAction<AarMetadataWorkParameters> {
    @Override
    public void run() {
        String minAgpVersion = (String)((AarMetadataWorkParameters)this.getParameters()).getMinAgpVersion().get();
        Intrinsics.checkNotNull((Object)minAgpVersion);
        AgpVersion agpVersion = AgpVersion.Companion.tryParseStable(minAgpVersion);
        if (agpVersion == null) {
            throw new RuntimeException("The specified minAgpVersion (" + minAgpVersion + ") is not valid. The minAgpVersion must be a stable AGP version, formatted with major, minor, and micro values (for example \"4.0.0\").");
        }
        AgpVersion parsedMinAgpVersion = agpVersion;
        String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        AgpVersion currentAgpVersion = AgpVersion.Companion.parse(string);
        if (parsedMinAgpVersion.compareTo(currentAgpVersion) > 0) {
            throw new RuntimeException("The specified minAgpVersion (" + minAgpVersion + ") is not valid because it is a later version than the version of AGP used for this build (" + currentAgpVersion + ").");
        }
        File file = ((RegularFile)((AarMetadataWorkParameters)this.getParameters()).getOutput().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        Object object = ((AarMetadataWorkParameters)this.getParameters()).getAarFormatVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String string2 = (String)object;
        Object object2 = ((AarMetadataWorkParameters)this.getParameters()).getAarMetadataVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        String string3 = (String)object2;
        Object object3 = ((AarMetadataWorkParameters)this.getParameters()).getMinCompileSdk().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        int n = ((Number)object3).intValue();
        Object object4 = ((AarMetadataWorkParameters)this.getParameters()).getMinCompileSdkExtension().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        int n2 = ((Number)object4).intValue();
        Object object5 = ((AarMetadataWorkParameters)this.getParameters()).getMinAgpVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
        String string4 = (String)object5;
        String string5 = (String)((AarMetadataWorkParameters)this.getParameters()).getForceCompileSdkPreview().getOrNull();
        Object object6 = ((AarMetadataWorkParameters)this.getParameters()).getCoreLibraryDesugaringEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
        AarMetadataTaskKt.writeAarMetadataFile(file, string2, string3, n, n2, string4, string5, (Boolean)object6, (String)((AarMetadataWorkParameters)this.getParameters()).getDesugarJdkLibId().getOrNull());
    }
}

