/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.ManagedVirtualDeviceLockManager;
import com.android.builder.utils.ExceptionConsumer;
import com.android.builder.utils.ExceptionFunction;
import com.android.builder.utils.SynchronizedFile;
import com.android.prefs.AndroidLocationsProvider;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001$B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\bJ\b\u0010\u0019\u001a\u00020\bH\u0007J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u001b\u001a\u00060\u001cR\u00020\u00002\b\b\u0002\u0010\u001d\u001a\u00020\u0005J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0018\u0010\"\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0005H\u0002R\u001a\u0010\n\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager;", "", "androidLocationsProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "maxGMDs", "", "retryWaitAction", "Lkotlin/Function0;", "", "(Lcom/android/prefs/AndroidLocationsProvider;ILkotlin/jvm/functions/Function0;)V", "devicesInProcess", "getDevicesInProcess$annotations", "()V", "getDevicesInProcess", "()I", "logger", "Lorg/gradle/api/logging/Logger;", "trackedDevicesInProcess", "Ljava/util/concurrent/atomic/AtomicInteger;", "trackingFile", "Lcom/android/builder/utils/SynchronizedFile;", "createDefaultLockFile", "file", "Ljava/io/File;", "deleteLockFile", "executeShutdown", "getCurrentLockCount", "lock", "Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager$DeviceLock;", "lockCount", "releaseLocks", "locksToRelease", "tryToAcquireLocks", "locksRequested", "writeLockCount", "newLockCount", "DeviceLock", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nManagedVirtualDeviceLockManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedVirtualDeviceLockManager.kt\ncom/android/build/gradle/internal/ManagedVirtualDeviceLockManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n1855#2,2:242\n*S KotlinDebug\n*F\n+ 1 ManagedVirtualDeviceLockManager.kt\ncom/android/build/gradle/internal/ManagedVirtualDeviceLockManager\n*L\n212#1:242,2\n*E\n"})
public final class ManagedVirtualDeviceLockManager {
    private final int maxGMDs;
    @NotNull
    private final Function0<Unit> retryWaitAction;
    @NotNull
    private final SynchronizedFile trackingFile;
    @NotNull
    private final AtomicInteger trackedDevicesInProcess;
    @NotNull
    private final Logger logger;

    public ManagedVirtualDeviceLockManager(@NotNull AndroidLocationsProvider androidLocationsProvider, int maxGMDs, @NotNull Function0<Unit> retryWaitAction) {
        Intrinsics.checkNotNullParameter((Object)androidLocationsProvider, (String)"androidLocationsProvider");
        Intrinsics.checkNotNullParameter(retryWaitAction, (String)"retryWaitAction");
        this.maxGMDs = maxGMDs;
        this.retryWaitAction = retryWaitAction;
        File file = androidLocationsProvider.getGradleAvdLocation().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File lockFile = FilesKt.resolve((File)file, (String)"active_gradle_devices");
        if (!lockFile.getParentFile().exists()) {
            lockFile.getParentFile().mkdirs();
        }
        this.trackedDevicesInProcess = new AtomicInteger();
        SynchronizedFile synchronizedFile = SynchronizedFile.getInstanceWithMultiProcessLocking((File)lockFile);
        Intrinsics.checkNotNullExpressionValue((Object)synchronizedFile, (String)"getInstanceWithMultiProcessLocking(...)");
        this.trackingFile = synchronizedFile;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public final void run() {
                new Function0<Unit>((Object)this){

                    public final void invoke() {
                        ((ManagedVirtualDeviceLockManager)this.receiver).executeShutdown();
                    }
                };
            }
        }));
        Logger logger = Logging.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public /* synthetic */ ManagedVirtualDeviceLockManager(AndroidLocationsProvider androidLocationsProvider, int n, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            function0 = 1.INSTANCE;
        }
        this(androidLocationsProvider, n, (Function0<Unit>)function0);
    }

    public final int getDevicesInProcess() {
        return this.trackedDevicesInProcess.get();
    }

    @VisibleForTesting
    public static /* synthetic */ void getDevicesInProcess$annotations() {
    }

    @NotNull
    public final DeviceLock lock(int lockCount) {
        int locksAcquired = 0;
        while ((locksAcquired = this.tryToAcquireLocks(lockCount)) == 0) {
            this.retryWaitAction.invoke();
        }
        return new DeviceLock(locksAcquired);
    }

    public static /* synthetic */ DeviceLock lock$default(ManagedVirtualDeviceLockManager managedVirtualDeviceLockManager, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return managedVirtualDeviceLockManager.lock(n);
    }

    private final void releaseLocks(int locksToRelease) {
        if (locksToRelease <= 0) {
            if (locksToRelease < 0) {
                this.logger.log(LogLevel.WARN, StringsKt.trimIndent((String)("\n                        Attempting to free a negative number of locks.\n                        Locks to release: " + locksToRelease + "\n                    ")));
            }
            return;
        }
        this.trackingFile.write(new ExceptionFunction(this, locksToRelease){
            final /* synthetic */ ManagedVirtualDeviceLockManager this$0;
            final /* synthetic */ int $locksToRelease;
            {
                this.this$0 = $receiver;
                this.$locksToRelease = $locksToRelease;
            }

            public final void accept(File file) {
                int n;
                Intrinsics.checkNotNull((Object)file);
                int currentTotalDeviceCount = ManagedVirtualDeviceLockManager.access$getCurrentLockCount(this.this$0, file);
                if (this.this$0.getDevicesInProcess() < this.$locksToRelease) {
                    ManagedVirtualDeviceLockManager.access$getLogger$p(this.this$0).log(LogLevel.WARN, StringsKt.trimIndent((String)("\n                        Attempting to free more locks than have been claimed by this lock manager.\n                        Locks to release: " + this.$locksToRelease + " Locks available In Process: " + this.this$0.getDevicesInProcess() + "\n                    ")));
                    n = currentTotalDeviceCount - ManagedVirtualDeviceLockManager.access$getTrackedDevicesInProcess$p(this.this$0).getAndSet(0);
                } else {
                    ManagedVirtualDeviceLockManager.access$getTrackedDevicesInProcess$p(this.this$0).addAndGet(-this.$locksToRelease);
                    n = currentTotalDeviceCount - this.$locksToRelease;
                }
                int newTotalDevicesCount = n;
                ManagedVirtualDeviceLockManager.access$writeLockCount(this.this$0, file, newTotalDevicesCount);
            }
        });
    }

    private final int tryToAcquireLocks(int locksRequested) {
        this.trackingFile.createIfAbsent(new ExceptionConsumer(this){
            final /* synthetic */ ManagedVirtualDeviceLockManager this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(File file) {
                Intrinsics.checkNotNull((Object)file);
                ManagedVirtualDeviceLockManager.access$createDefaultLockFile(this.this$0, file);
            }
        });
        Object object = this.trackingFile.write(new ExceptionFunction(this, locksRequested){
            final /* synthetic */ ManagedVirtualDeviceLockManager this$0;
            final /* synthetic */ int $locksRequested;
            {
                this.this$0 = $receiver;
                this.$locksRequested = $locksRequested;
            }

            public final Integer accept(File file) {
                Intrinsics.checkNotNull((Object)file);
                int currentTotalDevicesCount = ManagedVirtualDeviceLockManager.access$getCurrentLockCount(this.this$0, file);
                int locksToClaim = Math.max(Math.min(this.$locksRequested, ManagedVirtualDeviceLockManager.access$getMaxGMDs$p(this.this$0) - currentTotalDevicesCount), 0);
                if (locksToClaim != 0) {
                    ManagedVirtualDeviceLockManager.access$writeLockCount(this.this$0, file, currentTotalDevicesCount + locksToClaim);
                    ManagedVirtualDeviceLockManager.access$getTrackedDevicesInProcess$p(this.this$0).addAndGet(locksToClaim);
                }
                return locksToClaim;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"write(...)");
        return ((Number)object).intValue();
    }

    public final void deleteLockFile() {
        this.trackingFile.write((ExceptionFunction)deleteLockFile.1.INSTANCE);
    }

    private final void createDefaultLockFile(File file) {
        this.logger.info("Creating default GMD lock tracking file at " + file.getAbsolutePath());
        FilesKt.writeText$default((File)file, (String)"MDLockCount 0", null, (int)2, null);
    }

    private final int getCurrentLockCount(File file) {
        if (file.exists()) {
            for (String line : FilesKt.readLines$default((File)file, null, (int)1, null)) {
                if (!StringsKt.startsWith$default((String)line, (String)"MDLockCount", (boolean)false, (int)2, null)) continue;
                String string = line.substring(11);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return Integer.parseInt(((Object)StringsKt.trim((CharSequence)string)).toString());
            }
            this.logger.error(" Failed to find MDLockCount in gmd lock file. File Contents:\n " + FilesKt.readLines$default((File)file, null, (int)1, null));
            this.writeLockCount(file, 0);
            throw new IllegalStateException("Failed to find the number of active Gradle Managed Devices.".toString());
        }
        return 0;
    }

    private final void writeLockCount(File file, int newLockCount) {
        List lines = FilesKt.readLines$default((File)file, null, (int)1, null);
        FilesKt.writeText$default((File)file, (String)"", null, (int)2, null);
        FilesKt.appendText$default((File)file, (String)("MDLockCount " + newLockCount), null, (int)2, null);
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)line, (String)"MDLockCount", (boolean)false, (int)2, null)) continue;
            FilesKt.appendText$default((File)file, (String)("\n" + line), null, (int)2, null);
        }
    }

    @VisibleForTesting
    public final void executeShutdown() {
        this.releaseLocks(this.trackedDevicesInProcess.get());
    }

    public static final /* synthetic */ int access$getCurrentLockCount(ManagedVirtualDeviceLockManager $this, File file) {
        return $this.getCurrentLockCount(file);
    }

    public static final /* synthetic */ Logger access$getLogger$p(ManagedVirtualDeviceLockManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ AtomicInteger access$getTrackedDevicesInProcess$p(ManagedVirtualDeviceLockManager $this) {
        return $this.trackedDevicesInProcess;
    }

    public static final /* synthetic */ void access$writeLockCount(ManagedVirtualDeviceLockManager $this, File file, int newLockCount) {
        $this.writeLockCount(file, newLockCount);
    }

    public static final /* synthetic */ void access$createDefaultLockFile(ManagedVirtualDeviceLockManager $this, File file) {
        $this.createDefaultLockFile(file);
    }

    public static final /* synthetic */ int access$getMaxGMDs$p(ManagedVirtualDeviceLockManager $this) {
        return $this.maxGMDs;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager$DeviceLock;", "Ljava/io/Closeable;", "lockCount", "", "(Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager;I)V", "<set-?>", "", "closed", "getClosed", "()Z", "getLockCount", "()I", "close", "", "gradle-core"})
    public final class DeviceLock
    implements Closeable {
        private final int lockCount;
        private boolean closed;

        public DeviceLock(int lockCount) {
            this.lockCount = lockCount;
        }

        public final int getLockCount() {
            return this.lockCount;
        }

        public final boolean getClosed() {
            return this.closed;
        }

        @Override
        public void close() {
            if (!this.closed) {
                ManagedVirtualDeviceLockManager.this.releaseLocks(this.lockCount);
                this.closed = true;
            }
        }
    }
}

