/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResource;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 B2\u00020\u0001:\u0001BB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010-\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140.j\u0002`/J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0014H\u0007J\b\u00103\u001a\u00020\nH\u0007J\b\u00104\u001a\u00020\nH\u0007J\u0006\u00105\u001a\u00020\nJ\u0006\u00106\u001a\u00020\nJ\u0006\u00107\u001a\u00020\nJ\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018J\u0006\u00109\u001a\u00020\nJ\b\u0010:\u001a\u0004\u0018\u00010\nJ\b\u0010;\u001a\u0004\u0018\u00010\nJ\u0006\u0010<\u001a\u00020\nJ\u000e\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u0014J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001e\u001a\u00020\u0014J\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u00182\u0006\u0010\u001e\u001a\u00020\u0014R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0016R\u0011\u0010\u001e\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b$\u0010%\u001a\u0004\b&\u0010\fR\u0011\u0010'\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\bR\u0011\u0010)\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\fR\u0011\u0010+\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0016\u00a8\u0006C"}, d2={"Lcom/android/build/gradle/internal/scope/ProjectInfo;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "buildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getBuildDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "buildFile", "Ljava/io/File;", "getBuildFile", "()Ljava/io/File;", "defaultProjectCapability", "Lorg/gradle/api/capabilities/Capability;", "getDefaultProjectCapability", "()Lorg/gradle/api/capabilities/Capability;", "gradleUserHomeDir", "getGradleUserHomeDir", "group", "", "getGroup", "()Ljava/lang/String;", "intermediatesDirectory", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getIntermediatesDirectory", "()Lorg/gradle/api/provider/Provider;", "name", "getName", "path", "getPath", "projectDirectory", "getProjectDirectory", "()Lorg/gradle/api/file/Directory;", "rootBuildDir", "getRootBuildDir$annotations", "()V", "getRootBuildDir", "rootBuildDirectory", "getRootBuildDirectory", "rootDir", "getRootDir", "version", "getVersion", "computeBuildMapping", "Lcom/google/common/collect/ImmutableMap;", "Lcom/android/build/gradle/internal/ide/dependencies/BuildMapping;", "createTestResources", "Lorg/gradle/api/resources/TextResource;", "value", "getBuildDir", "getIntermediatesDir", "getJacocoAgent", "getJacocoAgentOutputDirectory", "getOutputsDir", "getProjectBaseName", "getReportsDir", "getTestReportFolder", "getTestResultsFolder", "getTmpFolder", "hasPlugin", "", "plugin", "intermediatesFile", "Lorg/gradle/api/file/RegularFile;", "Companion", "gradle-core"})
public final class ProjectInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public ProjectInfo(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Provider<String> getProjectBaseName() {
        return Companion.getBaseName(this.project);
    }

    @NotNull
    public final String getPath() {
        String string = this.project.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
        return string;
    }

    @NotNull
    public final String getName() {
        String string = this.project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        return string;
    }

    @NotNull
    public final String getGroup() {
        return this.project.getGroup().toString();
    }

    @NotNull
    public final String getVersion() {
        return this.project.getVersion().toString();
    }

    @NotNull
    public final Capability getDefaultProjectCapability() {
        return (Capability)new ImmutableCapability(this.project.getGroup().toString(), this.project.getName(), "unspecified");
    }

    @NotNull
    public final Directory getProjectDirectory() {
        Directory directory2 = this.project.getLayout().getProjectDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)directory2, (String)"project.layout.projectDirectory");
        return directory2;
    }

    @NotNull
    public final File getBuildFile() {
        File file = this.project.getBuildFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildFile");
        return file;
    }

    @NotNull
    public final DirectoryProperty getBuildDirectory() {
        DirectoryProperty directoryProperty = this.project.getLayout().getBuildDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.layout.buildDirectory");
        return directoryProperty;
    }

    @NotNull
    public final File getRootDir() {
        File file = this.project.getRootDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootDir");
        return file;
    }

    @NotNull
    public final File getRootBuildDir() {
        File file = this.project.getRootProject().getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootProject.buildDir");
        return file;
    }

    @Deprecated(message="Use rootBuildDirectory")
    public static /* synthetic */ void getRootBuildDir$annotations() {
    }

    @NotNull
    public final DirectoryProperty getRootBuildDirectory() {
        DirectoryProperty directoryProperty = this.project.getRootProject().getLayout().getBuildDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.rootProject.layout.buildDirectory");
        return directoryProperty;
    }

    @NotNull
    public final File getGradleUserHomeDir() {
        File file = this.project.getGradle().getGradleUserHomeDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.gradle.gradleUserHomeDir");
        return file;
    }

    @NotNull
    public final Provider<Directory> getIntermediatesDirectory() {
        Provider provider2 = this.project.getLayout().getBuildDirectory().dir("intermediates");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.layout.buildDire\u2026nstants.FD_INTERMEDIATES)");
        return provider2;
    }

    @NotNull
    public final Provider<Directory> intermediatesDirectory(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Provider provider2 = this.project.getLayout().getBuildDirectory().dir("intermediates").map(new Transformer(path){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
            }

            public final Directory transform(Directory it) {
                return it.dir(this.$path);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"path: String): Provider<\u2026   it.dir(path)\n        }");
        return provider2;
    }

    @NotNull
    public final Provider<RegularFile> intermediatesFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Provider provider2 = this.project.getLayout().getBuildDirectory().dir("intermediates").map(new Transformer(path){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
            }

            public final RegularFile transform(Directory it) {
                return it.file(this.$path);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"path: String): Provider<\u2026  it.file(path)\n        }");
        return provider2;
    }

    @Deprecated(message="DO NOT USE - Only use the new Gradle Property objects")
    @NotNull
    public final TextResource createTestResources(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TextResource textResource = this.project.getResources().getText().fromString(value);
        Intrinsics.checkNotNullExpressionValue((Object)textResource, (String)"project.resources.text.fromString(value)");
        return textResource;
    }

    public final boolean hasPlugin(@NotNull String plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        return this.project.getPlugins().hasPlugin(plugin);
    }

    @Deprecated(message="Use buildDirectory instead")
    @NotNull
    public final File getBuildDir() {
        File file = this.project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        return file;
    }

    @Nullable
    public final File getTestResultsFolder() {
        return new File(this.getBuildDir(), "test-results");
    }

    @NotNull
    public final File getReportsDir() {
        return new File(this.getBuildDir(), "reports");
    }

    @Nullable
    public final File getTestReportFolder() {
        return new File(this.getBuildDir(), "reports/tests");
    }

    @Deprecated(message="Use the version that returns a provider")
    @NotNull
    public final File getIntermediatesDir() {
        return new File(this.getBuildDir(), "intermediates");
    }

    @NotNull
    public final File getTmpFolder() {
        return new File(this.getIntermediatesDir(), "tmp");
    }

    @NotNull
    public final File getOutputsDir() {
        return new File(this.getBuildDir(), "outputs");
    }

    @NotNull
    public final File getJacocoAgentOutputDirectory() {
        return new File(this.getIntermediatesDir(), "jacoco");
    }

    @NotNull
    public final File getJacocoAgent() {
        return new File(this.getJacocoAgentOutputDirectory(), "jacocoagent.jar");
    }

    @NotNull
    public final ImmutableMap<String, String> computeBuildMapping() {
        Gradle gradle = this.project.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
        return BuildMappingUtils.computeBuildMapping(gradle);
    }

    @JvmStatic
    @NotNull
    public static final Provider<String> getBaseName(@NotNull Project $this$getBaseName) {
        return Companion.getBaseName($this$getBaseName);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/scope/ProjectInfo$Companion;", "", "()V", "getBaseName", "Lorg/gradle/api/provider/Provider;", "", "Lorg/gradle/api/Project;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Provider<String> getBaseName(@NotNull Project $this$getBaseName) {
            Intrinsics.checkNotNullParameter((Object)$this$getBaseName, (String)"<this>");
            Property property = ((BasePluginExtension)$this$getBaseName.getExtensions().getByType(BasePluginExtension.class)).getArchivesName();
            Intrinsics.checkNotNullExpressionValue((Object)property, (String)"this.extensions.getByTyp\u2026:class.java).archivesName");
            return (Provider)property;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

