/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.mlkit;

import com.android.tools.mlkit.DataInputOutputUtils;
import com.android.tools.mlkit.MetadataExtractor;
import com.android.tools.mlkit.ModelVerifier;
import com.android.tools.mlkit.TensorInfo;
import com.android.tools.mlkit.TfliteModelException;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.tensorflow.lite.support.metadata.schema.ModelMetadata;

public class ModelInfo {
    public static final String PARSER_VERSION = "1.0.0";
    private final long modelSize;
    private final String modelHash;
    private final boolean metadataExisted;
    private final String modelName;
    private final String modelDescription;
    private final String modelVersion;
    private final String modelAuthor;
    private final String modelLicense;
    private final String minParserVersion;
    private final List<TensorInfo> inputs;
    private final List<TensorInfo> outputs;

    public ModelInfo(long modelSize, String modelHash, ModelMetadata modelMetadata) {
        this.modelSize = modelSize;
        this.modelHash = modelHash;
        if (modelMetadata != null) {
            this.metadataExisted = true;
            this.modelName = Strings.nullToEmpty((String)modelMetadata.name());
            this.modelDescription = Strings.nullToEmpty((String)modelMetadata.description());
            this.modelVersion = Strings.nullToEmpty((String)modelMetadata.version());
            this.modelAuthor = Strings.nullToEmpty((String)modelMetadata.author());
            this.modelLicense = Strings.nullToEmpty((String)modelMetadata.license());
            this.minParserVersion = Strings.nullToEmpty((String)modelMetadata.minParserVersion());
        } else {
            this.metadataExisted = false;
            this.modelName = "";
            this.modelDescription = "";
            this.modelVersion = "";
            this.modelAuthor = "";
            this.modelLicense = "";
            this.minParserVersion = "";
        }
        this.inputs = new ArrayList<TensorInfo>();
        this.outputs = new ArrayList<TensorInfo>();
    }

    public ModelInfo(DataInput in) throws IOException {
        this.modelSize = in.readLong();
        this.modelHash = in.readUTF();
        this.metadataExisted = in.readBoolean();
        this.modelName = in.readUTF();
        this.modelDescription = in.readUTF();
        this.modelVersion = in.readUTF();
        this.modelAuthor = in.readUTF();
        this.modelLicense = in.readUTF();
        this.minParserVersion = in.readUTF();
        this.inputs = DataInputOutputUtils.readTensorInfoList(in);
        this.outputs = DataInputOutputUtils.readTensorInfoList(in);
    }

    public void save(DataOutput out) throws IOException {
        out.writeLong(this.modelSize);
        out.writeUTF(this.modelHash);
        out.writeBoolean(this.metadataExisted);
        out.writeUTF(this.modelName);
        out.writeUTF(this.modelDescription);
        out.writeUTF(this.modelVersion);
        out.writeUTF(this.modelAuthor);
        out.writeUTF(this.modelLicense);
        out.writeUTF(this.minParserVersion);
        DataInputOutputUtils.writeTensorInfoList(out, this.inputs);
        DataInputOutputUtils.writeTensorInfoList(out, this.outputs);
    }

    public long getModelSize() {
        return this.modelSize;
    }

    public String getModelHash() {
        return this.modelHash;
    }

    public boolean isMetadataExisted() {
        return this.metadataExisted;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelDescription() {
        return this.modelDescription;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getModelAuthor() {
        return this.modelAuthor;
    }

    public String getModelLicense() {
        return this.modelLicense;
    }

    public String getMinParserVersion() {
        return this.minParserVersion;
    }

    public List<TensorInfo> getInputs() {
        return this.inputs;
    }

    public List<TensorInfo> getOutputs() {
        return this.outputs;
    }

    public boolean isMetadataVersionTooHigh() {
        return ModelInfo.isMetadataVersionTooHigh(this.minParserVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelInfo that = (ModelInfo)o;
        return this.modelSize == that.modelSize && this.modelHash.equals(that.modelHash) && this.metadataExisted == that.metadataExisted && this.modelName.equals(that.modelName) && this.modelDescription.equals(that.modelDescription) && this.modelVersion.equals(that.modelVersion) && this.modelAuthor.equals(that.modelAuthor) && this.modelLicense.equals(that.modelLicense) && this.minParserVersion.equals(that.minParserVersion) && this.inputs.equals(that.inputs) && this.outputs.equals(that.outputs);
    }

    public int hashCode() {
        return this.modelHash.hashCode();
    }

    public static ModelInfo buildFrom(ByteBuffer byteBuffer) throws TfliteModelException {
        ModelVerifier.verifyModel(byteBuffer);
        String modelHash = Hashing.sha256().hashBytes(byteBuffer.array()).toString();
        MetadataExtractor extractor = new MetadataExtractor(byteBuffer);
        ModelMetadata modelMetadata = extractor.getModelMetaData();
        ModelInfo modelInfo = new ModelInfo(byteBuffer.remaining(), modelHash, modelMetadata);
        int inputLength = extractor.getInputTensorCount();
        for (int i2 = 0; i2 < inputLength; ++i2) {
            modelInfo.inputs.add(TensorInfo.parseFrom(extractor, TensorInfo.Source.INPUT, i2));
        }
        int outputLength = extractor.getOutputTensorCount();
        for (int i3 = 0; i3 < outputLength; ++i3) {
            modelInfo.outputs.add(TensorInfo.parseFrom(extractor, TensorInfo.Source.OUTPUT, i3));
        }
        return modelInfo;
    }

    static boolean isMetadataVersionTooHigh(String minParserVersion) {
        if (Strings.isNullOrEmpty((String)minParserVersion)) {
            return false;
        }
        return MetadataExtractor.compareVersions(PARSER_VERSION, minParserVersion) < 0;
    }
}

