/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.options;

import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.Option;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ReplacedOption;
import com.android.build.gradle.options.StringOption;
import com.android.builder.model.OptionalCompilationStep;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.gradle.api.Project;

public final class ProjectOptions {
    public static final String PROPERTY_TEST_RUNNER_ARGS = "android.testInstrumentationRunnerArguments.";
    private final ImmutableMap<ReplacedOption, String> replacedOptions;
    private final ImmutableMap<BooleanOption, Boolean> booleanOptions;
    private final ImmutableMap<OptionalBooleanOption, Boolean> optionalBooleanOptions;
    private final ImmutableMap<IntegerOption, Integer> integerOptions;
    private final ImmutableMap<StringOption, String> stringOptions;
    private final ImmutableMap<String, String> testRunnerArgs;

    public ProjectOptions(ImmutableMap<String, Object> properties) {
        this.replacedOptions = ProjectOptions.readOptions((Option[])ReplacedOption.values(), properties);
        this.booleanOptions = ProjectOptions.readOptions((Option[])BooleanOption.values(), properties);
        this.optionalBooleanOptions = ProjectOptions.readOptions((Option[])OptionalBooleanOption.values(), properties);
        this.integerOptions = ProjectOptions.readOptions((Option[])IntegerOption.values(), properties);
        this.stringOptions = ProjectOptions.readOptions((Option[])StringOption.values(), properties);
        this.testRunnerArgs = ProjectOptions.readTestRunnerArgs(properties);
    }

    public ProjectOptions(Project project2) {
        this(ProjectOptions.copyProperties(project2));
    }

    public ProjectOptions(Project project2, ImmutableMap<String, Object> overwrites) {
        this(ProjectOptions.copyAndModifyProperties(project2, overwrites));
    }

    private static ImmutableMap<String, Object> copyProperties(Project project2) {
        return ProjectOptions.copyAndModifyProperties(project2, (ImmutableMap<String, Object>)ImmutableMap.of());
    }

    private static ImmutableMap<String, Object> copyAndModifyProperties(Project project2, ImmutableMap<String, Object> overwrites) {
        ImmutableMap.Builder optionsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : project2.getExtensions().getExtraProperties().getProperties().entrySet()) {
            Object value = entry.getValue();
            if (value == null || overwrites.containsKey(entry.getKey())) continue;
            optionsBuilder.put(entry.getKey(), value);
        }
        for (Map.Entry overwrite : overwrites.entrySet()) {
            optionsBuilder.put(overwrite.getKey(), overwrite.getValue());
        }
        return optionsBuilder.build();
    }

    private static <OptionT extends Option<ValueT>, ValueT> ImmutableMap<OptionT, ValueT> readOptions(OptionT[] values, Map<String, ?> properties) {
        Map<String, Option> optionLookup = Arrays.stream(values).collect(Collectors.toMap(Option::getPropertyName, v -> v));
        ImmutableMap.Builder valuesBuilder = ImmutableMap.builder();
        for (Map.Entry<String, ?> property : properties.entrySet()) {
            Option option = optionLookup.get(property.getKey());
            if (option == null) continue;
            Object value = option.parse(property.getValue());
            valuesBuilder.put((Object)option, value);
        }
        return valuesBuilder.build();
    }

    private static ImmutableMap<String, String> readTestRunnerArgs(Map<String, ?> properties) {
        ImmutableMap.Builder testRunnerArgsBuilder = ImmutableMap.builder();
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            String name2 = entry.getKey();
            if (!name2.startsWith(PROPERTY_TEST_RUNNER_ARGS)) continue;
            String argName = name2.substring(PROPERTY_TEST_RUNNER_ARGS.length());
            String argValue = entry.getValue().toString();
            testRunnerArgsBuilder.put((Object)argName, (Object)argValue);
        }
        return testRunnerArgsBuilder.build();
    }

    public boolean get(BooleanOption option) {
        return (Boolean)this.booleanOptions.getOrDefault((Object)option, (Object)option.getDefaultValue());
    }

    public Boolean get(OptionalBooleanOption option) {
        return (Boolean)this.optionalBooleanOptions.get((Object)option);
    }

    public Integer get(IntegerOption option) {
        return (Integer)this.integerOptions.getOrDefault((Object)option, (Object)option.getDefaultValue());
    }

    public String get(StringOption option) {
        return (String)this.stringOptions.getOrDefault((Object)option, (Object)option.getDefaultValue());
    }

    public Map<String, String> getExtraInstrumentationTestRunnerArgs() {
        return this.testRunnerArgs;
    }

    public Set<OptionalCompilationStep> getOptionalCompilationSteps() {
        String values = this.get(StringOption.IDE_OPTIONAL_COMPILATION_STEPS);
        if (values != null) {
            ArrayList<OptionalCompilationStep> optionalCompilationSteps = new ArrayList<OptionalCompilationStep>();
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreElements()) {
                optionalCompilationSteps.add(OptionalCompilationStep.valueOf((String)st.nextToken()));
            }
            return EnumSet.copyOf(optionalCompilationSteps);
        }
        return EnumSet.noneOf(OptionalCompilationStep.class);
    }

    public ImmutableMap<BooleanOption, Boolean> getExplicitlySetBooleanOptions() {
        return this.booleanOptions;
    }

    public ImmutableMap<OptionalBooleanOption, Boolean> getExplicitlySetOptionalBooleanOptions() {
        return this.optionalBooleanOptions;
    }

    public ImmutableMap<IntegerOption, Integer> getExplicitlySetIntegerOptions() {
        return this.integerOptions;
    }

    public ImmutableMap<StringOption, String> getExplicitlySetStringOptions() {
        return this.stringOptions;
    }

    public ImmutableMap<Option<?>, Object> getAllOptions() {
        return new ImmutableMap.Builder().putAll(this.replacedOptions).putAll(this.booleanOptions).putAll(this.optionalBooleanOptions).putAll(this.integerOptions).putAll(this.stringOptions).build();
    }
}

