/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.api.variant.VariantOutputConfiguration;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.BuiltArtifactsSplitOutputMatcher;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/test/TestDataImpl;", "Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;", "testConfig", "Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;", "testApkDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "testedApksDir", "Lorg/gradle/api/file/FileCollection;", "(Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/file/FileCollection;)V", "isLibrary", "", "()Z", "getTestedApks", "Lcom/google/common/collect/ImmutableList;", "Ljava/io/File;", "deviceConfigProvider", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "logger", "Lcom/android/utils/ILogger;", "gradle"})
public final class TestDataImpl
extends AbstractTestDataImpl {
    private final AndroidTestCreationConfig testConfig;

    @Override
    public boolean isLibrary() {
        return this.testConfig.getTestedConfig().getVariantType().isAar();
    }

    @NotNull
    public ImmutableList<File> getTestedApks(@NotNull DeviceConfigProvider deviceConfigProvider, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)deviceConfigProvider, (String)"deviceConfigProvider");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        VariantCreationConfig testedConfig = this.testConfig.getTestedConfig();
        ImmutableList.Builder apks = ImmutableList.builder();
        BuiltArtifactsLoaderImpl builtArtifactsLoaderImpl = new BuiltArtifactsLoaderImpl();
        Object object = testedConfig.getArtifacts().get(InternalArtifactType.APK.INSTANCE).get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"testedConfig\n           \u2026                   .get()");
        BuiltArtifactsImpl builtArtifactsImpl = builtArtifactsLoaderImpl.load((Directory)object);
        if (builtArtifactsImpl == null) {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
            return immutableList;
        }
        BuiltArtifactsImpl builtArtifacts = builtArtifactsImpl;
        apks.addAll((Iterable)BuiltArtifactsSplitOutputMatcher.INSTANCE.computeBestOutput(deviceConfigProvider, builtArtifacts, (Collection<String>)testedConfig.getVariantDslInfo().getSupportedAbis()));
        ImmutableList immutableList = apks.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"apks.build()");
        return immutableList;
    }

    public TestDataImpl(@NotNull AndroidTestCreationConfig testConfig, @NotNull Provider<Directory> testApkDir, @Nullable FileCollection testedApksDir) {
        Intrinsics.checkParameterIsNotNull((Object)testConfig, (String)"testConfig");
        Intrinsics.checkParameterIsNotNull(testApkDir, (String)"testApkDir");
        super(testConfig, testConfig.getVariantSources(), testApkDir, testedApksDir);
        this.testConfig = testConfig;
        Collection collection = this.testConfig.getOutputs().getSplitsByType(VariantOutputConfiguration.OutputType.ONE_OF_MANY);
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw (Throwable)new RuntimeException("Multi-output in test variant not yet supported");
        }
    }
}

