/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.namespaced;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.res.LinkApplicationAndroidResourcesTask;
import com.android.build.gradle.internal.res.namespaced.CompileRClassTaskCreationAction;
import com.android.build.gradle.internal.res.namespaced.CompileSourceSetResources;
import com.android.build.gradle.internal.res.namespaced.CreateNonNamespacedLibraryManifestTask;
import com.android.build.gradle.internal.res.namespaced.GenerateNamespacedLibraryRFilesTask;
import com.android.build.gradle.internal.res.namespaced.LinkLibraryAndroidResourcesTask;
import com.android.build.gradle.internal.res.namespaced.ProcessAndroidAppResourcesTask;
import com.android.build.gradle.internal.res.namespaced.StaticLibraryManifestTask;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.utils.StringHelper;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0002J&\u0010\u0014\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/NamespacedResourcesTaskManager;", "", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "taskFactory", "Lcom/android/build/gradle/internal/tasks/factory/TaskFactory;", "componentProperties", "Lcom/android/build/api/component/impl/ComponentPropertiesImpl;", "(Lcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/build/gradle/internal/tasks/factory/TaskFactory;Lcom/android/build/api/component/impl/ComponentPropertiesImpl;)V", "createCompileResourcesTask", "", "createNamespacedAppProcessTask", "packageOutputType", "Lcom/android/build/api/artifact/Artifact$SingleArtifact;", "Lorg/gradle/api/file/Directory;", "baseName", "", "useAaptToGenerateLegacyMultidexMainDexProguardRules", "", "createNamespacedLibraryTestProcessResourcesTask", "createNamespacedResourceTasks", "gradle"})
public final class NamespacedResourcesTaskManager {
    private final GlobalScope globalScope;
    private final TaskFactory taskFactory;
    private final ComponentPropertiesImpl componentProperties;

    public final void createNamespacedResourceTasks(@Nullable Artifact.SingleArtifact<Directory> packageOutputType, @NotNull String baseName2, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules) {
        Intrinsics.checkParameterIsNotNull((Object)baseName2, (String)"baseName");
        this.createCompileResourcesTask();
        this.taskFactory.register(new CreateNonNamespacedLibraryManifestTask.CreationAction(this.componentProperties));
        this.taskFactory.register(new StaticLibraryManifestTask.CreationAction(this.componentProperties));
        this.taskFactory.register(new LinkLibraryAndroidResourcesTask.CreationAction(this.componentProperties));
        this.taskFactory.register(new GenerateNamespacedLibraryRFilesTask.CreationAction(this.componentProperties));
        if (this.componentProperties.getVariantType().isTestComponent()) {
            VariantCreationConfig variantCreationConfig = this.componentProperties.getTestedConfig();
            if (variantCreationConfig == null || (variantCreationConfig = variantCreationConfig.getVariantType()) == null) {
                throw (Throwable)new RuntimeException("testedVariant is null");
            }
            VariantCreationConfig testedType = variantCreationConfig;
            if (testedType.isAar()) {
                this.createNamespacedLibraryTestProcessResourcesTask(packageOutputType);
            } else {
                this.createNamespacedAppProcessTask(packageOutputType, baseName2, false);
            }
        } else if (this.componentProperties.getVariantType().isApk()) {
            this.createNamespacedAppProcessTask(packageOutputType, baseName2, useAaptToGenerateLegacyMultidexMainDexProguardRules);
        }
        this.taskFactory.register(new CompileRClassTaskCreationAction(this.componentProperties));
    }

    private final void createNamespacedAppProcessTask(Artifact.SingleArtifact<Directory> packageOutputType, String baseName2, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules) {
        ComponentPropertiesImpl componentPropertiesImpl = this.componentProperties;
        if (componentPropertiesImpl == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.component.ApkCreationConfig");
        }
        this.taskFactory.register(new LinkApplicationAndroidResourcesTask.NamespacedCreationAction((ApkCreationConfig)((Object)componentPropertiesImpl), useAaptToGenerateLegacyMultidexMainDexProguardRules, baseName2));
        if (packageOutputType != null) {
            this.componentProperties.getArtifacts().republish(InternalArtifactType.PROCESSED_RES.INSTANCE, packageOutputType);
        }
    }

    private final void createNamespacedLibraryTestProcessResourcesTask(Artifact.SingleArtifact<Directory> packageOutputType) {
        this.taskFactory.register(new ProcessAndroidAppResourcesTask.CreationAction(this.componentProperties));
        if (packageOutputType != null) {
            this.componentProperties.getArtifacts().republish(InternalArtifactType.PROCESSED_RES.INSTANCE, packageOutputType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createCompileResourcesTask() {
        Object object = this.componentProperties.getVariantData().getAndroidResources();
        boolean bl = false;
        Iterator<Map.Entry<String, FileCollection>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void sourceSetName;
            Map.Entry<String, FileCollection> entry;
            Map.Entry<String, FileCollection> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            FileCollection artifacts2 = entry2.getValue();
            StringBuilder stringBuilder = new StringBuilder().append(StringHelper.appendCapitalized((String)"compile", (String)sourceSetName));
            String string = this.componentProperties.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"componentProperties.name");
            String name2 = stringBuilder.append(StringHelper.appendCapitalized((String)"ResourcesFor", (String)string)).toString();
            this.taskFactory.register(new CompileSourceSetResources.CreationAction(name2, artifacts2, this.componentProperties));
        }
    }

    public NamespacedResourcesTaskManager(@NotNull GlobalScope globalScope, @NotNull TaskFactory taskFactory, @NotNull ComponentPropertiesImpl componentProperties) {
        Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
        Intrinsics.checkParameterIsNotNull((Object)taskFactory, (String)"taskFactory");
        Intrinsics.checkParameterIsNotNull((Object)componentProperties, (String)"componentProperties");
        this.globalScope = globalScope;
        this.taskFactory = taskFactory;
        this.componentProperties = componentProperties;
    }
}

