/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.variant.VariantInfo;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.FilterableStreamCollection;
import com.android.build.gradle.internal.pipeline.IntermediateStream;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.pipeline.VariantInfoImpl;
import com.android.build.gradle.internal.tasks.factory.PreConfigAction;
import com.android.build.gradle.internal.tasks.factory.TaskConfigAction;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.internal.tasks.factory.TaskProviderCallback;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.errors.IssueReporter;
import com.android.builder.profile.Recorder;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskProvider;

public class TransformManager
extends FilterableStreamCollection {
    private static final boolean DEBUG = true;
    private static final String FD_TRANSFORMS = "transforms";
    public static final Set<QualifiedContent.ScopeType> EMPTY_SCOPES = ImmutableSet.of();
    public static final Set<QualifiedContent.ContentType> CONTENT_CLASS = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
    public static final Set<QualifiedContent.ContentType> CONTENT_JARS = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES, (Object)QualifiedContent.DefaultContentType.RESOURCES);
    public static final Set<QualifiedContent.ContentType> CONTENT_RESOURCES = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.RESOURCES);
    public static final Set<QualifiedContent.ContentType> CONTENT_NATIVE_LIBS = ImmutableSet.of((Object)((Object)ExtendedContentType.NATIVE_LIBS));
    public static final Set<QualifiedContent.ContentType> CONTENT_DEX = ImmutableSet.of((Object)((Object)ExtendedContentType.DEX));
    public static final Set<QualifiedContent.ContentType> CONTENT_DEX_WITH_RESOURCES = ImmutableSet.of((Object)((Object)ExtendedContentType.DEX), (Object)QualifiedContent.DefaultContentType.RESOURCES);
    public static final Set<QualifiedContent.ScopeType> PROJECT_ONLY = ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT);
    public static final Set<QualifiedContent.ScopeType> SCOPE_FULL_PROJECT = ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT, (Object)QualifiedContent.Scope.SUB_PROJECTS, (Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES);
    public static final Set<QualifiedContent.ScopeType> SCOPE_FULL_WITH_FEATURES = new ImmutableSet.Builder().addAll(SCOPE_FULL_PROJECT).add((Object)InternalScope.FEATURES).build();
    public static final Set<QualifiedContent.ScopeType> SCOPE_FEATURES = ImmutableSet.of((Object)((Object)InternalScope.FEATURES));
    public static final Set<QualifiedContent.ScopeType> SCOPE_FULL_LIBRARY_WITH_LOCAL_JARS = ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT, (Object)((Object)InternalScope.LOCAL_DEPS));
    public static final Set<QualifiedContent.ScopeType> SCOPE_FULL_PROJECT_WITH_LOCAL_JARS = new ImmutableSet.Builder().addAll(SCOPE_FULL_PROJECT).add((Object)InternalScope.LOCAL_DEPS).build();
    private final Project project;
    private final IssueReporter issueReporter;
    private final Logger logger;
    private final Recorder recorder;
    private final List<TransformStream> streams = Lists.newArrayList();
    private final List<Transform> transforms = Lists.newArrayList();

    public TransformManager(Project project2, IssueReporter issueReporter, Recorder recorder) {
        this.project = project2;
        this.issueReporter = issueReporter;
        this.recorder = recorder;
        this.logger = Logging.getLogger(TransformManager.class);
    }

    @Override
    Project getProject() {
        return this.project;
    }

    public void addStream(TransformStream stream) {
        this.streams.add(stream);
    }

    public <T extends Transform> Optional<TaskProvider<TransformTask>> addTransform(TaskFactory taskFactory, ComponentPropertiesImpl componentProperties, T transform2) {
        return this.addTransform(taskFactory, componentProperties, transform2, null, null, null);
    }

    public <T extends Transform> Optional<TaskProvider<TransformTask>> addTransform(TaskFactory taskFactory, ComponentPropertiesImpl componentProperties, T transform2, PreConfigAction preConfigAction, TaskConfigAction<TransformTask> configAction, TaskProviderCallback<TransformTask> providerCallback) {
        if (!this.validateTransform(transform2)) {
            return Optional.empty();
        }
        if (!transform2.applyToVariant((VariantInfo)new VariantInfoImpl(componentProperties))) {
            return Optional.empty();
        }
        ArrayList inputStreams = Lists.newArrayList();
        String taskName = componentProperties.computeTaskName(TransformManager.getTaskNamePrefix(transform2));
        List<TransformStream> referencedStreams = this.grabReferencedStreams(transform2);
        IntermediateStream outputStream = this.findTransformStreams(transform2, componentProperties, inputStreams, taskName, componentProperties.getGlobalScope().getBuildDir());
        if (inputStreams.isEmpty() && referencedStreams.isEmpty()) {
            this.issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("Unable to add Transform '%s' on variant '%s': requested streams not available: %s+%s / %s", transform2.getName(), componentProperties.getName(), transform2.getScopes(), transform2.getReferencedScopes(), transform2.getInputTypes()));
            return Optional.empty();
        }
        if (this.logger.isEnabled(LogLevel.DEBUG)) {
            this.logger.debug("ADDED TRANSFORM(" + componentProperties.getName() + "):");
            this.logger.debug("\tName: " + transform2.getName());
            this.logger.debug("\tTask: " + taskName);
            for (TransformStream sd : inputStreams) {
                this.logger.debug("\tInputStream: " + sd);
            }
            for (TransformStream sd : referencedStreams) {
                this.logger.debug("\tRef'edStream: " + sd);
            }
            if (outputStream != null) {
                this.logger.debug("\tOutputStream: " + outputStream);
            }
        }
        this.transforms.add(transform2);
        TaskConfigAction<TransformTask> wrappedConfigAction = t -> {
            t.getEnableGradleWorkers().set((Object)componentProperties.getGlobalScope().getProjectOptions().get(BooleanOption.ENABLE_GRADLE_WORKERS));
            if (configAction != null) {
                configAction.configure((TransformTask)t);
            }
        };
        return Optional.of(taskFactory.register(new TransformTask.CreationAction<T>(componentProperties.getName(), taskName, transform2, inputStreams, referencedStreams, outputStream, this.recorder), preConfigAction, wrappedConfigAction, providerCallback));
    }

    public List<TransformStream> getStreams() {
        return this.streams;
    }

    @VisibleForTesting
    static String getTaskNamePrefix(Transform transform2) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("transform");
        sb.append(transform2.getInputTypes().stream().map(inputType -> CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, inputType.name())).sorted().collect(Collectors.joining("And")));
        sb.append("With");
        StringHelper.appendCapitalized((StringBuilder)sb, (String)transform2.getName());
        sb.append("For");
        return sb.toString();
    }

    private IntermediateStream findTransformStreams(Transform transform2, ComponentPropertiesImpl componentProperties, List<TransformStream> inputStreams, String taskName, File buildDir) {
        Set requestedScopes = transform2.getScopes();
        if (requestedScopes.isEmpty()) {
            return null;
        }
        Set requestedTypes = transform2.getInputTypes();
        this.consumeStreams(requestedScopes, requestedTypes, inputStreams);
        Set outputTypes = transform2.getOutputTypes();
        File outRootFolder = FileUtils.join((File)buildDir, (Iterable)StringHelper.toStrings((Object[])new Object[]{"intermediates", FD_TRANSFORMS, transform2.getName(), componentProperties.getVariantDslInfo().getDirectorySegments()}));
        IntermediateStream outputStream = IntermediateStream.builder(this.project, transform2.getName() + "-" + componentProperties.getName(), taskName).addContentTypes(outputTypes).addScopes(requestedScopes).setRootLocation(outRootFolder).build();
        this.streams.add(outputStream);
        return outputStream;
    }

    @Deprecated
    public void consumeStreams(Set<? super QualifiedContent.Scope> requestedScopes, Set<QualifiedContent.ContentType> requestedTypes) {
        this.consumeStreams(requestedScopes, requestedTypes, new ArrayList<TransformStream>());
    }

    private void consumeStreams(Set<? super QualifiedContent.Scope> requestedScopes, Set<QualifiedContent.ContentType> requestedTypes, List<TransformStream> inputStreams) {
        ArrayList oldStreams = Lists.newArrayListWithExpectedSize((int)this.streams.size());
        for (TransformStream stream : this.streams) {
            Set<QualifiedContent.ContentType> availableTypes = stream.getContentTypes();
            Set<? super QualifiedContent.Scope> availableScopes = stream.getScopes();
            Sets.SetView commonTypes = Sets.intersection(requestedTypes, availableTypes);
            Sets.SetView commonScopes = Sets.intersection(requestedScopes, availableScopes);
            if (!commonTypes.isEmpty() && !commonScopes.isEmpty()) {
                if (!commonScopes.equals(availableScopes) || !commonTypes.equals(availableTypes)) {
                    inputStreams.add(stream.makeRestrictedCopy((Set<QualifiedContent.ContentType>)commonTypes, (Set<? super QualifiedContent.Scope>)commonScopes));
                    Sets.SetView remainingTypes = Sets.difference(availableTypes, (Set)commonTypes);
                    Sets.SetView remainingScopes = Sets.difference(availableScopes, (Set)commonScopes);
                    if (!remainingTypes.isEmpty()) {
                        oldStreams.add(stream.makeRestrictedCopy((Set<QualifiedContent.ContentType>)remainingTypes.immutableCopy(), availableScopes));
                    }
                    if (remainingScopes.isEmpty()) continue;
                    oldStreams.add(stream.makeRestrictedCopy(availableTypes, (Set<? super QualifiedContent.Scope>)remainingScopes.immutableCopy()));
                    continue;
                }
                inputStreams.add(stream);
                continue;
            }
            oldStreams.add(stream);
        }
        this.streams.clear();
        this.streams.addAll(oldStreams);
    }

    private List<TransformStream> grabReferencedStreams(Transform transform2) {
        Set requestedScopes = transform2.getReferencedScopes();
        if (requestedScopes.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList streamMatches = Lists.newArrayListWithExpectedSize((int)this.streams.size());
        Set requestedTypes = transform2.getInputTypes();
        for (TransformStream stream : this.streams) {
            Set<QualifiedContent.ContentType> availableTypes = stream.getContentTypes();
            Set<? super QualifiedContent.Scope> availableScopes = stream.getScopes();
            Sets.SetView commonTypes = Sets.intersection((Set)requestedTypes, availableTypes);
            Sets.SetView commonScopes = Sets.intersection((Set)requestedScopes, availableScopes);
            if (commonTypes.isEmpty() || commonScopes.isEmpty()) continue;
            streamMatches.add(stream);
        }
        return streamMatches;
    }

    private boolean validateTransform(Transform transform2) {
        if (!this.checkContentTypes(transform2.getInputTypes(), transform2) || !this.checkContentTypes(transform2.getOutputTypes(), transform2)) {
            return false;
        }
        Set scopes = transform2.getScopes();
        if (scopes.contains(QualifiedContent.Scope.PROVIDED_ONLY)) {
            this.issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("PROVIDED_ONLY scope cannot be consumed by Transform '%1$s'", transform2.getName()));
            return false;
        }
        if (scopes.contains(QualifiedContent.Scope.TESTED_CODE)) {
            this.issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("TESTED_CODE scope cannot be consumed by Transform '%1$s'", transform2.getName()));
            return false;
        }
        if (!transform2.getClass().getCanonicalName().startsWith("com.android.build.gradle.internal.transforms")) {
            this.checkScopeDeprecation(transform2.getScopes(), transform2.getName());
            this.checkScopeDeprecation(transform2.getReferencedScopes(), transform2.getName());
        }
        return true;
    }

    private void checkScopeDeprecation(Set<? super QualifiedContent.Scope> scopes, String transformName) {
        String message;
        if (scopes.contains(QualifiedContent.Scope.PROJECT_LOCAL_DEPS)) {
            message = String.format("Transform '%1$s' uses scope %2$s which is deprecated and replaced with %3$s", transformName, QualifiedContent.Scope.PROJECT_LOCAL_DEPS.name(), QualifiedContent.Scope.EXTERNAL_LIBRARIES.name());
            if (!scopes.contains(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) {
                this.issueReporter.reportError(IssueReporter.Type.GENERIC, message);
            }
        }
        if (scopes.contains(QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS)) {
            message = String.format("Transform '%1$s' uses scope %2$s which is deprecated and replaced with %3$s", transformName, QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS.name(), QualifiedContent.Scope.EXTERNAL_LIBRARIES.name());
            if (!scopes.contains(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) {
                this.issueReporter.reportError(IssueReporter.Type.GENERIC, message);
            }
        }
    }

    private boolean checkContentTypes(Set<QualifiedContent.ContentType> contentTypes, Transform transform2) {
        for (QualifiedContent.ContentType contentType : contentTypes) {
            if (contentType instanceof QualifiedContent.DefaultContentType || contentType instanceof ExtendedContentType) continue;
            this.issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("Custom content types (%1$s) are not supported in transforms (%2$s)", contentType.getClass().getName(), transform2.getName()));
            return false;
        }
        return true;
    }
}

