/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dexing;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dexing.DexWorkAction;
import com.android.build.gradle.internal.dexing.DexWorkActionKt;
import com.android.build.gradle.internal.dexing.DexWorkActionKt$WhenMappings;
import com.android.build.gradle.internal.dexing.DexWorkActionParams;
import com.android.build.gradle.internal.dexing.IncrementalDexSpec;
import com.android.build.gradle.internal.tasks.DexArchiveBuilderTaskDelegate;
import com.android.builder.dexing.ClassBucket;
import com.android.builder.dexing.DependencyGraphUpdater;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderConfig;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.builder.dexing.DexParameters;
import com.android.builder.dexing.DexerTool;
import com.android.builder.dexing.MutableDependencyGraph;
import com.android.builder.dexing.r8.ClassFileProviderFactory;
import com.android.dx.command.dexer.DxContext;
import com.android.ide.common.blame.MessageReceiver;
import com.android.utils.FileUtils;
import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a&\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\n\u001aJ\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u0017\u001a\u00020\u00142\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0019H\u0002\u001a\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d2\u0006\u0010\u001e\u001a\u00020\u0014\u001a\u001c\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"loggerWrapper", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getDexArchiveBuilder", "Lcom/android/builder/dexing/DexArchiveBuilder;", "dexWorkActionParams", "Lcom/android/build/gradle/internal/dexing/DexWorkActionParams;", "outStream", "Ljava/io/OutputStream;", "errStream", "messageReceiver", "Lcom/android/ide/common/blame/MessageReceiver;", "launchProcessing", "", "receiver", "process", "dexArchiveBuilder", "inputClassFiles", "Lcom/android/builder/dexing/ClassBucket;", "inputFilter", "Lkotlin/Function2;", "Ljava/io/File;", "", "", "outputPath", "desugarGraphUpdater", "Lcom/android/builder/dexing/DependencyGraphUpdater;", "processIncrementally", "processNonIncrementally", "readDesugarGraph", "Lcom/android/builder/dexing/MutableDependencyGraph;", "desugarGraphFile", "writeDesugarGraph", "desugarGraph", "gradle"})
public final class DexWorkActionKt {
    private static final LoggerWrapper loggerWrapper;

    public static final void launchProcessing(@NotNull DexWorkActionParams dexWorkActionParams, @NotNull OutputStream outStream, @NotNull OutputStream errStream, @NotNull MessageReceiver receiver) {
        Intrinsics.checkParameterIsNotNull((Object)dexWorkActionParams, (String)"dexWorkActionParams");
        Intrinsics.checkParameterIsNotNull((Object)outStream, (String)"outStream");
        Intrinsics.checkParameterIsNotNull((Object)errStream, (String)"errStream");
        Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
        DexArchiveBuilder dexArchiveBuilder = DexWorkActionKt.getDexArchiveBuilder(dexWorkActionParams, outStream, errStream, receiver);
        if (dexWorkActionParams.getDexSpec().isIncremental()) {
            DexWorkActionKt.processIncrementally(dexArchiveBuilder, dexWorkActionParams);
        } else {
            DexWorkActionKt.processNonIncrementally(dexArchiveBuilder, dexWorkActionParams);
        }
    }

    private static final void processIncrementally(DexArchiveBuilder dexArchiveBuilder, DexWorkActionParams dexWorkActionParams) {
        block9: {
            boolean bl;
            Set set;
            MutableDependencyGraph<File> desugarGraph;
            MutableDependencyGraph<File> mutableDependencyGraph;
            IncrementalDexSpec incrementalDexSpec = dexWorkActionParams.getDexSpec();
            boolean bl2 = false;
            boolean bl3 = false;
            IncrementalDexSpec $this$with = incrementalDexSpec;
            boolean bl4 = false;
            File file = $this$with.getDesugarGraphFile();
            if (file != null) {
                MutableDependencyGraph<File> mutableDependencyGraph2;
                File file2 = file;
                boolean bl5 = false;
                boolean bl6 = false;
                File it = file2;
                boolean bl7 = false;
                try {
                    mutableDependencyGraph2 = DexWorkActionKt.readDesugarGraph($this$with.getDesugarGraphFile());
                }
                catch (Exception e) {
                    loggerWrapper.warning("Failed to read desugaring graph." + " Cause: " + e.getClass().getSimpleName() + ", message: " + e.getMessage() + ".\n" + "Fall back to non-incremental mode.", new Object[0]);
                    DexWorkActionKt.processNonIncrementally(dexArchiveBuilder, dexWorkActionParams);
                    return;
                }
                mutableDependencyGraph = mutableDependencyGraph2;
            } else {
                mutableDependencyGraph = desugarGraph = null;
            }
            if ((set = $this$with.getImpactedFiles()) == null) {
                MutableDependencyGraph<File> mutableDependencyGraph3 = desugarGraph;
                if (mutableDependencyGraph3 == null) {
                    Intrinsics.throwNpe();
                }
                set = mutableDependencyGraph3.getAllDependents($this$with.getChangedFiles());
            }
            Set unchangedButImpactedFiles = set;
            Set changedOrImpactedFiles = SetsKt.plus($this$with.getChangedFiles(), (Iterable)unchangedButImpactedFiles);
            MutableDependencyGraph<File> mutableDependencyGraph4 = desugarGraph;
            if (mutableDependencyGraph4 != null) {
                MutableDependencyGraph<File> mutableDependencyGraph5 = mutableDependencyGraph4;
                boolean bl8 = false;
                bl = false;
                MutableDependencyGraph<File> graph = mutableDependencyGraph5;
                boolean bl9 = false;
                Iterable $this$forEach$iv = changedOrImpactedFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl10 = false;
                    graph.removeNode((Object)it);
                }
            }
            Function2 filter2 = (Function2)new Function2<File, String, Boolean>(changedOrImpactedFiles){
                final /* synthetic */ Set $changedOrImpactedFiles;

                public final boolean invoke(@NotNull File rootPath, @NotNull String relativePath) {
                    Intrinsics.checkParameterIsNotNull((Object)rootPath, (String)"rootPath");
                    Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                    return this.$changedOrImpactedFiles.contains(rootPath) || this.$changedOrImpactedFiles.contains(FilesKt.resolve((File)rootPath, (String)relativePath));
                }
                {
                    this.$changedOrImpactedFiles = set;
                    super(2);
                }
            };
            DexWorkActionKt.process(dexArchiveBuilder, dexWorkActionParams.getDexSpec().getInputClassFiles(), (Function2<? super File, ? super String, Boolean>)filter2, dexWorkActionParams.getDexSpec().getOutputPath(), (DependencyGraphUpdater<File>)((DependencyGraphUpdater)desugarGraph));
            File file3 = $this$with.getDesugarGraphFile();
            if (file3 == null) break block9;
            File file4 = file3;
            bl = false;
            boolean bl11 = false;
            File it = file4;
            boolean bl12 = false;
            MutableDependencyGraph<File> mutableDependencyGraph6 = desugarGraph;
            if (mutableDependencyGraph6 == null) {
                Intrinsics.throwNpe();
            }
            DexWorkActionKt.writeDesugarGraph(it, mutableDependencyGraph6);
        }
    }

    private static final void processNonIncrementally(DexArchiveBuilder dexArchiveBuilder, DexWorkActionParams dexWorkActionParams) {
        block3: {
            MutableDependencyGraph mutableDependencyGraph;
            File it;
            boolean bl;
            boolean bl2;
            File file;
            IncrementalDexSpec incrementalDexSpec = dexWorkActionParams.getDexSpec();
            boolean bl3 = false;
            boolean bl4 = false;
            IncrementalDexSpec $this$with = incrementalDexSpec;
            boolean bl5 = false;
            File file2 = $this$with.getDesugarGraphFile();
            if (file2 != null) {
                file = file2;
                bl2 = false;
                bl = false;
                it = file;
                boolean bl6 = false;
                mutableDependencyGraph = new MutableDependencyGraph();
            } else {
                mutableDependencyGraph = null;
            }
            MutableDependencyGraph desugarGraph = mutableDependencyGraph;
            DexWorkActionKt.process(dexArchiveBuilder, dexWorkActionParams.getDexSpec().getInputClassFiles(), (Function2<? super File, ? super String, Boolean>)((Function2)processNonIncrementally.1.1.INSTANCE), dexWorkActionParams.getDexSpec().getOutputPath(), (DependencyGraphUpdater<File>)((DependencyGraphUpdater)desugarGraph));
            File file3 = $this$with.getDesugarGraphFile();
            if (file3 == null) break block3;
            file = file3;
            bl2 = false;
            bl = false;
            it = file;
            boolean bl7 = false;
            FileUtils.mkdirs((File)it.getParentFile());
            MutableDependencyGraph mutableDependencyGraph2 = desugarGraph;
            if (mutableDependencyGraph2 == null) {
                Intrinsics.throwNpe();
            }
            DexWorkActionKt.writeDesugarGraph(it, (MutableDependencyGraph<File>)mutableDependencyGraph2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void process(DexArchiveBuilder dexArchiveBuilder, ClassBucket inputClassFiles, Function2<? super File, ? super String, Boolean> inputFilter2, File outputPath2, DependencyGraphUpdater<File> desugarGraphUpdater) {
        List inputRoots = inputClassFiles.getBucketGroup().getRoots();
        Object $this$forEach$iv = inputRoots;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            File it = (File)element$iv;
            boolean bl = false;
            loggerWrapper.verbose("Dexing '" + it.getPath() + "' to '" + outputPath2.getPath() + '\'', new Object[0]);
        }
        try {
            $this$forEach$iv = (Closeable)Closer.create();
            boolean bl = false;
            object = null;
            try {
                Closer closer = (Closer)$this$forEach$iv;
                boolean bl2 = false;
                Closer closer2 = closer;
                Intrinsics.checkExpressionValueIsNotNull((Object)closer2, (String)"closer");
                AutoCloseable autoCloseable = inputClassFiles.getClassFiles(inputFilter2, closer2);
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    Stream it = (Stream)autoCloseable;
                    boolean bl4 = false;
                    Path path = outputPath2.toPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"outputPath.toPath()");
                    dexArchiveBuilder.convert(it, path, desugarGraphUpdater);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$forEach$iv, (Throwable)object);
            }
        }
        catch (DexArchiveBuilderException ex) {
            throw (Throwable)new DexArchiveBuilderException("Failed to process: " + CollectionsKt.joinToString$default((Iterable)inputRoots, (CharSequence)", ", null, null, (int)0, null, (Function1)process.3.INSTANCE, (int)30, null), (Throwable)ex);
        }
    }

    private static final DexArchiveBuilder getDexArchiveBuilder(DexWorkActionParams dexWorkActionParams, OutputStream outStream, OutputStream errStream, MessageReceiver messageReceiver) {
        DexArchiveBuilder dexArchiveBuilder = null;
        boolean bl = false;
        boolean bl2 = false;
        DexWorkActionParams $this$with = dexWorkActionParams;
        boolean bl3 = false;
        switch (DexWorkActionKt$WhenMappings.$EnumSwitchMapping$0[$this$with.getDexer().ordinal()]) {
            case 1: {
                DexArchiveBuilderConfig config2 = new DexArchiveBuilderConfig(new DxContext(outStream, errStream), !$this$with.getDxDexParams().getDxNoOptimizeFlagPresent(), $this$with.getDxDexParams().getInBufferSize(), $this$with.getDexSpec().getDexParams().getMinSdkVersion(), DexerTool.DX, $this$with.getDxDexParams().getOutBufferSize(), $this$with.getDxDexParams().getJumboMode());
                dexArchiveBuilder = DexArchiveBuilder.Companion.createDxDexBuilder(config2);
                break;
            }
            case 2: {
                dexArchiveBuilder = DexArchiveBuilder.Companion.createD8DexBuilder(new DexParameters($this$with.getDexSpec().getDexParams().getMinSdkVersion(), $this$with.getDexSpec().getDexParams().getDebuggable(), $this$with.getDexSpec().getDexParams().getDexPerClass(), $this$with.getDexSpec().getDexParams().getWithDesugaring(), (ClassFileProviderFactory)DexArchiveBuilderTaskDelegate.Companion.getSharedState$gradle().getService($this$with.getDexSpec().getDexParams().getDesugarBootclasspath()).getService(), (ClassFileProviderFactory)DexArchiveBuilderTaskDelegate.Companion.getSharedState$gradle().getService($this$with.getDexSpec().getDexParams().getDesugarClasspath()).getService(), $this$with.getDexSpec().getDexParams().getCoreLibDesugarConfig(), $this$with.getDexSpec().getDexParams().getCoreLibDesugarOutputKeepRuleFile(), messageReceiver));
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError((Object)("Unknown dexer type: " + $this$with.getDexer().name())));
            }
        }
        return dexArchiveBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final MutableDependencyGraph<File> readDesugarGraph(@NotNull File desugarGraphFile) {
        MutableDependencyGraph mutableDependencyGraph;
        Intrinsics.checkParameterIsNotNull((Object)desugarGraphFile, (String)"desugarGraphFile");
        Closeable closeable = new FileInputStream(desugarGraphFile);
        int n = 8192;
        boolean bl = false;
        BufferedInputStream bufferedInputStream = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        InputStream inputStream = bufferedInputStream;
        closeable = new ObjectInputStream(inputStream);
        n = 0;
        Throwable throwable = null;
        try {
            ObjectInputStream it = (ObjectInputStream)closeable;
            boolean bl2 = false;
            Object object = it.readObject();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.builder.dexing.MutableDependencyGraph<java.io.File>");
            }
            mutableDependencyGraph = (MutableDependencyGraph)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return mutableDependencyGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeDesugarGraph(@NotNull File desugarGraphFile, @NotNull MutableDependencyGraph<File> desugarGraph) {
        Intrinsics.checkParameterIsNotNull((Object)desugarGraphFile, (String)"desugarGraphFile");
        Intrinsics.checkParameterIsNotNull(desugarGraph, (String)"desugarGraph");
        Closeable closeable = new FileOutputStream(desugarGraphFile);
        int n = 8192;
        boolean bl = false;
        BufferedOutputStream bufferedOutputStream = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
        OutputStream outputStream = bufferedOutputStream;
        closeable = new ObjectOutputStream(outputStream);
        n = 0;
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl2 = false;
            it.writeObject(desugarGraph);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(DexWorkAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)loggerWrapper, (String)"LoggerWrapper.getLogger(DexWorkAction::class.java)");
        DexWorkActionKt.loggerWrapper = loggerWrapper;
    }
}

