/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.tasks.BlocksUtilsKt;
import com.android.builder.aar.AarExtractor;
import com.android.tools.build.gradle.internal.profile.GradleTransformExecutionType;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/dependency/ExtractAarTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "()V", "primaryInput", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getPrimaryInput", "()Lorg/gradle/api/provider/Provider;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "gradle"})
public abstract class ExtractAarTransform
implements TransformAction<GenericTransformParameters> {
    @Classpath
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getPrimaryInput();

    public void transform(@NotNull TransformOutputs outputs) {
        Intrinsics.checkParameterIsNotNull((Object)outputs, (String)"outputs");
        Object object = ((GenericTransformParameters)this.getParameters()).getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.projectName.get()");
        BlocksUtilsKt.recordArtifactTransformSpan((String)object, GradleTransformExecutionType.EXTRACT_AAR_ARTIFACT_TRANSFORM, (Function0<Unit>)((Function0)new Function0<Unit>(this, outputs){
            final /* synthetic */ ExtractAarTransform this$0;
            final /* synthetic */ TransformOutputs $outputs;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                File inputFile;
                Object object = this.this$0.getPrimaryInput().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"primaryInput.get()");
                File file = inputFile = ((FileSystemLocation)object).getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputFile");
                String name2 = Files.getNameWithoutExtension((String)file.getName());
                File outputDir = this.$outputs.dir((Object)name2);
                FileUtils.mkdirs((File)outputDir);
                AarExtractor aarExtractor = new AarExtractor();
                File file2 = outputDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"outputDir");
                aarExtractor.extract(inputFile, file2);
                File classesJar = new File(new File(outputDir, "jars"), "classes.jar");
                if (!classesJar.exists()) {
                    try {
                        Files.createParentDirs((File)classesJar);
                        Closeable closeable = new FileOutputStream(classesJar);
                        boolean bl = false;
                        Throwable throwable = null;
                        try {
                            FileOutputStream out = (FileOutputStream)closeable;
                            boolean bl2 = false;
                            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new BufferedOutputStream(out), new Manifest());
                            jarOutputStream.close();
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    catch (IOException e) {
                        throw (Throwable)new RuntimeException("Cannot create missing classes.jar", e);
                    }
                }
            }
            {
                this.this$0 = extractAarTransform;
                this.$outputs = transformOutputs;
                super(0);
            }
        }));
    }
}

