/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.json;

import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonCompositeVisitor;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonStatsBuildingVisitor;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonStreamingParser;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonStreamingVisitor;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;

public class AndroidBuildGradleJsons {
    public static NativeBuildConfigValueMini parseToMiniConfigAndGatherStatistics(JsonReader reader, GradleBuildVariant.Builder stats) throws IOException {
        GradleBuildVariant.NativeBuildConfigInfo.Builder config2 = GradleBuildVariant.NativeBuildConfigInfo.newBuilder();
        AndroidBuildGradleJsonStatsBuildingVisitor statsVisitor = new AndroidBuildGradleJsonStatsBuildingVisitor(config2);
        MiniConfigBuildingVisitor miniConfigVisitor = new MiniConfigBuildingVisitor();
        AndroidBuildGradleJsonCompositeVisitor composite = new AndroidBuildGradleJsonCompositeVisitor(statsVisitor, miniConfigVisitor);
        try (AndroidBuildGradleJsonStreamingParser parser2 = new AndroidBuildGradleJsonStreamingParser(reader, composite);){
            parser2.parse();
            stats.addNativeBuildConfig(config2);
            NativeBuildConfigValueMini nativeBuildConfigValueMini = miniConfigVisitor.miniConfig;
            return nativeBuildConfigValueMini;
        }
    }

    private static NativeBuildConfigValueMini parseToMiniConfig(JsonReader reader) throws IOException {
        MiniConfigBuildingVisitor miniConfigVisitor = new MiniConfigBuildingVisitor();
        try (AndroidBuildGradleJsonStreamingParser parser2 = new AndroidBuildGradleJsonStreamingParser(reader, miniConfigVisitor);){
            parser2.parse();
            NativeBuildConfigValueMini nativeBuildConfigValueMini = miniConfigVisitor.miniConfig;
            return nativeBuildConfigValueMini;
        }
    }

    public static List<NativeBuildConfigValueMini> getNativeBuildMiniConfigs(List<File> jsons, GradleBuildVariant.Builder stats) throws IOException {
        ArrayList miniConfigs = Lists.newArrayList();
        for (File json : jsons) {
            miniConfigs.add(AndroidBuildGradleJsons.getNativeBuildMiniConfig(json, stats));
        }
        return miniConfigs;
    }

    public static NativeBuildConfigValueMini getNativeBuildMiniConfig(File json, GradleBuildVariant.Builder stats) throws IOException {
        NativeBuildConfigValueMini result;
        File persistedMiniConfig = ExternalNativeBuildTaskUtils.getJsonMiniConfigFile(json);
        if (ExternalNativeBuildTaskUtils.fileIsUpToDate(json, persistedMiniConfig)) {
            try (JsonReader reader = new JsonReader((Reader)new FileReader(persistedMiniConfig));){
                NativeBuildConfigValueMini nativeBuildConfigValueMini = AndroidBuildGradleJsons.parseToMiniConfig(reader);
                return nativeBuildConfigValueMini;
            }
        }
        try (JsonReader reader = new JsonReader((Reader)new FileReader(json));){
            result = stats == null ? AndroidBuildGradleJsons.parseToMiniConfig(reader) : AndroidBuildGradleJsons.parseToMiniConfigAndGatherStatistics(reader, stats);
        }
        AndroidBuildGradleJsons.writeNativeBuildMiniConfigValueToJsonFile(persistedMiniConfig, result);
        return result;
    }

    public static void writeNativeBuildConfigValueToJsonFile(File outputJson, NativeBuildConfigValue nativeBuildConfigValue) throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).disableHtmlEscaping().setPrettyPrinting().create();
        try (FileWriter jsonWriter = new FileWriter(outputJson);){
            gson.toJson((Object)nativeBuildConfigValue, (Appendable)jsonWriter);
        }
    }

    private static void writeNativeBuildMiniConfigValueToJsonFile(File outputJson, NativeBuildConfigValueMini miniConfig) throws IOException {
        String actualResult = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).setPrettyPrinting().create().toJson((Object)miniConfig);
        Files.write(outputJson.toPath(), actualResult.getBytes(Charsets.UTF_8), new OpenOption[0]);
    }

    private static class MiniConfigBuildingVisitor
    extends AndroidBuildGradleJsonStreamingVisitor {
        private final NativeBuildConfigValueMini miniConfig = new NativeBuildConfigValueMini();
        private String libraryName = null;

        MiniConfigBuildingVisitor() {
        }

        @Override
        protected void beginLibrary(String libraryName) {
            super.beginLibrary(libraryName);
            this.libraryName = libraryName;
            this.miniConfig.libraries.put(libraryName, new NativeLibraryValueMini());
        }

        @Override
        protected void visitLibraryAbi(String abi) {
            super.visitLibraryAbi(abi);
            this.miniConfig.libraries.get((Object)this.libraryName).abi = abi;
        }

        @Override
        protected void visitLibraryArtifactName(String artifactName) {
            super.visitLibraryArtifactName(artifactName);
            this.miniConfig.libraries.get((Object)this.libraryName).artifactName = artifactName;
        }

        @Override
        protected void visitLibraryBuildCommand(String buildCommand) {
            super.visitLibraryBuildCommand(buildCommand);
            this.miniConfig.libraries.get((Object)this.libraryName).buildCommand = buildCommand;
        }

        @Override
        protected void visitCleanCommands(String cleanCommand) {
            super.visitCleanCommands(cleanCommand);
            this.miniConfig.cleanCommands.add(cleanCommand);
        }

        @Override
        protected void visitBuildTargetsCommand(String buildTargetsCommand) {
            super.visitBuildTargetsCommand(buildTargetsCommand);
            this.miniConfig.buildTargetsCommand = buildTargetsCommand;
        }

        @Override
        protected void visitLibraryOutput(String output2) {
            if (output2 == null) {
                return;
            }
            super.visitLibraryOutput(output2);
            this.miniConfig.libraries.get((Object)this.libraryName).output = new File(output2);
        }

        @Override
        protected void visitBuildFile(String buildFile) {
            super.visitBuildFile(buildFile);
            this.miniConfig.buildFiles.add(new File(buildFile));
        }

        @Override
        protected void visitLibraryRuntimeFile(String runtimeFile) {
            super.visitLibraryRuntimeFile(runtimeFile);
            this.miniConfig.libraries.get((Object)this.libraryName).runtimeFiles.add(new File(runtimeFile));
        }
    }
}

