/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.gnumake;

import com.android.build.gradle.external.gnumake.CommandLine;
import com.android.build.gradle.external.gnumake.OsFileConventions;
import java.util.ArrayList;
import java.util.List;

class CommandLineParser {
    CommandLineParser() {
    }

    static List<CommandLine> parse(String commands, OsFileConventions policy) {
        String[] lines = commands.split("[\r\n]+");
        ArrayList<CommandLine> commandLines = new ArrayList<CommandLine>();
        for (String line : lines) {
            List<String> commandList = policy.splitCommandLine(line);
            for (String commandString : commandList) {
                List<String> escapedFlags = policy.tokenizeCommandLineToEscaped(commandString);
                List<String> rawFlags = policy.tokenizeCommandLineToRaw(commandString);
                String command = escapedFlags.get(0);
                escapedFlags.remove(0);
                rawFlags.remove(0);
                commandLines.add(new CommandLine(command, escapedFlags, rawFlags));
            }
        }
        return commandLines;
    }
}

