/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.transparency.CodeTransparencyChecker;
import com.android.tools.build.bundletool.transparency.TransparencyCheckResult;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.io.ByteSource;
import java.util.Optional;

public final class CodeTransparencyValidator
extends SubValidator {
    @Override
    public void validateBundle(AppBundle bundle) {
        Optional<ByteSource> transparencyFile = bundle.getBundleMetadata().getFileAsByteSource("com.android.tools.build.bundletool", "code_transparency.json");
        if (!transparencyFile.isPresent()) {
            return;
        }
        TransparencyCheckResult transparencyCheckResult = CodeTransparencyChecker.checkTransparency(bundle, transparencyFile.get());
        if (!transparencyCheckResult.verified()) {
            throw InvalidBundleException.builder().withUserMessage("Code transparency verification failed.\n" + transparencyCheckResult.getDiffAsString()).build();
        }
    }
}

