/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.e;
import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.experimental.graphinfo.a;
import com.android.tools.r8.graph.M;
import com.android.tools.r8.graph.S;
import com.android.tools.r8.graph.U;
import com.android.tools.r8.graph.Y;
import com.android.tools.r8.graph.a0;
import com.android.tools.r8.graph.c0;
import com.android.tools.r8.graph.e0;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleBase;
import java.util.Collection;

public abstract class KeepReason {
    static KeepReason annotatedOn(M m4) {
        return new AnnotatedOn(m4);
    }

    static KeepReason dueToProguardCompatibilityKeepRule(ProguardKeepRule proguardKeepRule) {
        return new DueToProguardCompatibilityKeepRule(proguardKeepRule);
    }

    static KeepReason instantiatedIn(S s4) {
        return new InstatiatedIn(s4);
    }

    public static KeepReason invokedViaSuperFrom(S s4) {
        return new InvokedViaSuper(s4);
    }

    public static KeepReason reachableFromLiveType(e0 e02) {
        return new ReachableFromLiveType(e02);
    }

    public static KeepReason invokedFrom(S s4) {
        return new InvokedFrom(s4);
    }

    public static KeepReason invokedFromLambdaCreatedIn(S s4) {
        return new InvokedFromLambdaCreatedIn(s4);
    }

    public static KeepReason isLibraryMethod(a0 a02, e0 e02) {
        return new IsLibraryMethod(a02.c, e02);
    }

    public static KeepReason fieldReferencedIn(S s4) {
        return new ReferencedFrom(s4);
    }

    public static KeepReason referencedInAnnotation(U u4) {
        return new ReferencedInAnnotation(u4);
    }

    public static KeepReason targetedBySuperFrom(S s4) {
        return new TargetedBySuper(s4);
    }

    public static KeepReason reflectiveUseIn(S s4) {
        return new ReflectiveUseFrom(s4);
    }

    public static KeepReason methodHandleReferencedIn(S s4) {
        return new MethodHandleReferencedFrom(s4);
    }

    public static KeepReason overridesMethod(S s4) {
        return new OverridesMethod(s4);
    }

    public abstract a.a edgeKind();

    public abstract GraphNode getSourceNode(Enqueuer var1);

    public boolean isDueToKeepRule() {
        return false;
    }

    public boolean isDueToReflectiveUse() {
        return false;
    }

    public boolean isDueToProguardCompatibility() {
        return false;
    }

    public boolean isInstantiatedIn() {
        return false;
    }

    public InstatiatedIn asInstantiatedIn() {
        return null;
    }

    public ProguardKeepRuleBase getProguardKeepRule() {
        return null;
    }

    public Collection<c0> getPreconditions() {
        throw new e();
    }

    private static class MethodHandleReferencedFrom
    extends BasedOnOtherMethod {
        private MethodHandleReferencedFrom(S s4) {
            super(s4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.q;
        }

        @Override
        String getKind() {
            return "method handle referenced from";
        }
    }

    private static class ReflectiveUseFrom
    extends BasedOnOtherMethod {
        private ReflectiveUseFrom(S s4) {
            super(s4);
        }

        @Override
        public boolean isDueToReflectiveUse() {
            return true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.l;
        }

        @Override
        String getKind() {
            return "reflective use in";
        }
    }

    private static class AnnotatedOn
    extends KeepReason {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final M holder;

        private AnnotatedOn(M m4) {
            this.holder = m4;
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.j;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            if (this.holder.i()) {
                return enqueuer.getClassGraphNode(this.holder.f().c);
            }
            if (this.holder.j()) {
                return enqueuer.getFieldGraphNode(this.holder.g().a);
            }
            if (!$assertionsDisabled && !this.holder.k()) {
                throw new AssertionError();
            }
            return enqueuer.getMethodGraphNode(this.holder.h().a);
        }
    }

    private static class ReferencedInAnnotation
    extends KeepReason {
        private final U holder;

        private ReferencedInAnnotation(U u4) {
            this.holder = u4;
        }

        @Override
        public a.a edgeKind() {
            return a.a.n;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getAnnotationGraphNode(this.holder);
        }
    }

    public static class IsLibraryMethod
    extends KeepReason {
        private final e0 implementer;
        private final e0 libraryType;

        private IsLibraryMethod(e0 e02, e0 e03) {
            this.implementer = e02;
            this.libraryType = e03;
        }

        @Override
        public a.a edgeKind() {
            return a.a.o;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getClassGraphNode(this.implementer);
        }
    }

    private static class ReachableFromLiveType
    extends KeepReason {
        private final e0 type;

        private ReachableFromLiveType(e0 e02) {
            this.type = e02;
        }

        @Override
        public a.a edgeKind() {
            return a.a.m;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getClassGraphNode(this.type);
        }
    }

    private static class ReferencedFrom
    extends BasedOnOtherMethod {
        private ReferencedFrom(S s4) {
            super(s4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.k;
        }

        @Override
        String getKind() {
            return "referenced from";
        }
    }

    private static class InvokedFromLambdaCreatedIn
    extends BasedOnOtherMethod {
        private InvokedFromLambdaCreatedIn(S s4) {
            super(s4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.i;
        }

        @Override
        String getKind() {
            return "invoked from lambda created in";
        }
    }

    private static class InvokedFrom
    extends BasedOnOtherMethod {
        private InvokedFrom(S s4) {
            super(s4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.h;
        }

        @Override
        String getKind() {
            return "invoked from";
        }
    }

    private static class TargetedBySuper
    extends BasedOnOtherMethod {
        private TargetedBySuper(S s4) {
            super(s4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.g;
        }

        @Override
        String getKind() {
            return "targeted by super from";
        }
    }

    private static class InvokedViaSuper
    extends BasedOnOtherMethod {
        private InvokedViaSuper(S s4) {
            super(s4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.f;
        }

        @Override
        String getKind() {
            return "invoked via super from";
        }
    }

    public static class InstatiatedIn
    extends BasedOnOtherMethod {
        private InstatiatedIn(S s4) {
            super(s4);
        }

        @Override
        public boolean isInstantiatedIn() {
            return true;
        }

        @Override
        public InstatiatedIn asInstantiatedIn() {
            return this;
        }

        @Override
        public a.a edgeKind() {
            return a.a.e;
        }

        @Override
        String getKind() {
            return "instantiated in";
        }
    }

    private static class OverridesMethod
    extends BasedOnOtherMethod {
        public OverridesMethod(S s4) {
            super(s4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.p;
        }

        @Override
        String getKind() {
            return "overrides";
        }
    }

    private static abstract class BasedOnOtherMethod
    extends KeepReason {
        private final S method;

        private BasedOnOtherMethod(S s4) {
            this.method = s4;
        }

        abstract String getKind();

        public Y getMethod() {
            return this.method.a;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getMethodGraphNode(this.method.a);
        }
    }

    private static class DueToProguardCompatibilityKeepRule
    extends DueToKeepRule {
        private DueToProguardCompatibilityKeepRule(ProguardKeepRule proguardKeepRule) {
            super(proguardKeepRule);
        }

        @Override
        public a.a edgeKind() {
            return a.a.b;
        }

        @Override
        public boolean isDueToProguardCompatibility() {
            return true;
        }
    }

    private static class DueToKeepRule
    extends KeepReason {
        final ProguardKeepRuleBase keepRule;

        private DueToKeepRule(ProguardKeepRuleBase proguardKeepRuleBase) {
            this.keepRule = proguardKeepRuleBase;
        }

        @Override
        public a.a edgeKind() {
            return a.a.a;
        }

        @Override
        public boolean isDueToKeepRule() {
            return true;
        }

        @Override
        public ProguardKeepRuleBase getProguardKeepRule() {
            return this.keepRule;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getKeepRuleGraphNode(null, this.keepRule);
        }
    }
}

