/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.builder.testing.api.DeviceConfig;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.ide.common.util.DeviceUtils;
import com.android.sdklib.AndroidVersion;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ConnectedDevice
extends DeviceConnector {
    private final IDevice iDevice;
    private final ILogger mLogger;
    private final long mTimeout;
    private final TimeUnit mTimeUnit;
    private String mName;
    private String mNameSuffix;

    public ConnectedDevice(IDevice iDevice, ILogger logger, long timeout, TimeUnit timeUnit) {
        this.iDevice = iDevice;
        this.mLogger = logger;
        this.mTimeout = timeout;
        this.mTimeUnit = timeUnit;
    }

    public String getName() {
        String model;
        if (this.mName != null) {
            return this.mName;
        }
        String version = this.getNullableProperty("ro.build.version.release");
        boolean emulator = this.iDevice.isEmulator();
        String name = emulator ? (this.iDevice.getAvdName() != null ? this.iDevice.getAvdName() + "(AVD)" : this.iDevice.getSerialNumber()) : ((model = this.getNullableProperty("ro.product.model")) != null ? model : this.iDevice.getSerialNumber());
        String string = this.mName = version != null ? name + " - " + version : name;
        if (this.mNameSuffix != null) {
            this.mName = this.mName + "-" + this.mNameSuffix;
        }
        return this.mName;
    }

    void setNameSuffix(String suffix) {
        this.mNameSuffix = suffix;
        this.mName = null;
    }

    public String getNameSuffix() {
        return this.mNameSuffix;
    }

    public void connect(int timeout, ILogger logger) throws TimeoutException {
    }

    public void disconnect(int timeout, ILogger logger) throws TimeoutException {
    }

    public void installPackage(File apkFile, Collection<String> options, int timeout, ILogger logger) throws DeviceException {
        try {
            ArrayList installOptions = Lists.newArrayListWithCapacity((int)(1 + options.size()));
            installOptions.add("-t");
            installOptions.addAll(options);
            this.iDevice.installPackage(apkFile.getAbsolutePath(), true, installOptions.toArray(new String[0]));
        }
        catch (Exception e4) {
            logger.error((Throwable)e4, "Unable to install " + apkFile.getAbsolutePath(), new Object[0]);
            throw new DeviceException((Throwable)e4);
        }
    }

    public void installPackages(List<File> splitApkFiles, Collection<String> options, int timeoutInMs, ILogger logger) throws DeviceException {
        try {
            ArrayList installOptions = Lists.newArrayListWithCapacity((int)(1 + options.size()));
            installOptions.add("-t");
            installOptions.addAll(options);
            this.iDevice.installPackages(splitApkFiles, true, (List)installOptions, (long)timeoutInMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception e4) {
            List apkFileNames = Lists.transform(splitApkFiles, input -> input != null ? input.getAbsolutePath() : null);
            logger.error((Throwable)e4, "Unable to install " + Joiner.on((char)',').join((Iterable)apkFileNames), new Object[0]);
            throw new DeviceException((Throwable)e4);
        }
    }

    public void uninstallPackage(String packageName, int timeout, ILogger logger) throws DeviceException {
        try {
            this.iDevice.uninstallPackage(packageName);
        }
        catch (Exception e4) {
            logger.error((Throwable)e4, "Unable to uninstall " + packageName, new Object[0]);
            throw new DeviceException((Throwable)e4);
        }
    }

    public void executeShellCommand(String command, IShellOutputReceiver receiver, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.iDevice.executeShellCommand(command, receiver, maxTimeToOutputResponse, maxTimeUnits);
    }

    public void executeShellCommand(String command, IShellOutputReceiver receiver, long maxTimeout, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.iDevice.executeShellCommand(command, receiver, maxTimeout, maxTimeToOutputResponse, maxTimeUnits);
    }

    public Future<String> getSystemProperty(String name) {
        return this.iDevice.getSystemProperty(name);
    }

    public void pullFile(String remote, String local) throws IOException {
        try {
            this.iDevice.pullFile(remote, local);
        }
        catch (TimeoutException e4) {
            throw new IOException(String.format("Failed to pull %s from device", remote), e4);
        }
        catch (AdbCommandRejectedException e5) {
            throw new IOException(String.format("Failed to pull %s from device", remote), e5);
        }
        catch (SyncException e6) {
            throw new IOException(String.format("Failed to pull %s from device", remote), e6);
        }
    }

    public String getSerialNumber() {
        return this.iDevice.getSerialNumber();
    }

    public int getApiLevel() {
        String sdkVersion = this.getNullableProperty("ro.build.version.sdk");
        if (sdkVersion != null) {
            try {
                return Integer.valueOf(sdkVersion);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getApiCodeName() {
        String codeName = this.getNullableProperty("ro.build.version.codename");
        if (codeName != null) {
            if ("REL".equals(codeName)) {
                return null;
            }
            return codeName;
        }
        return null;
    }

    public IDevice.DeviceState getState() {
        return this.iDevice.getState();
    }

    public List<String> getAbis() {
        String abiList = this.getNullableProperty("ro.product.cpu.abilist");
        if (abiList != null) {
            return Lists.newArrayList((Iterable)Splitter.on((char)',').split((CharSequence)abiList));
        }
        ArrayList abis = Lists.newArrayListWithExpectedSize((int)2);
        String abi = this.getNullableProperty("ro.product.cpu.abi");
        if (abi != null) {
            abis.add(abi);
        }
        if ((abi = this.getNullableProperty("ro.product.cpu.abi2")) != null) {
            abis.add(abi);
        }
        return abis;
    }

    public int getDensity() {
        String densityValue = this.getNullableProperty("ro.sf.lcd_density");
        if (densityValue == null) {
            densityValue = this.getNullableProperty("qemu.sf.lcd_density");
        }
        if (densityValue == null) {
            this.mLogger.verbose("Unable to get density for device %1$s", new Object[]{this.getName()});
            return -1;
        }
        try {
            return Integer.parseInt(densityValue);
        }
        catch (NumberFormatException e4) {
            this.mLogger.lifecycle("Unable to get density for device %1$s. Density value %2$s could not be parsed.", new Object[]{this.getName(), densityValue});
            return -1;
        }
    }

    public int getHeight() {
        return 0;
    }

    public int getWidth() {
        return 0;
    }

    public String getLanguage() {
        return this.getNullableProperty("persist.sys.language");
    }

    public Set<String> getLanguageSplits() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AndroidVersion version = this.iDevice.getVersion();
        if (version.getApiLevel() < 21) {
            return null;
        }
        return DeviceUtils.getLanguages((IDevice)this.iDevice, (Duration)Duration.ofMillis(this.mTimeUnit.toMillis(this.mTimeout)));
    }

    public String getRegion() {
        return this.getNullableProperty("persist.sys.country");
    }

    public String getProperty(String propertyName) {
        return (String)Preconditions.checkNotNull((Object)this.getNullableProperty(propertyName));
    }

    public String getNullableProperty(String propertyName) {
        try {
            Future property = this.iDevice.getSystemProperty(propertyName);
            if (this.mTimeout > 0L) {
                return (String)property.get(this.mTimeout, this.mTimeUnit);
            }
            return (String)property.get();
        }
        catch (InterruptedException e4) {
            return null;
        }
        catch (ExecutionException e5) {
            return null;
        }
        catch (java.util.concurrent.TimeoutException e6) {
            return null;
        }
    }

    public DeviceConfig getDeviceConfig() throws DeviceException {
        final ArrayList output2 = new ArrayList();
        MultiLineReceiver receiver = new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                output2.addAll(Arrays.asList(lines));
            }

            public boolean isCancelled() {
                return false;
            }
        };
        try {
            this.executeShellCommand("am get-config", (IShellOutputReceiver)receiver, this.mTimeout, this.mTimeUnit);
            return DeviceConfig.Builder.parse(output2);
        }
        catch (Exception e4) {
            throw new DeviceException((Throwable)e4);
        }
    }

    public IDevice getIDevice() {
        return this.iDevice;
    }
}

