/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AccessFlags;
import com.android.tools.r8.graph.ClassAccessFlags;
import java.util.List;
import java.util.function.BooleanSupplier;

public class ProguardAccessFlags {
    private static final int PPP_MASK = new ProguardAccessFlags().setPublic().setProtected().setPrivate().flags;
    private int flags = 0;
    private static final List<String> NAMES = ImmutableList.of("public", "private", "protected", "static", "final", "abstract", "volatile", "transient", "synchronized", "native", "strictfp", "synthetic", new String[]{"bridge"});

    private List<BooleanSupplier> getPredicates() {
        return ImmutableList.of(this::isPublic, this::isPrivate, this::isProtected, this::isStatic, this::isFinal, this::isAbstract, this::isVolatile, this::isTransient, this::isSynchronized, this::isNative, this::isStrict, this::isSynthetic, new BooleanSupplier[]{this::isBridge});
    }

    private boolean containsAll(int other) {
        return (this.flags & ~PPP_MASK & (other & ~PPP_MASK)) == (this.flags & ~PPP_MASK) && ((this.flags & PPP_MASK) == 0 || (this.flags & PPP_MASK & (other & PPP_MASK)) != 0);
    }

    private boolean containsNone(int other) {
        return (this.flags & other) == 0;
    }

    public boolean containsAll(AccessFlags other) {
        return this.containsAll(other.getOriginalCfAccessFlags());
    }

    public boolean containsNone(AccessFlags other) {
        return this.containsNone(other.getOriginalCfAccessFlags());
    }

    public void setFlags(AccessFlags other) {
        this.flags = other.getOriginalCfAccessFlags();
    }

    public ProguardAccessFlags setPublic() {
        this.set(1);
        return this;
    }

    public boolean isPublic() {
        return this.isSet(1);
    }

    public ProguardAccessFlags setPrivate() {
        this.set(2);
        return this;
    }

    public boolean isPrivate() {
        return this.isSet(2);
    }

    public ProguardAccessFlags setProtected() {
        this.set(4);
        return this;
    }

    public boolean isProtected() {
        return this.isSet(4);
    }

    public void setVisibility(ClassAccessFlags classAccessFlags) {
        if (classAccessFlags.isPublic()) {
            this.setPublic();
        } else if (classAccessFlags.isProtected()) {
            this.setProtected();
        } else if (classAccessFlags.isPrivate()) {
            this.setPrivate();
        }
    }

    public void setStatic() {
        this.set(8);
    }

    public boolean isStatic() {
        return this.isSet(8);
    }

    public void setFinal() {
        this.set(16);
    }

    public boolean isFinal() {
        return this.isSet(16);
    }

    public void setAbstract() {
        this.set(1024);
    }

    public boolean isAbstract() {
        return this.isSet(1024);
    }

    public void setVolatile() {
        this.set(64);
    }

    public boolean isVolatile() {
        return this.isSet(64);
    }

    public void setTransient() {
        this.set(128);
    }

    public boolean isTransient() {
        return this.isSet(128);
    }

    public void setSynchronized() {
        this.set(32);
    }

    public boolean isSynchronized() {
        return this.isSet(32);
    }

    public void setNative() {
        this.set(256);
    }

    public boolean isNative() {
        return this.isSet(256);
    }

    public void setStrict() {
        this.set(2048);
    }

    public boolean isStrict() {
        return this.isSet(2048);
    }

    public void setSynthetic() {
        this.set(4096);
    }

    public boolean isSynthetic() {
        return this.isSet(4096);
    }

    public void setBridge() {
        this.set(64);
    }

    public boolean isBridge() {
        return this.isSet(64);
    }

    private boolean isSet(int flag) {
        return (this.flags & flag) != 0;
    }

    private void set(int flag) {
        this.flags |= flag;
    }

    public String toString() {
        List<BooleanSupplier> predicates = this.getPredicates();
        StringBuilder builder = new StringBuilder();
        boolean space = false;
        for (int i = 0; i < NAMES.size(); ++i) {
            if (!predicates.get(i).getAsBoolean()) continue;
            if (space) {
                builder.append(' ');
            } else {
                space = true;
            }
            builder.append(NAMES.get(i));
        }
        return builder.toString();
    }
}

