/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.it.unimi.dsi.fastutil.Hash;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ConstantCanonicalizer {
    private static final int MAX_CANONICALIZED_CONSTANT = 15;

    public static void canonicalize(IRCode code) {
        Object2ObjectLinkedOpenCustomHashMap<ConstInstruction, List> valuesDefinedByConstant = new Object2ObjectLinkedOpenCustomHashMap<ConstInstruction, List>(new Hash.Strategy<ConstInstruction>(){

            @Override
            public int hashCode(ConstInstruction constInstruction) {
                assert (constInstruction.isConstNumber() || constInstruction.isConstString());
                if (constInstruction.isConstNumber()) {
                    return Long.hashCode(constInstruction.asConstNumber().getRawValue()) + 13 * constInstruction.outType().hashCode();
                }
                return constInstruction.asConstString().getValue().hashCode();
            }

            @Override
            public boolean equals(ConstInstruction a, ConstInstruction b) {
                assert (a == null || !a.outValue().hasLocalInfo());
                assert (b == null || !b.outValue().hasLocalInfo());
                return a == b || a != null && b != null && a.identicalNonValueNonPositionParts(b);
            }
        });
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction current = (Instruction)it.next();
                if (!current.isConstNumber() && !current.isConstString() || current.isConstString() && code.hasMonitorInstruction || current.outValue().hasLocalInfo() || ConstantCanonicalizer.constantUsedByInvokeRange(current.asConstInstruction())) continue;
                List oldValuesDefinedByConstant = valuesDefinedByConstant.computeIfAbsent(current.asConstInstruction(), k -> new ArrayList());
                oldValuesDefinedByConstant.add(current.outValue());
            }
        }
        if (valuesDefinedByConstant.isEmpty()) {
            return;
        }
        assert (!code.blocks.getFirst().hasCatchHandlers());
        Position firstNonNonePosition = ConstantCanonicalizer.findFirstNonNonePosition(code);
        ObjectSortedSet entries = valuesDefinedByConstant.object2ObjectEntrySet();
        entries.stream().filter(a -> ((List)a.getValue()).size() > 1).sorted((a, b) -> Integer.compare(((List)b.getValue()).size(), ((List)a.getValue()).size())).limit(15L).forEach(entry -> {
            ConstInstruction newConst;
            ConstInstruction canonicalizedConstant = ((ConstInstruction)entry.getKey()).asConstInstruction();
            assert (canonicalizedConstant.isConstNumber() || canonicalizedConstant.isConstString());
            if (canonicalizedConstant.isConstNumber()) {
                ConstNumber canonicalizedConstantNumber = canonicalizedConstant.asConstNumber();
                newConst = ConstNumber.copyOf(code, canonicalizedConstantNumber);
            } else {
                ConstString canonicalizedConstantString = canonicalizedConstant.asConstString();
                newConst = ConstString.copyOf(code, canonicalizedConstantString);
            }
            newConst.setPosition(firstNonNonePosition);
            ConstantCanonicalizer.insertCanonicalizedConstant(code, newConst);
            for (Value outValue : (List)entry.getValue()) {
                outValue.replaceUsers(newConst.outValue());
            }
        });
        code.removeAllTrivialPhis();
        assert (code.isConsistentSSA());
    }

    private static void insertCanonicalizedConstant(IRCode code, ConstInstruction canonicalizedConstant) {
        BasicBlock entryBlock = code.blocks.get(0);
        InstructionListIterator it = entryBlock.listIterator();
        while (it.hasNext()) {
            if (((Instruction)it.next()).isArgument()) continue;
            it.previous();
            break;
        }
        it.add(canonicalizedConstant);
    }

    private static Position findFirstNonNonePosition(IRCode code) {
        BasicBlock entryBlock = code.blocks.get(0);
        Instruction rightAfterArguments = entryBlock.listIterator().nextUntil(instr -> !instr.isArgument());
        Position firstNonArgumentPosition = rightAfterArguments.getPosition();
        HashSet<BasicBlock> visitedBlocks = new HashSet<BasicBlock>();
        while (rightAfterArguments != null && !visitedBlocks.contains(rightAfterArguments.getBlock())) {
            visitedBlocks.add(rightAfterArguments.getBlock());
            if (rightAfterArguments.isGoto()) {
                rightAfterArguments = rightAfterArguments.asGoto().getTarget().getInstructions().getFirst();
                continue;
            }
            if (!rightAfterArguments.getPosition().isSome()) break;
            return rightAfterArguments.getPosition();
        }
        return firstNonArgumentPosition;
    }

    private static boolean constantUsedByInvokeRange(ConstInstruction constant) {
        for (Instruction user : constant.outValue().uniqueUsers()) {
            if (!user.isInvoke() || user.asInvoke().requiredArgumentRegisters() <= 5) continue;
            return true;
        }
        return false;
    }
}

