/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;

public class TopDownClassHierarchyTraversal<T extends DexClass> {
    private final DexDefinitionSupplier definitions;
    private final Scope scope;
    private final Set<T> visited = new HashSet<T>();
    private final Deque<T> worklist = new ArrayDeque<T>();

    private TopDownClassHierarchyTraversal(DexDefinitionSupplier definitions, Scope scope) {
        this.definitions = definitions;
        this.scope = scope;
    }

    public static TopDownClassHierarchyTraversal<DexClass> forAllClasses(DexDefinitionSupplier definitions) {
        return new TopDownClassHierarchyTraversal<DexClass>(definitions, Scope.ALL_CLASSES);
    }

    public static TopDownClassHierarchyTraversal<DexProgramClass> forProgramClasses(DexDefinitionSupplier definitions) {
        return new TopDownClassHierarchyTraversal<DexProgramClass>(definitions, Scope.ONLY_PROGRAM_CLASSES);
    }

    public void visit(Iterable<DexProgramClass> sources, Consumer<T> visitor) {
        Iterator<DexProgramClass> sourceIterator = sources.iterator();
        while (sourceIterator.hasNext() || !this.worklist.isEmpty()) {
            DexClass clazz;
            if (this.worklist.isEmpty()) {
                this.addAncestorsToWorklist(sourceIterator.next());
                if (this.worklist.isEmpty()) continue;
            }
            if (!this.visited.add(clazz = (DexClass)this.worklist.removeFirst())) continue;
            assert (this.scope != Scope.ONLY_PROGRAM_CLASSES || clazz.isProgramClass());
            visitor.accept(clazz);
        }
        this.visited.clear();
    }

    private void addAncestorsToWorklist(DexClass clazz) {
        DexClass definition;
        DexClass clazzWithTypeT = clazz;
        if (this.visited.contains(clazzWithTypeT)) {
            return;
        }
        this.worklist.addFirst(clazzWithTypeT);
        if (clazz.superType != null && (definition = this.definitions.definitionFor(clazz.superType)) != null && (this.scope != Scope.ONLY_PROGRAM_CLASSES || definition.isProgramClass())) {
            this.addAncestorsToWorklist(definition);
        }
        for (DexType interfaceType : clazz.interfaces.values) {
            DexClass definition2 = this.definitions.definitionFor(interfaceType);
            if (definition2 == null || this.scope == Scope.ONLY_PROGRAM_CLASSES && !definition2.isProgramClass()) continue;
            this.addAncestorsToWorklist(definition2);
        }
    }

    private static enum Scope {
        ALL_CLASSES,
        ONLY_PROGRAM_CLASSES;

    }
}

