/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.cf.code.CfConstNull;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.code.Const;
import com.android.tools.r8.code.ConstString;
import com.android.tools.r8.code.ConstStringJumbo;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.InvokeDirect;
import com.android.tools.r8.code.InvokeStatic;
import com.android.tools.r8.code.NewInstance;
import com.android.tools.r8.code.Throw;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.JumboStringRewriter;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.OptimizationInfo;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.graph.ParameterUsagesInfo;
import com.android.tools.r8.graph.UpdatableOptimizationInfo;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.ir.synthetic.ForwardMethodSourceCode;
import com.android.tools.r8.ir.synthetic.SynthesizedCode;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class DexEncodedMethod
extends KeyedDexItem<DexMethod>
implements AppInfo.ResolutionResult {
    public static final DexEncodedMethod[] EMPTY_ARRAY = new DexEncodedMethod[0];
    public static final DexEncodedMethod SENTINEL = new DexEncodedMethod(null, null, null, null, null);
    public final DexMethod method;
    public final MethodAccessFlags accessFlags;
    public DexAnnotationSet annotations;
    public ParameterAnnotationsList parameterAnnotationsList;
    private Code code;
    private CompilationState compilationState = CompilationState.NOT_PROCESSED;
    private OptimizationInfo optimizationInfo = DefaultOptimizationInfoImpl.DEFAULT_INSTANCE;
    private int classFileVersion = -1;
    private boolean obsolete = false;

    private void checkIfObsolete() {
        assert (!this.obsolete);
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public void setObsolete() {
        this.obsolete = true;
    }

    public void unsetObsolete() {
        this.obsolete = false;
    }

    public DexEncodedMethod(DexMethod method, MethodAccessFlags accessFlags, DexAnnotationSet annotations, ParameterAnnotationsList parameterAnnotationsList, Code code) {
        this.method = method;
        this.accessFlags = accessFlags;
        this.annotations = annotations;
        this.parameterAnnotationsList = parameterAnnotationsList;
        this.code = code;
        assert (code == null || !this.shouldNotHaveCode());
        this.setCodeOwnership();
    }

    public DexEncodedMethod(DexMethod method, MethodAccessFlags flags, DexAnnotationSet annotationSet, ParameterAnnotationsList annotationsList, Code code, int classFileVersion) {
        this(method, flags, annotationSet, annotationsList, code);
        this.classFileVersion = classFileVersion;
    }

    public boolean isProcessed() {
        this.checkIfObsolete();
        return this.compilationState != CompilationState.NOT_PROCESSED;
    }

    public boolean isInitializer() {
        this.checkIfObsolete();
        return this.isInstanceInitializer() || this.isClassInitializer();
    }

    public boolean isInstanceInitializer() {
        this.checkIfObsolete();
        return this.accessFlags.isConstructor() && !this.accessFlags.isStatic();
    }

    public boolean isDefaultInitializer() {
        this.checkIfObsolete();
        return this.isInstanceInitializer() && this.method.proto.parameters.isEmpty();
    }

    public boolean isClassInitializer() {
        this.checkIfObsolete();
        return this.accessFlags.isConstructor() && this.accessFlags.isStatic();
    }

    public boolean isVirtualMethod() {
        this.checkIfObsolete();
        return !this.accessFlags.isStatic() && !this.accessFlags.isPrivate() && !this.accessFlags.isConstructor();
    }

    public boolean isNonAbstractVirtualMethod() {
        this.checkIfObsolete();
        return this.isVirtualMethod() && !this.accessFlags.isAbstract();
    }

    public boolean isPublicized() {
        this.checkIfObsolete();
        return this.accessFlags.isPromotedToPublic();
    }

    public boolean isPublicMethod() {
        this.checkIfObsolete();
        return this.accessFlags.isPublic();
    }

    public boolean isPrivateMethod() {
        this.checkIfObsolete();
        return this.accessFlags.isPrivate();
    }

    public boolean isDirectMethod() {
        this.checkIfObsolete();
        return (this.accessFlags.isPrivate() || this.accessFlags.isConstructor()) && !this.accessFlags.isStatic();
    }

    @Override
    public boolean isStatic() {
        this.checkIfObsolete();
        return this.accessFlags.isStatic();
    }

    @Override
    public boolean isStaticMember() {
        this.checkIfObsolete();
        return this.isStatic();
    }

    public boolean isSyntheticMethod() {
        this.checkIfObsolete();
        return this.accessFlags.isSynthetic();
    }

    public boolean isInliningCandidate(DexEncodedMethod container, Inliner.Reason inliningReason, AppInfoWithSubtyping appInfo) {
        this.checkIfObsolete();
        return this.isInliningCandidate(container.method.getHolder(), inliningReason, appInfo);
    }

    public boolean isInliningCandidate(DexType containerType, Inliner.Reason inliningReason, AppInfoWithSubtyping appInfo) {
        this.checkIfObsolete();
        if (this.isClassInitializer()) {
            return false;
        }
        if (inliningReason == Inliner.Reason.FORCE) {
            if (!this.isInliningCandidate(containerType, Inliner.Reason.SIMPLE, appInfo)) {
                throw new InternalCompilerError("FORCE inlining on non-inlinable: " + this.toSourceString());
            }
            return true;
        }
        switch (this.compilationState) {
            case PROCESSED_INLINING_CANDIDATE_ANY: {
                return true;
            }
            case PROCESSED_INLINING_CANDIDATE_SUBCLASS: {
                return containerType.isSubtypeOf(this.method.getHolder(), appInfo);
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE: {
                return containerType.isSamePackage(this.method.getHolder());
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_CLASS: {
                return containerType == this.method.getHolder();
            }
        }
        return false;
    }

    public boolean markProcessed(Inliner.ConstraintWithTarget state) {
        this.checkIfObsolete();
        CompilationState prevCompilationState = this.compilationState;
        switch (state.constraint) {
            case ALWAYS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_ANY;
                break;
            }
            case SUBCLASS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SUBCLASS;
                break;
            }
            case PACKAGE: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE;
                break;
            }
            case SAMECLASS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_CLASS;
                break;
            }
            case NEVER: {
                this.compilationState = CompilationState.PROCESSED_NOT_INLINING_CANDIDATE;
            }
        }
        return prevCompilationState != this.compilationState;
    }

    public void markNotProcessed() {
        this.checkIfObsolete();
        this.compilationState = CompilationState.NOT_PROCESSED;
    }

    public IRCode buildIR(AppInfo appInfo, GraphLense graphLense, InternalOptions options, Origin origin) {
        this.checkIfObsolete();
        return this.code == null ? null : this.code.buildIR(this, appInfo, graphLense, options, origin);
    }

    public IRCode buildInliningIRForTesting(InternalOptions options, ValueNumberGenerator valueNumberGenerator, AppInfo appInfo) {
        this.checkIfObsolete();
        return this.buildInliningIR(this, appInfo, GraphLense.getIdentityLense(), options, valueNumberGenerator, null, Origin.unknown());
    }

    public IRCode buildInliningIR(DexEncodedMethod context, AppInfo appInfo, GraphLense graphLense, InternalOptions options, ValueNumberGenerator valueNumberGenerator, Position callerPosition, Origin origin) {
        this.checkIfObsolete();
        return this.code.buildInliningIR(context, this, appInfo, graphLense, options, valueNumberGenerator, callerPosition, origin);
    }

    public void setCode(Code code) {
        this.checkIfObsolete();
        this.voidCodeOwnership();
        this.code = code;
        this.setCodeOwnership();
    }

    public void setCode(IRCode ir, RegisterAllocator registerAllocator, InternalOptions options) {
        this.checkIfObsolete();
        DexBuilder builder = new DexBuilder(ir, registerAllocator);
        this.setCode(builder.build());
    }

    public String toString() {
        this.checkIfObsolete();
        return "Encoded method " + this.method;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        this.checkIfObsolete();
        this.method.collectIndexedItems(indexedItems);
        if (this.code != null) {
            this.code.collectIndexedItems(indexedItems, this.method);
        }
        this.annotations.collectIndexedItems(indexedItems);
        this.parameterAnnotationsList.collectIndexedItems(indexedItems);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        if (this.code != null) {
            this.code.collectMixedSectionItems(mixedItems);
        }
        this.annotations.collectMixedSectionItems(mixedItems);
        this.parameterAnnotationsList.collectMixedSectionItems(mixedItems);
    }

    public boolean shouldNotHaveCode() {
        return this.accessFlags.isAbstract() || this.accessFlags.isNative();
    }

    public boolean hasCode() {
        return this.code != null;
    }

    public Code getCode() {
        this.checkIfObsolete();
        return this.code;
    }

    public void removeCode() {
        this.checkIfObsolete();
        this.voidCodeOwnership();
        this.code = null;
    }

    private void setCodeOwnership() {
        if (this.code != null) {
            this.code.setOwner(this);
        }
    }

    public void voidCodeOwnership() {
        if (this.code != null) {
            this.code.setOwner(null);
        }
    }

    public int getClassFileVersion() {
        this.checkIfObsolete();
        assert (this.classFileVersion >= 0);
        return this.classFileVersion;
    }

    public boolean hasClassFileVersion() {
        this.checkIfObsolete();
        return this.classFileVersion >= 0;
    }

    public void upgradeClassFileVersion(int version) {
        this.checkIfObsolete();
        assert (version >= 0);
        assert (!this.hasClassFileVersion() || version >= this.getClassFileVersion());
        this.classFileVersion = version;
    }

    public String qualifiedName() {
        this.checkIfObsolete();
        return this.method.qualifiedName();
    }

    public String descriptor() {
        this.checkIfObsolete();
        return this.descriptor(NamingLens.getIdentityLens());
    }

    public String descriptor(NamingLens namingLens) {
        this.checkIfObsolete();
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (DexType type : this.method.proto.parameters.values) {
            builder.append(namingLens.lookupDescriptor(type).toString());
        }
        builder.append(")");
        builder.append(namingLens.lookupDescriptor(this.method.proto.returnType).toString());
        return builder.toString();
    }

    public String toSmaliString(ClassNameMapper naming) {
        this.checkIfObsolete();
        StringBuilder builder = new StringBuilder();
        builder.append(".method ");
        builder.append(this.accessFlags.toSmaliString());
        builder.append(" ");
        builder.append(this.method.name.toSmaliString());
        builder.append(this.method.proto.toSmaliString());
        builder.append("\n");
        if (this.code != null) {
            DexCode dexCode = this.code.asDexCode();
            builder.append("    .registers ");
            builder.append(dexCode.registerSize);
            builder.append("\n\n");
            builder.append(dexCode.toSmaliString(naming));
        }
        builder.append(".end method\n");
        return builder.toString();
    }

    @Override
    public String toSourceString() {
        this.checkIfObsolete();
        return this.method.toSourceString();
    }

    public DexEncodedMethod toAbstractMethod() {
        this.checkIfObsolete();
        assert (!this.accessFlags.isFinal());
        this.accessFlags.setAbstract();
        this.voidCodeOwnership();
        this.code = null;
        return this;
    }

    private DexCode generateCodeFromTemplate(int numberOfRegisters, int outRegisters, Instruction ... instructions) {
        int offset = 0;
        for (Instruction instruction : instructions) {
            assert (!(instruction instanceof ConstString));
            instruction.setOffset(offset);
            offset += instruction.getSize();
        }
        int requiredArgRegisters = this.accessFlags.isStatic() ? 0 : 1;
        for (DexType type : this.method.proto.parameters.values) {
            requiredArgRegisters += ValueType.fromDexType(type).requiredRegisters();
        }
        return new DexCode(Math.max(numberOfRegisters, requiredArgRegisters), requiredArgRegisters, outRegisters, instructions, new DexCode.Try[0], new DexCode.TryHandler[0], null);
    }

    public DexCode buildEmptyThrowingDexCode() {
        Instruction[] insn = new Instruction[]{new Const(0, 0), new Throw(0)};
        return this.generateCodeFromTemplate(1, 0, insn);
    }

    public DexEncodedMethod toEmptyThrowingMethodDex() {
        this.checkIfObsolete();
        assert (!this.shouldNotHaveCode());
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(this.buildEmptyThrowingDexCode());
        return builder.build();
    }

    public CfCode buildEmptyThrowingCfCode() {
        CfInstruction[] insn = new CfInstruction[]{new CfConstNull(), new CfThrow()};
        return new CfCode(this.method, 1, this.method.proto.parameters.size() + 1, Arrays.asList(insn), Collections.emptyList(), Collections.emptyList());
    }

    public DexEncodedMethod toEmptyThrowingMethodCf() {
        this.checkIfObsolete();
        assert (!this.shouldNotHaveCode());
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(this.buildEmptyThrowingCfCode());
        return builder.build();
    }

    public DexEncodedMethod toMethodThatLogsError(DexItemFactory itemFactory) {
        this.checkIfObsolete();
        MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod(this.method);
        DexString message = itemFactory.createString("Shaking error: Missing method in " + this.method.holder.toSourceString() + ": " + signature);
        DexString tag = itemFactory.createString("TOIGHTNESS");
        DexType[] args = new DexType[]{itemFactory.stringType, itemFactory.stringType};
        DexProto proto = itemFactory.createProto(itemFactory.intType, args);
        DexMethod logMethod = itemFactory.createMethod(itemFactory.createType("Landroid/util/Log;"), proto, itemFactory.createString("e"));
        DexType exceptionType = itemFactory.createType("Ljava/lang/RuntimeException;");
        DexMethod exceptionInitMethod = itemFactory.createMethod(exceptionType, itemFactory.createProto(itemFactory.voidType, itemFactory.stringType), itemFactory.constructorMethodName);
        DexCode code = this.isInstanceInitializer() ? this.generateCodeFromTemplate(3, 2, new ConstStringJumbo(0, tag), new ConstStringJumbo(1, message), new InvokeStatic(2, logMethod, 0, 1, 0, 0, 0), new NewInstance(0, exceptionType), new InvokeDirect(2, exceptionInitMethod, 0, 1, 0, 0, 0), new Throw(0), new InvokeDirect(1, this.method, 2, 0, 0, 0, 0)) : this.generateCodeFromTemplate(2, 2, new ConstStringJumbo(0, tag), new ConstStringJumbo(1, message), new InvokeStatic(2, logMethod, 0, 1, 0, 0, 0), new NewInstance(0, exceptionType), new InvokeDirect(2, exceptionInitMethod, 0, 1, 0, 0, 0), new Throw(0));
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(code);
        this.setObsolete();
        return builder.build();
    }

    public DexEncodedMethod toTypeSubstitutedMethod(DexMethod method) {
        this.checkIfObsolete();
        if (this.method == method) {
            return this;
        }
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(method);
        return builder.build();
    }

    public DexEncodedMethod toRenamedMethod(DexString name, DexItemFactory factory) {
        this.checkIfObsolete();
        if (this.method.name == name) {
            return this;
        }
        DexMethod newMethod = factory.createMethod(this.method.holder, this.method.proto, name);
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(newMethod);
        this.setObsolete();
        return builder.build();
    }

    public DexEncodedMethod toForwardingMethod(DexClass holder, DexItemFactory itemFactory) {
        this.checkIfObsolete();
        this.accessFlags.unsetFinal();
        DexMethod newMethod = itemFactory.createMethod(holder.type, this.method.proto, this.method.name);
        Invoke.Type type = this.accessFlags.isStatic() ? Invoke.Type.STATIC : Invoke.Type.SUPER;
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(newMethod);
        if (this.accessFlags.isAbstract()) {
            builder.accessFlags.setAbstract();
        } else {
            builder.setCode(new SynthesizedCode(callerPosition -> new ForwardMethodSourceCode(this.accessFlags.isStatic() ? null : holder.type, newMethod, newMethod, this.accessFlags.isStatic() ? null : this.method.holder, this.method, type, callerPosition), registry -> {
                if (this.accessFlags.isStatic()) {
                    registry.registerInvokeStatic(this.method);
                } else {
                    registry.registerInvokeSuper(this.method);
                }
            }));
        }
        builder.accessFlags.setSynthetic();
        return builder.build();
    }

    public DexEncodedMethod toStaticMethodWithoutThis() {
        this.checkIfObsolete();
        assert (!this.accessFlags.isStatic());
        Builder builder = DexEncodedMethod.builder(this).setStatic().unsetOptimizationInfo().withoutThisParameter();
        this.setObsolete();
        return builder.build();
    }

    public synchronized void rewriteCodeWithJumboStrings(ObjectToOffsetMapping mapping, DexApplication application, boolean force) {
        this.checkIfObsolete();
        assert (this.code == null || this.code.isDexCode());
        if (this.code == null) {
            return;
        }
        DexCode code = this.code.asDexCode();
        DexString firstJumboString = null;
        if (force) {
            firstJumboString = mapping.getFirstString();
        } else {
            assert (code.highestSortingString != null || Arrays.stream(code.instructions).noneMatch(Instruction::isConstString));
            assert (Arrays.stream(code.instructions).noneMatch(Instruction::isDexItemBasedConstString));
            if (code.highestSortingString != null && mapping.getOffsetFor(code.highestSortingString) > 65535) {
                firstJumboString = mapping.getFirstJumboString();
            }
        }
        if (firstJumboString != null) {
            JumboStringRewriter rewriter = new JumboStringRewriter(this, firstJumboString, application.dexItemFactory);
            rewriter.rewrite();
        }
    }

    public String codeToString() {
        this.checkIfObsolete();
        return this.code == null ? "<no code>" : this.code.toString(this, null);
    }

    @Override
    public DexMethod getKey() {
        return this.method;
    }

    @Override
    public DexReference toReference() {
        this.checkIfObsolete();
        return this.method;
    }

    @Override
    public boolean isDexEncodedMethod() {
        this.checkIfObsolete();
        return true;
    }

    @Override
    public DexEncodedMethod asDexEncodedMethod() {
        this.checkIfObsolete();
        return this;
    }

    public boolean hasAnnotation() {
        this.checkIfObsolete();
        return !this.annotations.isEmpty() || !this.parameterAnnotationsList.isEmpty();
    }

    public void registerCodeReferences(UseRegistry registry) {
        this.checkIfObsolete();
        if (this.code != null) {
            this.code.registerCodeReferences(registry);
        }
    }

    public static int slowCompare(DexEncodedMethod m1, DexEncodedMethod m2) {
        return m1.method.slowCompareTo(m2.method);
    }

    public OptimizationInfo getOptimizationInfo() {
        this.checkIfObsolete();
        return this.optimizationInfo;
    }

    public synchronized UpdatableOptimizationInfo getMutableOptimizationInfo() {
        this.checkIfObsolete();
        if (this.optimizationInfo == DefaultOptimizationInfoImpl.DEFAULT_INSTANCE) {
            this.optimizationInfo = this.optimizationInfo.mutableCopy();
        }
        return (UpdatableOptimizationInfo)this.optimizationInfo;
    }

    public void setOptimizationInfo(UpdatableOptimizationInfo info) {
        this.checkIfObsolete();
        this.optimizationInfo = info;
    }

    public void copyMetadata(DexEncodedMethod from) {
        this.checkIfObsolete();
        if (from.getOptimizationInfo().useIdentifierNameString()) {
            this.getMutableOptimizationInfo().markUseIdentifierNameString();
        }
        if (from.classFileVersion > this.classFileVersion) {
            this.upgradeClassFileVersion(from.getClassFileVersion());
        }
    }

    private static Builder builder(DexEncodedMethod from) {
        return new Builder(from);
    }

    @Override
    public DexEncodedMethod asResultOfResolve() {
        this.checkIfObsolete();
        return this;
    }

    @Override
    public DexEncodedMethod asSingleTarget() {
        this.checkIfObsolete();
        return this;
    }

    @Override
    public boolean hasSingleTarget() {
        this.checkIfObsolete();
        return true;
    }

    @Override
    public List<DexEncodedMethod> asListOfTargets() {
        this.checkIfObsolete();
        return Collections.singletonList(this);
    }

    @Override
    public void forEachTarget(Consumer<DexEncodedMethod> consumer) {
        this.checkIfObsolete();
        consumer.accept(this);
    }

    private static class Builder {
        private DexMethod method;
        private final MethodAccessFlags accessFlags;
        private final DexAnnotationSet annotations;
        private final ParameterAnnotationsList parameterAnnotations;
        private Code code;
        private CompilationState compilationState;
        private OptimizationInfo optimizationInfo;
        private final int classFileVersion;

        private Builder(DexEncodedMethod from) {
            this.method = from.method;
            this.accessFlags = from.accessFlags.copy();
            this.annotations = from.annotations;
            this.parameterAnnotations = from.parameterAnnotationsList;
            this.code = from.code;
            this.compilationState = from.compilationState;
            this.optimizationInfo = from.optimizationInfo.mutableCopy();
            this.classFileVersion = from.classFileVersion;
        }

        public void setMethod(DexMethod method) {
            this.method = method;
        }

        public Builder setStatic() {
            this.accessFlags.setStatic();
            return this;
        }

        public Builder unsetOptimizationInfo() {
            this.optimizationInfo = DefaultOptimizationInfoImpl.DEFAULT_INSTANCE;
            return this;
        }

        public Builder withoutThisParameter() {
            assert (this.code != null);
            if (!this.code.isDexCode()) {
                throw new Unreachable("Code " + this.code.getClass().getSimpleName() + " is not supported.");
            }
            this.code = this.code.asDexCode().withoutThisParameter();
            return this;
        }

        public void setCode(Code code) {
            this.code = code;
        }

        public DexEncodedMethod build() {
            assert (this.method != null);
            assert (this.accessFlags != null);
            assert (this.annotations != null);
            assert (this.parameterAnnotations != null);
            DexEncodedMethod result = new DexEncodedMethod(this.method, this.accessFlags, this.annotations, this.parameterAnnotations, this.code, this.classFileVersion);
            result.compilationState = this.compilationState;
            result.optimizationInfo = this.optimizationInfo;
            return result;
        }
    }

    public static class OptimizationInfoImpl
    implements UpdatableOptimizationInfo {
        private int returnedArgument = DefaultOptimizationInfoImpl.UNKNOWN_RETURNED_ARGUMENT;
        private boolean neverReturnsNull = DefaultOptimizationInfoImpl.UNKNOWN_NEVER_RETURNS_NULL;
        private boolean neverReturnsNormally = DefaultOptimizationInfoImpl.UNKNOWN_NEVER_RETURNS_NORMALLY;
        private boolean returnsConstant = DefaultOptimizationInfoImpl.UNKNOWN_RETURNS_CONSTANT;
        private long returnedConstant = DefaultOptimizationInfoImpl.UNKNOWN_RETURNED_CONSTANT;
        private boolean publicized = DefaultOptimizationInfoImpl.NOT_PUBLICZED;
        private OptimizationInfo.InlinePreference inlining = OptimizationInfo.InlinePreference.Default;
        private boolean useIdentifierNameString = DefaultOptimizationInfoImpl.DOES_NOT_USE_IDNETIFIER_NAME_STRING;
        private boolean checksNullReceiverBeforeAnySideEffect = DefaultOptimizationInfoImpl.UNKNOWN_CHECKS_NULL_RECEIVER_BEFORE_ANY_SIDE_EFFECT;
        private boolean triggersClassInitBeforeAnySideEffect = DefaultOptimizationInfoImpl.UNKNOWN_TRIGGERS_CLASS_INIT_BEFORE_ANY_SIDE_EFFECT;
        private ClassInlinerEligibility classInlinerEligibility = DefaultOptimizationInfoImpl.UNKNOWN_CLASS_INLINER_ELIGIBILITY;
        private TrivialInitializer trivialInitializerInfo = DefaultOptimizationInfoImpl.UNKNOWN_TRIVIAL_INITIALIZER;
        private boolean initializerEnablingJavaAssertions = DefaultOptimizationInfoImpl.UNKNOWN_INITIALIZER_ENABLING_JAVA_ASSERTIONS;
        private ParameterUsagesInfo parametersUsages = DefaultOptimizationInfoImpl.UNKNOWN_PARAMETER_USAGE_INFO;
        private BitSet nonNullParamOrThrow = null;
        private BitSet nonNullParamOnNormalExits = null;
        private boolean reachabilitySensitive = false;

        private OptimizationInfoImpl() {
        }

        private OptimizationInfoImpl(OptimizationInfoImpl template) {
            this.returnedArgument = template.returnedArgument;
            this.neverReturnsNull = template.neverReturnsNull;
            this.neverReturnsNormally = template.neverReturnsNormally;
            this.returnsConstant = template.returnsConstant;
            this.returnedConstant = template.returnedConstant;
            this.publicized = template.publicized;
            this.inlining = template.inlining;
            this.useIdentifierNameString = template.useIdentifierNameString;
            this.checksNullReceiverBeforeAnySideEffect = template.checksNullReceiverBeforeAnySideEffect;
            this.triggersClassInitBeforeAnySideEffect = template.triggersClassInitBeforeAnySideEffect;
            this.classInlinerEligibility = template.classInlinerEligibility;
            this.trivialInitializerInfo = template.trivialInitializerInfo;
            this.initializerEnablingJavaAssertions = template.initializerEnablingJavaAssertions;
            this.parametersUsages = template.parametersUsages;
            this.nonNullParamOrThrow = template.nonNullParamOrThrow;
            this.nonNullParamOnNormalExits = template.nonNullParamOnNormalExits;
            this.reachabilitySensitive = template.reachabilitySensitive;
        }

        @Override
        public TrivialInitializer getTrivialInitializerInfo() {
            return this.trivialInitializerInfo;
        }

        @Override
        public ParameterUsagesInfo.ParameterUsage getParameterUsages(int parameter) {
            return this.parametersUsages == null ? null : this.parametersUsages.getParameterUsage(parameter);
        }

        @Override
        public BitSet getNonNullParamOrThrow() {
            return this.nonNullParamOrThrow;
        }

        @Override
        public BitSet getNonNullParamOnNormalExits() {
            return this.nonNullParamOnNormalExits;
        }

        @Override
        public boolean isReachabilitySensitive() {
            return this.reachabilitySensitive;
        }

        @Override
        public boolean returnsArgument() {
            return this.returnedArgument != -1;
        }

        @Override
        public int getReturnedArgument() {
            assert (this.returnsArgument());
            return this.returnedArgument;
        }

        @Override
        public boolean neverReturnsNull() {
            return this.neverReturnsNull;
        }

        @Override
        public boolean neverReturnsNormally() {
            return this.neverReturnsNormally;
        }

        @Override
        public boolean returnsConstant() {
            return this.returnsConstant;
        }

        @Override
        public ClassInlinerEligibility getClassInlinerEligibility() {
            return this.classInlinerEligibility;
        }

        @Override
        public long getReturnedConstant() {
            assert (this.returnsConstant());
            return this.returnedConstant;
        }

        @Override
        public boolean isInitializerEnablingJavaAssertions() {
            return this.initializerEnablingJavaAssertions;
        }

        @Override
        public boolean useIdentifierNameString() {
            return this.useIdentifierNameString;
        }

        @Override
        public boolean forceInline() {
            return this.inlining == OptimizationInfo.InlinePreference.ForceInline;
        }

        @Override
        public boolean neverInline() {
            return this.inlining == OptimizationInfo.InlinePreference.NeverInline;
        }

        @Override
        public boolean checksNullReceiverBeforeAnySideEffect() {
            return this.checksNullReceiverBeforeAnySideEffect;
        }

        @Override
        public boolean triggersClassInitBeforeAnySideEffect() {
            return this.triggersClassInitBeforeAnySideEffect;
        }

        @Override
        public void setParameterUsages(ParameterUsagesInfo parametersUsages) {
            this.parametersUsages = parametersUsages;
        }

        @Override
        public void setNonNullParamOrThrow(BitSet facts) {
            this.nonNullParamOrThrow = facts;
        }

        @Override
        public void setNonNullParamOnNormalExits(BitSet facts) {
            this.nonNullParamOnNormalExits = facts;
        }

        @Override
        public void setReachabilitySensitive(boolean reachabilitySensitive) {
            this.reachabilitySensitive = reachabilitySensitive;
        }

        @Override
        public void setClassInlinerEligibility(ClassInlinerEligibility eligibility) {
            this.classInlinerEligibility = eligibility;
        }

        @Override
        public void setTrivialInitializer(TrivialInitializer info) {
            this.trivialInitializerInfo = info;
        }

        @Override
        public void setInitializerEnablingJavaAssertions() {
            this.initializerEnablingJavaAssertions = true;
        }

        @Override
        public void markReturnsArgument(int argument) {
            assert (argument >= 0);
            assert (this.returnedArgument == -1 || this.returnedArgument == argument);
            this.returnedArgument = argument;
        }

        @Override
        public void markNeverReturnsNull() {
            this.neverReturnsNull = true;
        }

        @Override
        public void markNeverReturnsNormally() {
            this.neverReturnsNormally = true;
        }

        @Override
        public void markReturnsConstant(long value) {
            assert (!this.returnsConstant || this.returnedConstant == value);
            this.returnsConstant = true;
            this.returnedConstant = value;
        }

        @Override
        public void markForceInline() {
            assert (this.inlining == OptimizationInfo.InlinePreference.Default || this.inlining == OptimizationInfo.InlinePreference.ForceInline);
            this.inlining = OptimizationInfo.InlinePreference.ForceInline;
        }

        @Override
        public void unsetForceInline() {
            assert (this.inlining == OptimizationInfo.InlinePreference.Default || this.inlining == OptimizationInfo.InlinePreference.ForceInline);
            this.inlining = OptimizationInfo.InlinePreference.Default;
        }

        @Override
        public void markNeverInline() {
            assert (this.inlining == OptimizationInfo.InlinePreference.Default || this.inlining == OptimizationInfo.InlinePreference.NeverInline);
            this.inlining = OptimizationInfo.InlinePreference.NeverInline;
        }

        @Override
        public void markPublicized() {
            this.publicized = true;
        }

        @Override
        public void unsetPublicized() {
            this.publicized = false;
        }

        @Override
        public void markUseIdentifierNameString() {
            this.useIdentifierNameString = true;
        }

        @Override
        public void markCheckNullReceiverBeforeAnySideEffect(boolean mark) {
            this.checksNullReceiverBeforeAnySideEffect = mark;
        }

        @Override
        public void markTriggerClassInitBeforeAnySideEffect(boolean mark) {
            this.triggersClassInitBeforeAnySideEffect = mark;
        }

        @Override
        public UpdatableOptimizationInfo mutableCopy() {
            assert (this != DefaultOptimizationInfoImpl.DEFAULT_INSTANCE);
            return new OptimizationInfoImpl(this);
        }
    }

    public static class DefaultOptimizationInfoImpl
    implements OptimizationInfo {
        public static final OptimizationInfo DEFAULT_INSTANCE = new DefaultOptimizationInfoImpl();
        public static int UNKNOWN_RETURNED_ARGUMENT = -1;
        public static boolean UNKNOWN_NEVER_RETURNS_NULL = false;
        public static boolean UNKNOWN_NEVER_RETURNS_NORMALLY = false;
        public static boolean UNKNOWN_RETURNS_CONSTANT = false;
        public static int UNKNOWN_RETURNED_CONSTANT = -1;
        public static boolean NOT_PUBLICZED = false;
        public static boolean DOES_NOT_USE_IDNETIFIER_NAME_STRING = false;
        public static boolean UNKNOWN_CHECKS_NULL_RECEIVER_BEFORE_ANY_SIDE_EFFECT = false;
        public static boolean UNKNOWN_TRIGGERS_CLASS_INIT_BEFORE_ANY_SIDE_EFFECT = false;
        public static ClassInlinerEligibility UNKNOWN_CLASS_INLINER_ELIGIBILITY = null;
        public static TrivialInitializer UNKNOWN_TRIVIAL_INITIALIZER = null;
        public static boolean UNKNOWN_INITIALIZER_ENABLING_JAVA_ASSERTIONS = false;
        public static ParameterUsagesInfo UNKNOWN_PARAMETER_USAGE_INFO = null;
        public static BitSet NO_NULL_PARAMETER_OR_THROW_FACTS = null;
        public static BitSet NO_NULL_PARAMETER_ON_NORMAL_EXITS_FACTS = null;

        private DefaultOptimizationInfoImpl() {
        }

        @Override
        public TrivialInitializer getTrivialInitializerInfo() {
            return UNKNOWN_TRIVIAL_INITIALIZER;
        }

        @Override
        public ParameterUsagesInfo.ParameterUsage getParameterUsages(int parameter) {
            assert (UNKNOWN_PARAMETER_USAGE_INFO == null);
            return null;
        }

        @Override
        public BitSet getNonNullParamOrThrow() {
            return NO_NULL_PARAMETER_OR_THROW_FACTS;
        }

        @Override
        public BitSet getNonNullParamOnNormalExits() {
            return NO_NULL_PARAMETER_ON_NORMAL_EXITS_FACTS;
        }

        @Override
        public boolean isReachabilitySensitive() {
            return false;
        }

        @Override
        public boolean returnsArgument() {
            return false;
        }

        @Override
        public int getReturnedArgument() {
            assert (this.returnsArgument());
            return UNKNOWN_RETURNED_ARGUMENT;
        }

        @Override
        public boolean neverReturnsNull() {
            return UNKNOWN_NEVER_RETURNS_NULL;
        }

        @Override
        public boolean neverReturnsNormally() {
            return UNKNOWN_NEVER_RETURNS_NORMALLY;
        }

        @Override
        public boolean returnsConstant() {
            return UNKNOWN_RETURNS_CONSTANT;
        }

        @Override
        public ClassInlinerEligibility getClassInlinerEligibility() {
            return UNKNOWN_CLASS_INLINER_ELIGIBILITY;
        }

        @Override
        public long getReturnedConstant() {
            assert (this.returnsConstant());
            return 0L;
        }

        @Override
        public boolean isInitializerEnablingJavaAssertions() {
            return UNKNOWN_INITIALIZER_ENABLING_JAVA_ASSERTIONS;
        }

        @Override
        public boolean useIdentifierNameString() {
            return DOES_NOT_USE_IDNETIFIER_NAME_STRING;
        }

        @Override
        public boolean forceInline() {
            return false;
        }

        @Override
        public boolean neverInline() {
            return false;
        }

        @Override
        public boolean checksNullReceiverBeforeAnySideEffect() {
            return UNKNOWN_CHECKS_NULL_RECEIVER_BEFORE_ANY_SIDE_EFFECT;
        }

        @Override
        public boolean triggersClassInitBeforeAnySideEffect() {
            return UNKNOWN_TRIGGERS_CLASS_INIT_BEFORE_ANY_SIDE_EFFECT;
        }

        @Override
        public UpdatableOptimizationInfo mutableCopy() {
            return new OptimizationInfoImpl();
        }
    }

    public static class TrivialInitializer {
        private TrivialInitializer() {
        }

        public static final class TrivialClassInitializer
        extends TrivialInitializer {
            public final DexField field;

            public TrivialClassInitializer(DexField field) {
                this.field = field;
            }
        }

        public static final class TrivialInstanceInitializer
        extends TrivialInitializer {
            public static final TrivialInstanceInitializer INSTANCE = new TrivialInstanceInitializer();
        }
    }

    public static class ClassInlinerEligibility {
        public final boolean returnsReceiver;

        public ClassInlinerEligibility(boolean returnsReceiver) {
            this.returnsReceiver = returnsReceiver;
        }
    }

    public static enum CompilationState {
        NOT_PROCESSED,
        PROCESSED_NOT_INLINING_CANDIDATE,
        PROCESSED_INLINING_CANDIDATE_ANY,
        PROCESSED_INLINING_CANDIDATE_SUBCLASS,
        PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE,
        PROCESSED_INLINING_CANDIDATE_SAME_CLASS;

    }
}

