/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.compatdexbuilder;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.CompatDxHelper;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.ThreadUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class CompatDexBuilder {
    private String input = null;
    private String output = null;
    private int numberOfThreads = 8;
    private boolean noLocals = false;

    public static void main(String[] args) throws IOException, InterruptedException, ExecutionException {
        new CompatDexBuilder().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args) throws IOException, InterruptedException, ExecutionException {
        ArrayList<String> flags = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("@")) {
                flags.addAll(Files.readAllLines(Paths.get(arg.substring(1), new String[0])));
                continue;
            }
            flags.add(arg);
        }
        block36: for (int i = 0; i < flags.size(); ++i) {
            String flag = (String)flags.get(i);
            if (flag.startsWith("--positions=")) {
                String positionsValue = flag.substring("--positions=".length());
                if (!positionsValue.startsWith("throwing") && !positionsValue.startsWith("important")) continue;
                this.noLocals = true;
                continue;
            }
            if (flag.startsWith("--num-threads=")) {
                this.numberOfThreads = Integer.parseInt(flag.substring("--num-threads=".length()));
                continue;
            }
            switch (flag) {
                case "--input_jar": {
                    this.input = (String)flags.get(++i);
                    continue block36;
                }
                case "--output_zip": {
                    this.output = (String)flags.get(++i);
                    continue block36;
                }
                case "--verify-dex-file": 
                case "--no-verify-dex-file": 
                case "--show_flags": 
                case "--no-optimize": 
                case "--nooptimize": 
                case "--help": {
                    continue block36;
                }
                case "--nolocals": {
                    this.noLocals = true;
                    continue block36;
                }
                default: {
                    System.err.println("Unsupported option: " + flag);
                    System.exit(1);
                }
            }
        }
        if (this.input == null) {
            System.err.println("No input jar specified");
            System.exit(1);
        }
        if (this.output == null) {
            System.err.println("No output jar specified");
            System.exit(1);
        }
        ExecutorService executor = ThreadUtils.getExecutorService(this.numberOfThreads);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(Paths.get(this.output, new String[0]), new OpenOption[0]));){
            ArrayList<ZipEntry> toDex = new ArrayList<ZipEntry>();
            try (ZipFile zipFile = new ZipFile(this.input, StandardCharsets.UTF_8);){
                int i;
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(".class")) {
                        InputStream stream = zipFile.getInputStream(entry);
                        Throwable throwable = null;
                        try {
                            CompatDexBuilder.addEntry(entry.getName(), stream, out);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream != null) {
                                CompatDexBuilder.$closeResource(throwable, stream);
                            }
                            continue;
                        }
                    }
                    toDex.add(entry);
                }
                ArrayList<Future<DexConsumer>> futures = new ArrayList<Future<DexConsumer>>(toDex.size());
                for (i = 0; i < toDex.size(); ++i) {
                    ZipEntry classEntry = (ZipEntry)toDex.get(i);
                    futures.add(executor.submit(() -> this.dexEntry(zipFile, classEntry, executor)));
                }
                for (i = 0; i < futures.size(); ++i) {
                    ZipEntry entry = (ZipEntry)toDex.get(i);
                    DexConsumer consumer = (DexConsumer)((Future)futures.get(i)).get();
                    CompatDexBuilder.addEntry(entry.getName() + ".dex", consumer.getBytes(), out);
                }
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private DexConsumer dexEntry(ZipFile zipFile, ZipEntry classEntry, ExecutorService executor) throws IOException, CompilationFailedException {
        DexConsumer consumer = new DexConsumer();
        D8Command.Builder builder = D8Command.builder();
        CompatDxHelper.ignoreDexInArchive(builder);
        ((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)builder.setProgramConsumer(consumer)).setMode(this.noLocals ? CompilationMode.RELEASE : CompilationMode.DEBUG)).setMinApiLevel(AndroidApiLevel.H_MR2.getLevel())).setDisableDesugaring(true);
        try (InputStream stream = zipFile.getInputStream(classEntry);){
            builder.addClassProgramData(ByteStreams.toByteArray(stream), new ArchiveEntryOrigin(classEntry.getName(), new PathOrigin(Paths.get(zipFile.getName(), new String[0]))));
        }
        D8.run((D8Command)builder.build(), executor);
        return consumer;
    }

    private static void addEntry(String name, InputStream stream, ZipOutputStream out) throws IOException {
        CompatDexBuilder.addEntry(name, ByteStreams.toByteArray(stream), out);
    }

    private static void addEntry(String name, byte[] bytes, ZipOutputStream out) throws IOException {
        ZipEntry zipEntry = new ZipEntry(name);
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        zipEntry.setSize(bytes.length);
        zipEntry.setMethod(0);
        zipEntry.setCrc(crc32.getValue());
        zipEntry.setTime(0L);
        out.putNextEntry(zipEntry);
        out.write(bytes);
        out.closeEntry();
    }

    private static class DexConsumer
    extends DexIndexedConsumer.ForwardingConsumer {
        byte[] bytes;

        public DexConsumer() {
            super(null);
        }

        @Override
        public synchronized void accept(int fileIndex, ByteDataView data, Set<String> descriptors, DiagnosticsHandler handler) {
            super.accept(fileIndex, data, descriptors, handler);
            assert (this.bytes == null);
            this.bytes = data.copyByteData();
        }

        byte[] getBytes() {
            return this.bytes;
        }
    }
}

