/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.internal.compiler.SourceSearcher;
import com.android.builder.internal.incremental.DependencyData;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.sdklib.io.FileOp;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class AidlProcessor
implements SourceSearcher.SourceFileProcessor {
    @NonNull
    private final String mAidlExecutable;
    @NonNull
    private final String mFrameworkLocation;
    @NonNull
    private final List<File> mImportFolders;
    @NonNull
    private final File mSourceOutputDir;
    @Nullable
    private final File mParcelableOutputDir;
    @NonNull
    private final DependencyFileProcessor mDependencyFileProcessor;
    @NonNull
    private final ProcessExecutor mProcessExecutor;
    @NonNull
    private final ProcessOutputHandler mProcessOutputHandler;

    public AidlProcessor(@NonNull String aidlExecutable, @NonNull String frameworkLocation, @NonNull List<File> importFolders, @NonNull File sourceOutputDir, @Nullable File parcelableOutputDir, @NonNull DependencyFileProcessor dependencyFileProcessor, @NonNull ProcessExecutor processExecutor, @NonNull ProcessOutputHandler processOutputHandler) {
        this.mAidlExecutable = aidlExecutable;
        this.mFrameworkLocation = frameworkLocation;
        this.mImportFolders = importFolders;
        this.mSourceOutputDir = sourceOutputDir;
        this.mParcelableOutputDir = parcelableOutputDir;
        this.mDependencyFileProcessor = dependencyFileProcessor;
        this.mProcessExecutor = processExecutor;
        this.mProcessOutputHandler = processOutputHandler;
    }

    @Override
    public void processFile(@NonNull File sourceFolder, @NonNull File sourceFile) throws ProcessException, IOException {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.mAidlExecutable);
        builder.addArgs("-p" + this.mFrameworkLocation);
        builder.addArgs("-o" + this.mSourceOutputDir.getAbsolutePath());
        for (File f : this.mImportFolders) {
            builder.addArgs("-I" + f.getAbsolutePath());
        }
        File depFile = File.createTempFile("aidl", ".d");
        builder.addArgs("-d" + depFile.getAbsolutePath());
        builder.addArgs(sourceFile.getAbsolutePath());
        ProcessResult result = this.mProcessExecutor.execute(builder.createProcess(), this.mProcessOutputHandler);
        result.rethrowFailure().assertNormalExitValue();
        DependencyData data = this.mDependencyFileProcessor.processFile(depFile);
        if (this.mParcelableOutputDir != null && data != null && data.getOutputFiles().isEmpty()) {
            String relative = FileOp.makeRelative((File)sourceFolder, (File)sourceFile);
            File destFile = new File(this.mParcelableOutputDir, relative);
            destFile.getParentFile().mkdirs();
            Files.copy((File)sourceFile, (File)destFile);
            data.addSecondaryOutputFile(destFile.getPath());
        }
        depFile.delete();
    }
}

