/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.process.BaseProcessOutputHandler;
import com.android.ide.common.process.CachedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.SdkUtils;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApkInfoParser {
    private static final Pattern PATTERN = Pattern.compile("^package: name='([^']+)' versionCode='([0-9]*)' versionName='([^']*)'.*$");
    @NonNull
    private final File mAaptFile;
    @NonNull
    private final ProcessExecutor mProcessExecutor;

    public ApkInfoParser(@NonNull File aaptFile, @NonNull ProcessExecutor processExecutor) {
        this.mAaptFile = aaptFile;
        this.mProcessExecutor = processExecutor;
    }

    @NonNull
    public ApkInfo parseApk(@NonNull File apkFile) throws ProcessException {
        if (!this.mAaptFile.isFile()) {
            throw new IllegalStateException("aapt is missing from location: " + this.mAaptFile.getAbsolutePath());
        }
        return ApkInfoParser.getApkInfo(this.getAaptOutput(apkFile));
    }

    @NonNull
    static ApkInfo getApkInfo(@NonNull List<String> aaptOutput) {
        String pkgName = null;
        String versionCode = null;
        String versionName = null;
        for (String line : aaptOutput) {
            Matcher m = PATTERN.matcher(line);
            if (!m.matches()) continue;
            pkgName = m.group(1);
            versionCode = m.group(2);
            versionName = m.group(3);
            break;
        }
        if (pkgName == null) {
            throw new RuntimeException("Failed to find apk information with aapt");
        }
        Integer intVersionCode = null;
        try {
            intVersionCode = Integer.parseInt(versionCode);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        return new ApkInfo(pkgName, intVersionCode, versionName);
    }

    @NonNull
    private List<String> getAaptOutput(@NonNull File apkFile) throws ProcessException {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.mAaptFile);
        builder.addArgs("dump", "badging", apkFile.getPath());
        CachedProcessOutputHandler processOutputHandler = new CachedProcessOutputHandler();
        this.mProcessExecutor.execute(builder.createProcess(), (ProcessOutputHandler)processOutputHandler).rethrowFailure().assertNormalExitValue();
        BaseProcessOutputHandler.BaseProcessOutput output = processOutputHandler.getProcessOutput();
        return Splitter.on((String)SdkUtils.getLineSeparator()).splitToList((CharSequence)output.getStandardOutputAsString());
    }

    public static final class ApkInfo {
        @NonNull
        private final String mPackageName;
        @Nullable
        private final Integer mVersionCode;
        @Nullable
        private final String mVersionName;

        private ApkInfo(@NonNull String packageName, Integer versionCode, String versionName) {
            this.mPackageName = packageName;
            this.mVersionCode = versionCode;
            this.mVersionName = versionName;
        }

        @NonNull
        public String getPackageName() {
            return this.mPackageName;
        }

        @Nullable
        public Integer getVersionCode() {
            return this.mVersionCode;
        }

        @Nullable
        public String getVersionName() {
            return this.mVersionName;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("packageName", (Object)this.mPackageName).add("versionCode", (Object)this.mVersionCode).add("versionName", (Object)this.mVersionName).toString();
        }
    }
}

