/*
 * Decompiled with CFR 0.152.
 */
package com.andreabaccega.formedittextvalidator;

import android.widget.EditText;
import com.andreabaccega.formedittextvalidator.Validator;

public class CreditCardValidator
extends Validator {
    public CreditCardValidator(String _customErrorMessage) {
        super(_customErrorMessage);
    }

    @Override
    public boolean isValid(EditText et) {
        try {
            return CreditCardValidator.validateCardNumber(et.getText().toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean validateCardNumber(String cardNumber) throws NumberFormatException {
        int sum = 0;
        int addend = 0;
        boolean doubled = false;
        for (int i = cardNumber.length() - 1; i >= 0; --i) {
            int digit = Integer.parseInt(cardNumber.substring(i, i + 1));
            if (doubled) {
                addend = digit * 2;
                if (addend > 9) {
                    addend -= 9;
                }
            } else {
                addend = digit;
            }
            sum += addend;
            doubled = !doubled;
        }
        return sum % 10 == 0;
    }
}

