/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.parse;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Set;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.ec2.xml.DescribeSecurityGroupsResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DescribeSecurityGroupsResponseTest")
public class DescribeSecurityGroupsResponseTest
extends BaseEC2HandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/describe_security_groups_vpc.xml");
        Set<SecurityGroup> expected = this.expected();
        DescribeSecurityGroupsResponseHandler handler = (DescribeSecurityGroupsResponseHandler)this.injector.getInstance(DescribeSecurityGroupsResponseHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public Set<SecurityGroup> expected() {
        return ImmutableSet.of((Object)SecurityGroup.builder().region(this.defaultRegion).ownerId("123123123123").id("sg-11111111").name("default").description("default VPC security group").ipPermission(IpPermission.builder().ipProtocol(IpProtocol.ALL).tenantIdGroupNamePair("123123123123", "sg-11111111").build()).build());
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

