/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import org.jclouds.aws.ec2.options.DescribeSpotPriceHistoryOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DescribeSpotPriceHistoryOptionsTest {
    Date test = new Date(12345678910L);

    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(DescribeSpotPriceHistoryOptions.class));
        assert (!String.class.isAssignableFrom(DescribeSpotPriceHistoryOptions.class));
    }

    @Test
    public void testDescription() {
        DescribeSpotPriceHistoryOptions options = new DescribeSpotPriceHistoryOptions();
        options.productDescription("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ProductDescription"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testDescriptionStatic() {
        DescribeSpotPriceHistoryOptions options = DescribeSpotPriceHistoryOptions.Builder.productDescription((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ProductDescription"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testDescriptionNPE() {
        DescribeSpotPriceHistoryOptions.Builder.productDescription(null);
    }

    @Test
    public void testInstanceType() {
        DescribeSpotPriceHistoryOptions options = new DescribeSpotPriceHistoryOptions();
        options.instanceType("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"InstanceType.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testInstanceTypeStatic() {
        DescribeSpotPriceHistoryOptions options = DescribeSpotPriceHistoryOptions.Builder.instanceType((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"InstanceType.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testInstanceTypeNPE() {
        DescribeSpotPriceHistoryOptions.Builder.instanceType(null);
    }

    @Test
    public void testFrom() {
        DescribeSpotPriceHistoryOptions options = new DescribeSpotPriceHistoryOptions();
        options.from(this.test);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"StartTime"), (Collection)ImmutableList.of((Object)"1970-05-23T21:21:18.910Z"));
    }

    @Test
    public void testFromStatic() {
        DescribeSpotPriceHistoryOptions options = DescribeSpotPriceHistoryOptions.Builder.from((Date)this.test);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"StartTime"), (Collection)ImmutableList.of((Object)"1970-05-23T21:21:18.910Z"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testFromNPE() {
        DescribeSpotPriceHistoryOptions.Builder.from(null);
    }

    @Test
    public void testTo() {
        DescribeSpotPriceHistoryOptions options = new DescribeSpotPriceHistoryOptions();
        options.to(this.test);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"EndTime"), (Collection)ImmutableList.of((Object)"1970-05-23T21:21:18.910Z"));
    }

    @Test
    public void testToStatic() {
        DescribeSpotPriceHistoryOptions options = DescribeSpotPriceHistoryOptions.Builder.to((Date)this.test);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"EndTime"), (Collection)ImmutableList.of((Object)"1970-05-23T21:21:18.910Z"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testToNPE() {
        DescribeSpotPriceHistoryOptions.Builder.to(null);
    }
}

