/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jclouds.aws.ec2.options.AWSRunInstancesOptions;
import org.jclouds.aws.ec2.options.Tenancy;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AWSRunInstancesOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(AWSRunInstancesOptions.class));
        assert (!String.class.isAssignableFrom(AWSRunInstancesOptions.class));
    }

    @Test
    public void testWithKeyName() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        options.withKeyName("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KeyName"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithKeyName() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KeyName"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithKeyNameStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.withKeyName((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KeyName"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithKeyNameNPE() {
        AWSRunInstancesOptions.Builder.withKeyName(null);
    }

    @Test
    public void testWithSecurityGroup() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        options.withSecurityGroup("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SecurityGroup.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithSecurityGroup() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SecurityGroup"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithSecurityGroupStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.withSecurityGroup((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SecurityGroup.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithSecurityGroupNPE() {
        AWSRunInstancesOptions.Builder.withSecurityGroup(null);
    }

    @Test
    public void testWithSecurityGroupId() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        options.withSecurityGroupId("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SecurityGroupId.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithSecurityGroupId() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SecurityGroupId"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithSecurityGroupIdStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.withSecurityGroupId((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SecurityGroupId.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithSecurityGroupIdNPE() {
        AWSRunInstancesOptions.Builder.withSecurityGroupId(null);
    }

    @Test
    public void testNullWithAdditionalInfo() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"AdditionalInfo"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithUserData() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        options.withUserData("test".getBytes());
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"UserData"), (Collection)ImmutableList.of((Object)"dGVzdA=="));
    }

    @Test
    public void testNullWithUserData() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"UserData"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithUserDataStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.withUserData((byte[])"test".getBytes());
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"UserData"), (Collection)ImmutableList.of((Object)"dGVzdA=="));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithUserDataNPE() {
        AWSRunInstancesOptions.Builder.withUserData(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testWithUserDataEmpty() {
        AWSRunInstancesOptions.Builder.withUserData((byte[])"".getBytes());
    }

    @Test
    public void testWithInstanceType() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        options.asType("c1.xlarge");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"InstanceType"), (Collection)ImmutableList.of((Object)"c1.xlarge"));
    }

    @Test
    public void testNullWithInstanceType() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"InstanceType"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithInstanceTypeStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.asType((String)"c1.xlarge");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"InstanceType"), (Collection)ImmutableList.of((Object)"c1.xlarge"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithInstanceTypeNPE() {
        AWSRunInstancesOptions.Builder.asType(null);
    }

    @Test
    public void testWithKernelId() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        options.withKernelId("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KernelId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithKernelId() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KernelId"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithKernelIdStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.withKernelId((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KernelId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithKernelIdNPE() {
        AWSRunInstancesOptions.Builder.withKernelId(null);
    }

    @Test
    public void testWithMonitoringEnabled() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        options.enableMonitoring();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Monitoring.Enabled"), (Collection)ImmutableList.of((Object)"true"));
    }

    @Test
    public void testNullWithMonitoringEnabled() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Monitoring.Enabled"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithMonitoringEnabledStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.enableMonitoring();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Monitoring.Enabled"), (Collection)ImmutableList.of((Object)"true"));
    }

    @Test
    public void testWithSubnetId() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        options.withSubnetId("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SubnetId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithSubnetId() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SubnetId"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithSubnetIdStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.withSubnetId((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SubnetId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithSubnetIdNPE() {
        AWSRunInstancesOptions.Builder.withSubnetId(null);
    }

    @Test
    public void testWithIAMInstanceProfileArn() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        options.withIAMInstanceProfileArn("arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"IamInstanceProfile.Arn"), (Collection)ImmutableList.of((Object)"arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver"));
    }

    @Test
    public void testNullWithIAMInstanceProfileArn() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"IamInstanceProfile.Arn"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithIAMInstanceProfileArnStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.withIAMInstanceProfileArn((String)"arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"IamInstanceProfile.Arn"), (Collection)ImmutableList.of((Object)"arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithIAMInstanceProfileArnNPE() {
        AWSRunInstancesOptions.Builder.withIAMInstanceProfileArn(null);
    }

    @Test
    public void testWithIAMInstanceProfileName() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        options.withIAMInstanceProfileName("Webserver");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"IamInstanceProfile.Name"), (Collection)ImmutableList.of((Object)"Webserver"));
    }

    @Test
    public void testNullWithIAMInstanceProfileName() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"IamInstanceProfile.Name"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithIAMInstanceProfileNameStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.withIAMInstanceProfileName((String)"Webserver");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"IamInstanceProfile.Name"), (Collection)ImmutableList.of((Object)"Webserver"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithIAMInstanceProfileNameNPE() {
        AWSRunInstancesOptions.Builder.withIAMInstanceProfileName(null);
    }

    @Test
    public void testWithRamdisk() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        options.withRamdisk("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RamdiskId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithRamdisk() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RamdiskId"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithRamdiskStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.withRamdisk((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RamdiskId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithRamdiskNPE() {
        AWSRunInstancesOptions.Builder.withRamdisk(null);
    }

    @Test
    public void testNullWithVirtualName() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.VirtualName"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithBlockDeviceMapping() {
        BlockDeviceMapping.MapNewVolumeToDevice mapping = new BlockDeviceMapping.MapNewVolumeToDevice("/dev/sda1", Integer.valueOf(120), Boolean.valueOf(true), "gp2", Integer.valueOf(10), Boolean.valueOf(true));
        AWSRunInstancesOptions options = new AWSRunInstancesOptions().withBlockDeviceMappings((Set)ImmutableSet.of((Object)mapping));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.DeviceName"), (Collection)ImmutableList.of((Object)"/dev/sda1"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.Ebs.VolumeSize"), (Collection)ImmutableList.of((Object)"120"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.Ebs.DeleteOnTermination"), (Collection)ImmutableList.of((Object)"true"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.Ebs.VolumeType"), (Collection)ImmutableList.of((Object)"gp2"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.Ebs.Iops"), (Collection)ImmutableList.of((Object)"10"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.Ebs.Encrypted"), (Collection)ImmutableList.of((Object)"true"));
    }

    @Test
    public void testNullWithBlockDeviceMapping() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithBlockDeviceMappingStatic() {
        BlockDeviceMapping.MapNewVolumeToDevice mapping = new BlockDeviceMapping.MapNewVolumeToDevice("/dev/sda1", Integer.valueOf(120), Boolean.valueOf(true), null, null, Boolean.valueOf(false));
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.withBlockDeviceMappings((Set)ImmutableSet.of((Object)mapping));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.DeviceName"), (Collection)ImmutableList.of((Object)"/dev/sda1"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.Ebs.VolumeSize"), (Collection)ImmutableList.of((Object)"120"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.Ebs.DeleteOnTermination"), (Collection)ImmutableList.of((Object)"true"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithBlockDeviceMappingNPE() {
        AWSRunInstancesOptions.Builder.withBlockDeviceMappings(null);
    }

    @Test
    public void testWithPrivateIpAddressStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.withPrivateIpAdress((String)"10.0.0.1");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"PrivateIpAddress"), (Collection)ImmutableList.of((Object)"10.0.0.1"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithPrivateIpAddressStaticNPE() {
        AWSRunInstancesOptions.Builder.withPrivateIpAdress(null);
    }

    @Test
    public void testNullWithTenancy() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Placement.Tenancy"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithTenancy() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        options.withTenancy(Tenancy.DEDICATED);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Placement.Tenancy"), (Collection)ImmutableList.of((Object)"dedicated"));
    }

    @Test
    public void testWithTenancyStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.withTenancy((Tenancy)Tenancy.HOST);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Placement.Tenancy"), (Collection)ImmutableList.of((Object)"host"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithTenancyStaticNPE() {
        AWSRunInstancesOptions.Builder.withTenancy(null);
    }

    @Test
    public void testNullWithDedicatedHostId() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Placement.HostId"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithDedicatedHostId() {
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        options.withDedicatedHostId("hostId-1234");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Placement.HostId"), (Collection)ImmutableList.of((Object)"hostId-1234"));
    }

    @Test
    public void testWithDedicatedHostIdStatic() {
        AWSRunInstancesOptions options = AWSRunInstancesOptions.Builder.withDedicatedHostId((String)"hostId-5678");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Placement.HostId"), (Collection)ImmutableList.of((Object)"hostId-5678"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithDedicatedHostIdStaticNPE() {
        AWSRunInstancesOptions.Builder.withDedicatedHostId(null);
    }
}

