/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.jclouds.ContextBuilder;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.AWSEC2ProviderMetadata;
import org.jclouds.aws.ec2.config.AWSEC2HttpApiModule;
import org.jclouds.aws.filters.FormSignerV4;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.date.DateService;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class BaseAWSEC2ApiMockTest {
    protected static final String DEFAULT_REGION = "us-east-1";
    private static final String ACCESS_KEY = "AKIAIOSFODNN7EXAMPLE";
    private static final String SECRET_KEY = "wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY";
    private Map<String, MockWebServer> regionToServers = Maps.newLinkedHashMap();
    private final Set<Module> modules = ImmutableSet.of((Object)((Object)new MockAWSEC2HttpApiModule()), (Object)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor()));

    protected AWSEC2Api api() {
        return (AWSEC2Api)this.builder(new Properties()).buildApi(AWSEC2Api.class);
    }

    protected ComputeService computeService() {
        return ((ComputeServiceContext)this.builder(new Properties()).buildView(ComputeServiceContext.class)).getComputeService();
    }

    protected ContextBuilder builder(Properties overrides) {
        MockWebServer defaultServer = this.regionToServers.get(DEFAULT_REGION);
        overrides.setProperty("jclouds.max-retries", "1");
        overrides.setProperty("jclouds.compute.timeout.cleanup-incidental-resources", "0");
        return ContextBuilder.newBuilder((ProviderMetadata)new AWSEC2ProviderMetadata()).credentials(ACCESS_KEY, SECRET_KEY).endpoint(defaultServer.getUrl("").toString()).overrides(overrides).modules(this.modules);
    }

    @BeforeMethod
    public void start() throws IOException {
        MockWebServer server = new MockWebServer();
        server.play();
        this.regionToServers.put(DEFAULT_REGION, server);
    }

    @AfterMethod(alwaysRun=true)
    public void stop() throws IOException {
        for (MockWebServer server : this.regionToServers.values()) {
            server.shutdown();
        }
    }

    protected void enqueue(String region, MockResponse response) {
        this.regionToServers.get(region).enqueue(response);
    }

    protected void enqueueRegions(String ... regions) throws IOException {
        StringBuilder describeRegionsResponse = new StringBuilder();
        describeRegionsResponse.append("<DescribeRegionsResponse>");
        for (String region : regions) {
            MockWebServer server;
            describeRegionsResponse.append("<item>");
            describeRegionsResponse.append("<regionName>").append(region).append("</regionName>");
            if (!this.regionToServers.containsKey(region)) {
                server = new MockWebServer();
                server.play();
                this.regionToServers.put(region, server);
            }
            server = this.regionToServers.get(region);
            String regionEndpoint = server.getUrl("").toString();
            describeRegionsResponse.append("<regionEndpoint>").append(regionEndpoint).append("</regionEndpoint>");
            describeRegionsResponse.append("</item>");
        }
        describeRegionsResponse.append("</DescribeRegionsResponse>");
        this.enqueue(DEFAULT_REGION, new MockResponse().addHeader("Content-Type", (Object)"application/xml").setBody(describeRegionsResponse.toString()));
    }

    protected void enqueueXml(String region, String resource) {
        this.enqueue(region, new MockResponse().addHeader("Content-Type", (Object)"application/xml").setBody(this.stringFromResource(resource)));
    }

    protected String stringFromResource(String resourceName) {
        try {
            return Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream(resourceName));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected RecordedRequest assertPosted(String region, String postParams) throws InterruptedException {
        RecordedRequest request = this.regionToServers.get(region).takeRequest();
        Assert.assertEquals((String)request.getMethod(), (String)"POST");
        Assert.assertEquals((String)request.getPath(), (String)"/");
        Assert.assertEquals((String)request.getHeader("X-Amz-Date"), (String)"20120416T155408Z");
        Assertions.assertThat((String)request.getHeader("Authorization")).startsWith((CharSequence)("AWS4-HMAC-SHA256 Credential=AKIAIOSFODNN7EXAMPLE/20120416/" + region + "/ec2/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature="));
        String body = new String(request.getBody(), Charsets.UTF_8);
        Assertions.assertThat((String)body).contains(new CharSequence[]{"&Version=2012-06-01"});
        Assert.assertEquals((String)body.replace("&Version=2012-06-01", ""), (String)postParams);
        return request;
    }

    @ConfiguresHttpApi
    class MockAWSEC2HttpApiModule
    extends AWSEC2HttpApiModule {
        MockAWSEC2HttpApiModule() {
        }

        protected String provideTimeStamp(DateService dateService) {
            return "20120416T155408Z";
        }

        @Provides
        FormSignerV4.ServiceAndRegion serviceAndRegion() {
            return new FormSignerV4.ServiceAndRegion(){

                public String service() {
                    return "ec2";
                }

                public String region(String host) {
                    for (Map.Entry regionToServer : BaseAWSEC2ApiMockTest.this.regionToServers.entrySet()) {
                        MockWebServer server = (MockWebServer)regionToServer.getValue();
                        if (!host.equals(server.getHostName() + ":" + ((MockWebServer)regionToServer.getValue()).getPort())) continue;
                        return (String)regionToServer.getKey();
                    }
                    throw new IllegalStateException(host + " not found");
                }
            };
        }
    }
}

