/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.squareup.okhttp.mockwebserver.MockResponse;
import java.util.Date;
import java.util.Set;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.features.SpotInstanceApi;
import org.jclouds.aws.ec2.internal.BaseAWSEC2ApiMockTest;
import org.jclouds.aws.ec2.options.DescribeSpotPriceHistoryOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SpotInstanceApiMockTest", singleThreaded=true)
public class SpotInstanceApiMockTest
extends BaseAWSEC2ApiMockTest {
    public void describeSpotInstanceRequestsInRegionWithFilter() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/describe_spot_instance.xml");
        SpotInstanceRequest result = (SpotInstanceRequest)Iterables.getOnlyElement((Iterable)this.spotApi().describeSpotInstanceRequestsInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.of((Object)"instance-id", (Object)"i-ef308e8e")));
        Assert.assertEquals((String)result.getId(), (String)"sir-1ede0012");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeSpotInstanceRequests&Filter.1.Name=instance-id&Filter.1.Value.1=i-ef308e8e");
    }

    public void describeSpotInstanceRequestsInRegionWithFilter_404() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse().setResponseCode(404));
        Assert.assertEquals((Set)this.spotApi().describeSpotInstanceRequestsInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.of((Object)"instance-id", (Object)"i-ef308e8e")), (Set)ImmutableSet.of());
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeSpotInstanceRequests&Filter.1.Name=instance-id&Filter.1.Value.1=i-ef308e8e");
    }

    public void cancelSpotInstanceRequestsInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse());
        this.spotApi().cancelSpotInstanceRequestsInRegion("us-east-1", new String[]{"sir-f4d44212"});
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=CancelSpotInstanceRequests&SpotInstanceRequestId.1=sir-f4d44212");
    }

    public void cancelSpotInstanceRequestsInRegion_404() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse().setResponseCode(404));
        this.spotApi().cancelSpotInstanceRequestsInRegion("us-east-1", new String[]{"sir-f4d44212"});
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=CancelSpotInstanceRequests&SpotInstanceRequestId.1=sir-f4d44212");
    }

    public void describeSpotPriceHistoryInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/describe_spot_price_history.xml");
        Set result = this.spotApi().describeSpotPriceHistoryInRegion("us-east-1", new DescribeSpotPriceHistoryOptions[0]);
        Assert.assertEquals((int)result.size(), (int)3);
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeSpotPriceHistory");
    }

    public void describeSpotPriceHistoryInRegion_404() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse().setResponseCode(404));
        Set result = this.spotApi().describeSpotPriceHistoryInRegion("us-east-1", new DescribeSpotPriceHistoryOptions[0]);
        Assert.assertTrue((boolean)result.isEmpty());
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeSpotPriceHistory");
    }

    public void describeSpotPriceHistoryInRegionOptions() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/describe_spot_price_history.xml");
        Date from = new Date(12345678910L);
        Date to = new Date(1234567891011L);
        Set result = this.spotApi().describeSpotPriceHistoryInRegion("us-east-1", new DescribeSpotPriceHistoryOptions[]{DescribeSpotPriceHistoryOptions.Builder.from((Date)from).to(to).productDescription("description").instanceType("m1.small")});
        Assert.assertEquals((int)result.size(), (int)3);
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeSpotPriceHistory&StartTime=1970-05-23T21%3A21%3A18.910Z&EndTime=2009-02-13T23%3A31%3A31.011Z&ProductDescription=description&InstanceType.1=m1.small");
    }

    private SpotInstanceApi spotApi() {
        return (SpotInstanceApi)this.api().getSpotInstanceApi().get();
    }
}

