/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.squareup.okhttp.mockwebserver.MockResponse;
import java.util.Set;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.ec2.features.PlacementGroupApi;
import org.jclouds.aws.ec2.internal.BaseAWSEC2ApiMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="PlacementGroupApiMockTest", singleThreaded=true)
public class PlacementGroupApiMockTest
extends BaseAWSEC2ApiMockTest {
    public void describePlacementGroupsInRegionWithFilter() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/describe_placement_groups.xml");
        PlacementGroup result = (PlacementGroup)Iterables.getOnlyElement((Iterable)this.placementApi().describePlacementGroupsInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.of((Object)"strategy", (Object)"cluster")));
        Assert.assertEquals((String)result.getName(), (String)"XYZ-cluster");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribePlacementGroups&Filter.1.Name=strategy&Filter.1.Value.1=cluster");
    }

    public void describePlacementGroupsInRegionWithFilter_404() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse().setResponseCode(404));
        Assert.assertEquals((Set)this.placementApi().describePlacementGroupsInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.of((Object)"strategy", (Object)"cluster")), (Set)ImmutableSet.of());
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribePlacementGroups&Filter.1.Name=strategy&Filter.1.Value.1=cluster");
    }

    public void deletePlacementGroupInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse());
        this.placementApi().deletePlacementGroupInRegion("us-east-1", "name");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DeletePlacementGroup&GroupName=name");
    }

    public void deletePlacementGroupInRegion_404() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse().setResponseCode(404));
        this.placementApi().deletePlacementGroupInRegion("us-east-1", "name");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DeletePlacementGroup&GroupName=name");
    }

    public void createPlacementGroupInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse());
        this.placementApi().createPlacementGroupInRegion("us-east-1", "name");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=CreatePlacementGroup&Strategy=cluster&GroupName=name");
    }

    public void createPlacementGroupInRegion_strategy() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueue("us-east-1", new MockResponse());
        this.placementApi().createPlacementGroupInRegion("us-east-1", "name", "cluster");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=CreatePlacementGroup&GroupName=name&Strategy=cluster");
    }

    private PlacementGroupApi placementApi() {
        return (PlacementGroupApi)this.api().getPlacementGroupApi().get();
    }
}

