/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Module;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.aws.domain.Region;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.ec2.features.AWSInstanceApi;
import org.jclouds.aws.ec2.features.PlacementGroupApi;
import org.jclouds.aws.ec2.predicates.PlacementGroupAvailable;
import org.jclouds.aws.ec2.predicates.PlacementGroupDeleted;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.ec2.compute.domain.EC2HardwareBuilder;
import org.jclouds.ec2.features.AvailabilityZoneAndRegionApi;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.statements.java.InstallJDK;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="PlacementGroupApiLiveTest")
public class PlacementGroupApiLiveTest
extends BaseComputeServiceContextLiveTest {
    private final Set<String> supportedRegions = Region.DEFAULT_REGIONS;
    private AWSEC2Api client;
    private Predicate<PlacementGroup> availableTester;
    private Predicate<PlacementGroup> deletedTester;
    private PlacementGroup group;
    public static final String PREFIX = System.getProperty("user.name") + "ec2";

    public PlacementGroupApiLiveTest() {
        this.provider = "aws-ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.client = (AWSEC2Api)((ComputeServiceContext)this.view).unwrapApi(AWSEC2Api.class);
        this.availableTester = Predicates2.retry((Predicate)new PlacementGroupAvailable(this.client), (long)60L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.deletedTester = Predicates2.retry((Predicate)new PlacementGroupDeleted(this.client), (long)60L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    public void testDescribe() {
        for (String region : this.supportedRegions) {
            TreeSet allResults = Sets.newTreeSet((Iterable)((PlacementGroupApi)this.client.getPlacementGroupApi().get()).describePlacementGroupsInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.size() < 1) continue;
            PlacementGroup group = (PlacementGroup)allResults.last();
            TreeSet result = Sets.newTreeSet((Iterable)((PlacementGroupApi)this.client.getPlacementGroupApi().get()).describePlacementGroupsInRegion(region, new String[]{group.getName()}));
            Assert.assertNotNull((Object)result);
            PlacementGroup compare = (PlacementGroup)result.last();
            Assert.assertEquals((Object)compare, (Object)group);
        }
        for (String region : ((AvailabilityZoneAndRegionApi)this.client.getAvailabilityZoneAndRegionApi().get()).describeRegions(new DescribeRegionsOptions[0]).keySet()) {
            if (this.supportedRegions.contains(region)) continue;
            try {
                ((PlacementGroupApi)this.client.getPlacementGroupApi().get()).describePlacementGroupsInRegion(region, new String[0]);
                Assert.fail((String)("should be unsupported for region: " + region));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    @Test
    public void testFilter() {
        for (String region : this.supportedRegions) {
            TreeSet allResults = Sets.newTreeSet((Iterable)((PlacementGroupApi)this.client.getPlacementGroupApi().get()).describePlacementGroupsInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.size() < 1) continue;
            PlacementGroup group = (PlacementGroup)allResults.last();
            TreeSet result = Sets.newTreeSet((Iterable)((PlacementGroupApi)this.client.getPlacementGroupApi().get()).describePlacementGroupsInRegionWithFilter(region, (Multimap)ImmutableMultimap.builder().put((Object)"group-name", (Object)group.getName()).build()));
            Assert.assertNotNull((Object)result);
            PlacementGroup compare = (PlacementGroup)result.last();
            Assert.assertEquals((Object)compare, (Object)group);
        }
    }

    @Test(expectedExceptions={AWSResponseException.class})
    public void testFilterInvalid() {
        for (String region : this.supportedRegions) {
            TreeSet allResults = Sets.newTreeSet((Iterable)((PlacementGroupApi)this.client.getPlacementGroupApi().get()).describePlacementGroupsInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.size() < 1) continue;
            PlacementGroup group = (PlacementGroup)allResults.last();
            ((PlacementGroupApi)this.client.getPlacementGroupApi().get()).describePlacementGroupsInRegionWithFilter(region, (Multimap)ImmutableMultimap.builder().put((Object)"invalid-filter", (Object)group.getName()).build());
        }
    }

    @Test
    public void testCreatePlacementGroup() {
        String groupName = PREFIX + "1";
        for (String region : this.supportedRegions) {
            ((PlacementGroupApi)this.client.getPlacementGroupApi().get()).deletePlacementGroupInRegion(region, groupName);
            ((PlacementGroupApi)this.client.getPlacementGroupApi().get()).createPlacementGroupInRegion(region, groupName);
            this.verifyPlacementGroup(region, groupName);
        }
    }

    private void verifyPlacementGroup(String region, String groupName) {
        assert (this.availableTester.apply((Object)new PlacementGroup(region, groupName, "cluster", PlacementGroup.State.PENDING))) : this.group;
        Set oneResult = ((PlacementGroupApi)this.client.getPlacementGroupApi().get()).describePlacementGroupsInRegion(region, new String[]{groupName});
        Assert.assertNotNull((Object)oneResult);
        Assert.assertEquals((int)oneResult.size(), (int)1);
        this.group = (PlacementGroup)oneResult.iterator().next();
        Assert.assertEquals((String)this.group.getName(), (String)groupName);
        Assert.assertEquals((String)this.group.getStrategy(), (String)"cluster");
        assert (this.availableTester.apply((Object)this.group)) : this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartHS1Instance() throws Exception {
        Template template = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().fromHardware(EC2HardwareBuilder.hs1_8xlarge().build()).osFamily(OsFamily.AMZN_LINUX).build();
        assert (template != null) : "The returned template was null, but it should have a value.";
        Assert.assertEquals((String)template.getHardware().getProviderId(), (String)"hs1.8xlarge");
        Assert.assertEquals((String)((String)template.getImage().getUserMetadata().get("virtualizationType")), (String)"hvm");
        Assert.assertEquals((String)((String)template.getImage().getUserMetadata().get("hypervisor")), (String)"xen");
        template.getOptions().runScript(Statements.newStatementList((Statement[])new Statement[]{AdminAccess.standard(), InstallJDK.fromOpenJDK()}));
        String group = PREFIX + "cccluster";
        ((ComputeServiceContext)this.view).getComputeService().destroyNodesMatching(NodePredicates.inGroup((String)group));
        ((PlacementGroupApi)this.client.getPlacementGroupApi().get()).deletePlacementGroupInRegion(null, "jclouds#" + group + "#us-east-1");
        try {
            Set nodes = ((ComputeServiceContext)this.view).getComputeService().createNodesInGroup(group, 1, template);
            NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)nodes);
            Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)((AWSInstanceApi)this.client.getInstanceApi().get()).describeInstancesInRegion(null, new String[]{node.getProviderId()}))));
        }
        catch (RunNodesException e) {
            System.err.println(e.getNodeErrors().keySet());
            Throwables.propagate((Throwable)e);
        }
        finally {
            ((ComputeServiceContext)this.view).getComputeService().destroyNodesMatching(NodePredicates.inGroup((String)group));
        }
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDownContext() {
        if (this.group != null) {
            ((PlacementGroupApi)this.client.getPlacementGroupApi().get()).deletePlacementGroupInRegion(this.group.getRegion(), this.group.getName());
            assert (this.deletedTester.apply((Object)this.group)) : this.group;
        }
        super.tearDownContext();
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }
}

