/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import java.util.Map;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.aws.ec2.features.MonitoringApi;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class MonitoringApiLiveTest
extends BaseComputeServiceContextLiveTest {
    private MonitoringApi client;
    private static final String DEFAULT_INSTANCE = "i-TODO";

    public MonitoringApiLiveTest() {
        this.provider = "aws-ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.client = (MonitoringApi)((AWSEC2Api)((ComputeServiceContext)this.view).unwrapApi(AWSEC2Api.class)).getMonitoringApi().get();
    }

    @Test(enabled=false)
    public void testMonitorInstances() {
        Map monitoringState = this.client.monitorInstancesInRegion(null, DEFAULT_INSTANCE, new String[0]);
        Assert.assertEquals(monitoringState.get(DEFAULT_INSTANCE), (Object)MonitoringState.PENDING);
    }

    @Test(enabled=false)
    public void testUnmonitorInstances() {
        Map monitoringState = this.client.unmonitorInstancesInRegion(null, DEFAULT_INSTANCE, new String[0]);
        Assert.assertEquals(monitoringState.get(DEFAULT_INSTANCE), (Object)MonitoringState.PENDING);
    }
}

