/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.assertj.core.api.Assertions;
import org.jclouds.aws.ec2.AWSEC2ProviderMetadata;
import org.jclouds.aws.ec2.config.AWSEC2HttpApiModule;
import org.jclouds.aws.filters.FormSignerV4;
import org.jclouds.compute.domain.Image;
import org.jclouds.date.DateService;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.http.HttpRequest;
import org.jclouds.location.config.LocationModule;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.location.suppliers.RegionIdToZoneIdsSupplier;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.internal.BaseRestAnnotationProcessingTest;
import org.jclouds.util.Suppliers2;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public abstract class BaseAWSEC2ApiTest<T>
extends BaseRestAnnotationProcessingTest<T> {
    protected FormSignerV4 filter;
    protected String provider = "aws-ec2";

    protected void assertNonPayloadHeadersEqual(HttpRequest request, String toMatch) {
        LinkedHashMultimap headersToCheck = LinkedHashMultimap.create();
        for (String key : request.getHeaders().keySet()) {
            if (key.equals("X-Amz-Date")) {
                Assert.assertEquals((String)request.getFirstHeaderOrNull(key), (String)"20120416T155408Z");
                continue;
            }
            if (key.equals("Authorization")) {
                Assertions.assertThat((String)request.getFirstHeaderOrNull("Authorization")).startsWith((CharSequence)"AWS4-HMAC-SHA256 Credential=identity/20120416/us-east-1/ec2/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature=");
                continue;
            }
            headersToCheck.putAll((Object)key, (Iterable)request.getHeaders().get((Object)key));
        }
        Assert.assertEquals((String)BaseAWSEC2ApiTest.sortAndConcatHeadersIntoString((Multimap)headersToCheck), (String)toMatch);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertTrue((boolean)(request.getFilters().get(0) instanceof FormSignerV4));
    }

    @BeforeTest
    protected void setupFactory() throws IOException {
        super.setupFactory();
        this.filter = (FormSignerV4)this.injector.getInstance(FormSignerV4.class);
    }

    protected Module createModule() {
        return new StubAWSEC2HttpApiModule();
    }

    public AWSEC2ProviderMetadata createProviderMetadata() {
        return new AWSEC2ProviderMetadata();
    }

    @ConfiguresHttpApi
    protected static class StubAWSEC2HttpApiModule
    extends AWSEC2HttpApiModule {
        protected StubAWSEC2HttpApiModule() {
        }

        protected String provideTimeStamp(DateService dateService) {
            return "20120416T155408Z";
        }

        @Provides
        @Singleton
        LoadingCache<RegionAndName, Image> provide() {
            return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<RegionAndName, Image>(){

                public Image load(RegionAndName key) throws Exception {
                    return null;
                }
            });
        }

        protected void installLocations() {
            this.install((Module)new LocationModule());
            this.bind(RegionIdToURISupplier.class).toInstance((Object)new RegionIdToURISupplier(){

                public Map<String, Supplier<URI>> get() {
                    return Maps.transformValues((Map)ImmutableMap.of((Object)"eu-west-1", (Object)URI.create("https://ec2.eu-west-1.amazonaws.com"), (Object)"us-east-1", (Object)URI.create("https://ec2.us-east-1.amazonaws.com"), (Object)"us-west-1", (Object)URI.create("https://ec2.us-west-1.amazonaws.com")), (Function)Suppliers2.ofInstanceFunction());
                }
            });
            this.bind(RegionIdToZoneIdsSupplier.class).toInstance((Object)new RegionIdToZoneIdsSupplier(){

                public Map<String, Supplier<Set<String>>> get() {
                    return Maps.transformValues((Map)ImmutableMap.of((Object)"us-east-1", (Object)ImmutableSet.of((Object)"us-east-1a", (Object)"us-east-1b", (Object)"us-east-1c", (Object)"us-east-1b")), (Function)Suppliers2.ofInstanceFunction());
                }
            });
        }

        @Provides
        FormSignerV4.ServiceAndRegion ServiceAndRegion() {
            return new FormSignerV4.ServiceAndRegion(){

                public String service() {
                    return "ec2";
                }

                public String region(String host) {
                    return "us-east-1";
                }
            };
        }
    }
}

