/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.features.ElasticBlockStoreApiLiveTest;
import org.jclouds.ec2.options.CreateVolumeOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class AWSElasticBlockStoreApiLiveTest
extends ElasticBlockStoreApiLiveTest {
    public AWSElasticBlockStoreApiLiveTest() {
        this.provider = "aws-ec2";
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        overrides.put("jclouds.api-version", "2014-05-01");
        return overrides;
    }

    @Test
    void testCreateVolumeInAvailabilityZoneWithVolumeType() {
        Volume expected = this.client.createVolumeInAvailabilityZone(this.defaultZone, new CreateVolumeOptions[]{CreateVolumeOptions.Builder.volumeType((String)"gp2"), CreateVolumeOptions.Builder.withSize((int)1)});
        Assert.assertNotNull((Object)expected);
        Assert.assertEquals((String)expected.getAvailabilityZone(), (String)this.defaultZone);
        Assert.assertEquals((String)expected.getVolumeType(), (String)"gp2");
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)this.client.describeVolumesInRegion(this.defaultRegion, new String[]{expected.getId()}));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Volume volume = (Volume)result.iterator().next();
        Assert.assertEquals((String)volume.getId(), (String)expected.getId());
        Assert.assertEquals((String)volume.getVolumeType(), (String)expected.getVolumeType());
        this.client.deleteVolumeInRegion(volume.getRegion(), volume.getId());
    }
}

