/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.aws.ec2.options.AWSDescribeImagesOptions;
import org.jclouds.compute.RunNodesException;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.domain.Snapshot;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.features.AMIApiLiveTest;
import org.jclouds.ec2.features.ElasticBlockStoreApi;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.options.CreateSnapshotOptions;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.ec2.options.RegisterImageBackedByEbsOptions;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.ec2.predicates.SnapshotCompleted;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class AWSAMIApiLiveTest
extends AMIApiLiveTest {
    public AWSAMIApiLiveTest() {
        this.provider = "aws-ec2";
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        overrides.put("jclouds.api-version", "2014-05-01");
        return overrides;
    }

    public void testDescribeImagesCC() {
        Set ccResults = this.client.describeImagesInRegion("us-east-1", new DescribeImagesOptions[]{AWSDescribeImagesOptions.Builder.filters((Multimap)ImmutableMultimap.builder().put((Object)"virtualization-type", (Object)"hvm").put((Object)"architecture", (Object)"x86_64").putAll((Object)"owner-id", (Iterable)ImmutableSet.of((Object)"137112412989", (Object)"099720109477")).put((Object)"hypervisor", (Object)"xen").put((Object)"state", (Object)"available").put((Object)"image-type", (Object)"machine").put((Object)"root-device-type", (Object)"ebs").build()).ownedBy(new String[]{"137112412989", "099720109477"})});
        Assert.assertNotNull((Object)ccResults);
        assert (ccResults.size() >= 34) : ccResults;
    }

    protected RegisterImageBackedByEbsOptions newBlockDeviceOption() {
        return RegisterImageBackedByEbsOptions.Builder.addNewBlockDevice((String)"/dev/sda2", (String)"myvirtual", (int)5, (boolean)false, (String)"gp2", null, (boolean)false).withDescription("adrian");
    }

    protected Image.EbsBlockDevice newBlockDeviceInfo() {
        return new Image.EbsBlockDevice(null, 5L, false, "gp2", null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Snapshot createSnapshot() throws RunNodesException {
        Snapshot snapshot;
        block4: {
            String instanceId = null;
            try {
                BlockDeviceMapping.MapNewVolumeToDevice mapping = new BlockDeviceMapping.MapNewVolumeToDevice("/dev/sdb", Integer.valueOf(1), Boolean.valueOf(true), "gp2", null, Boolean.valueOf(false));
                RunInstancesOptions options = RunInstancesOptions.Builder.withBlockDeviceMappings((Set)ImmutableSet.of((Object)mapping));
                RunningInstance instance = (RunningInstance)Iterables.getOnlyElement((Iterable)Iterables.concat((Iterable[])new Iterable[]{((InstanceApi)this.ec2Api.getInstanceApi().get()).runInstancesInRegion(this.regionId, null, this.imageId, 1, 1, new RunInstancesOptions[]{options})}));
                instanceId = instance.getId();
                Assert.assertTrue((boolean)this.runningTester.apply((Object)instance), (String)(instanceId + "didn't achieve the state running!"));
                instance = (RunningInstance)Iterables.getOnlyElement((Iterable)Iterables.concat((Iterable)((InstanceApi)this.ec2Api.getInstanceApi().get()).describeInstancesInRegion(this.regionId, new String[]{instanceId})));
                BlockDevice gp2Device = (BlockDevice)instance.getEbsBlockDevices().get("/dev/sdb");
                Assert.assertNotNull((Object)gp2Device, (String)("device /dev/sdb not present on " + instance));
                Volume gp2Volume = (Volume)Iterables.getOnlyElement((Iterable)((ElasticBlockStoreApi)this.ec2Api.getElasticBlockStoreApi().get()).describeVolumesInRegion(this.regionId, new String[]{gp2Device.getVolumeId()}));
                Assert.assertNotNull((Object)gp2Volume, (String)"/dev/sdb volume is null");
                Assert.assertEquals((String)gp2Volume.getVolumeType(), (String)"gp2");
                BlockDevice device = (BlockDevice)instance.getEbsBlockDevices().get("/dev/sda1");
                Assert.assertNotNull((Object)device, (String)("device: /dev/sda1 not present on: " + instance));
                Snapshot snapshot2 = ((ElasticBlockStoreApi)this.ec2Api.getElasticBlockStoreApi().get()).createSnapshotInRegion(this.regionId, device.getVolumeId(), new CreateSnapshotOptions[0]);
                this.snapshotsToDelete.add(snapshot2.getId());
                Predicate snapshotted = Predicates2.retry((Predicate)new SnapshotCompleted((ElasticBlockStoreApi)this.ec2Api.getElasticBlockStoreApi().get()), (long)600L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
                assert (snapshotted.apply((Object)snapshot2));
                snapshot = snapshot2;
                if (instanceId == null) break block4;
            }
            catch (Throwable throwable) {
                if (instanceId != null) {
                    ((InstanceApi)this.ec2Api.getInstanceApi().get()).terminateInstancesInRegion(this.regionId, new String[]{instanceId});
                }
                throw throwable;
            }
            ((InstanceApi)this.ec2Api.getInstanceApi().get()).terminateInstancesInRegion(this.regionId, new String[]{instanceId});
        }
        return snapshot;
    }
}

