/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Provider;
import org.easymock.EasyMock;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.aws.ec2.compute.strategy.CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.ec2.domain.RegionNameAndPublicKeyMaterial;
import org.jclouds.aws.ec2.functions.CreatePlacementGroupIfNeeded;
import org.jclouds.aws.ec2.options.AWSRunInstancesOptions;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.domain.EC2HardwareBuilder;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.compute.strategy.CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.ec2.compute.strategy.CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptionsTest;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.scriptbuilder.domain.Statements;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptionsTest")
public class CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptionsTest {
    private static final Provider<RunInstancesOptions> OPTIONS_PROVIDER = new Provider<RunInstancesOptions>(){

        public RunInstancesOptions get() {
            return new AWSRunInstancesOptions();
        }
    };

    @Test(enabled=false)
    public void testExecuteWithDefaultOptionsEC2() throws SecurityException, NoSuchMethodException {
        String region = "ap-southeast-1";
        String group = "group";
        Hardware size = EC2HardwareBuilder.m1_small().build();
        String systemGeneratedKeyPairName = "systemGeneratedKeyPair";
        String generatedGroup = "group";
        ImmutableSet generatedGroups = ImmutableSet.of((Object)generatedGroup);
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = (CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions)EasyMock.createMock(CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions.class, (Method[])new Method[]{CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getOptionsProvider", new Class[0]), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("createNewKeyPairUnlessUserSpecifiedOtherwise", String.class, String.class, TemplateOptions.class), CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("createNewPlacementGroupUnlessUserSpecifiedOtherwise", String.class, String.class, TemplateOptions.class), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getSecurityGroupsForTagAndOptions", String.class, String.class, String.class, TemplateOptions.class)});
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)strategy.getOptionsProvider()).andReturn(OPTIONS_PROVIDER);
        EasyMock.expect((Object)template.getHardware()).andReturn((Object)size).atLeastOnce();
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)options).atLeastOnce();
        EasyMock.expect((Object)options.getBlockDeviceMappings()).andReturn((Object)ImmutableSet.of()).atLeastOnce();
        EasyMock.expect((Object)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options)).andReturn((Object)systemGeneratedKeyPairName);
        EasyMock.expect((Object)strategy.getSecurityGroupsForTagAndOptions(region, group, null, (TemplateOptions)options)).andReturn((Object)generatedGroups);
        EasyMock.expect((Object)options.getGroupIds()).andReturn((Object)ImmutableSet.of());
        EasyMock.expect((Object)options.getSubnetId()).andReturn(null);
        EasyMock.expect((Object)options.getUserData()).andReturn(null);
        EasyMock.expect((Object)options.isMonitoringEnabled()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{template});
        EasyMock.replay((Object[])new Object[]{strategy});
        AWSRunInstancesOptions customize = strategy.execute(region, group, template);
        Assert.assertEquals((Object)customize.buildQueryParameters(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((Collection)customize.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"InstanceType", (Object)size.getProviderId(), (Object)"SecurityGroup.1", (Object)generatedGroup, (Object)"KeyName", (Object)systemGeneratedKeyPairName).entries());
        Assert.assertEquals((Object)customize.buildRequestHeaders(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((String)customize.buildStringPayload(), null);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{strategy});
    }

    @Test(enabled=false)
    public void testExecuteForCCAutomatic() throws SecurityException, NoSuchMethodException {
        String region = "us-east-1";
        String group = "group";
        Hardware size = EC2HardwareBuilder.cc1_4xlarge().build();
        String systemGeneratedKeyPairName = "systemGeneratedKeyPair";
        String generatedGroup = "group";
        ImmutableSet generatedGroups = ImmutableSet.of((Object)generatedGroup);
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = (CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions)EasyMock.createMock(CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions.class, (Method[])new Method[]{CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getOptionsProvider", new Class[0]), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("createNewKeyPairUnlessUserSpecifiedOtherwise", String.class, String.class, TemplateOptions.class), CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("createNewPlacementGroupUnlessUserSpecifiedOtherwise", String.class, String.class, TemplateOptions.class), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getSecurityGroupsForTagAndOptions", String.class, String.class, String.class, TemplateOptions.class)});
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)strategy.getOptionsProvider()).andReturn(OPTIONS_PROVIDER);
        EasyMock.expect((Object)template.getHardware()).andReturn((Object)size).atLeastOnce();
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)options).atLeastOnce();
        EasyMock.expect((Object)options.getBlockDeviceMappings()).andReturn((Object)ImmutableSet.of()).atLeastOnce();
        EasyMock.expect((Object)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options)).andReturn((Object)systemGeneratedKeyPairName);
        EasyMock.expect((Object)strategy.createNewPlacementGroupUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options)).andReturn((Object)generatedGroup);
        EasyMock.expect((Object)strategy.getSecurityGroupsForTagAndOptions(region, group, null, (TemplateOptions)options)).andReturn((Object)generatedGroups);
        EasyMock.expect((Object)options.getGroupIds()).andReturn((Object)ImmutableSet.of());
        EasyMock.expect((Object)options.getSubnetId()).andReturn(null);
        EasyMock.expect((Object)options.getUserData()).andReturn(null);
        EasyMock.expect((Object)options.isMonitoringEnabled()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{template});
        EasyMock.replay((Object[])new Object[]{strategy});
        AWSRunInstancesOptions customize = strategy.execute(region, group, template);
        Assert.assertEquals((Object)customize.buildQueryParameters(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((Collection)customize.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"InstanceType", (Object)size.getProviderId(), (Object)"SecurityGroup.1", (Object)generatedGroup, (Object)"KeyName", (Object)systemGeneratedKeyPairName, (Object)"Placement.GroupName", (Object)generatedGroup).entries());
        Assert.assertEquals((Object)customize.buildRequestHeaders(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((String)customize.buildStringPayload(), null);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{strategy});
    }

    @Test(enabled=false)
    public void testExecuteForCCUserSpecified() throws SecurityException, NoSuchMethodException {
        String region = "us-east-1";
        String group = "group";
        Hardware size = EC2HardwareBuilder.cc1_4xlarge().build();
        String systemGeneratedKeyPairName = "systemGeneratedKeyPair";
        String generatedGroup = "group";
        ImmutableSet generatedGroups = ImmutableSet.of((Object)generatedGroup);
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = (CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions)EasyMock.createMock(CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions.class, (Method[])new Method[]{CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getOptionsProvider", new Class[0]), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("createNewKeyPairUnlessUserSpecifiedOtherwise", String.class, String.class, TemplateOptions.class), CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("createNewPlacementGroupUnlessUserSpecifiedOtherwise", String.class, String.class, TemplateOptions.class), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getSecurityGroupsForTagAndOptions", String.class, String.class, String.class, TemplateOptions.class)});
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)strategy.getOptionsProvider()).andReturn(OPTIONS_PROVIDER);
        EasyMock.expect((Object)template.getHardware()).andReturn((Object)size).atLeastOnce();
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)options).atLeastOnce();
        EasyMock.expect((Object)options.getBlockDeviceMappings()).andReturn((Object)ImmutableSet.of()).atLeastOnce();
        EasyMock.expect((Object)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options)).andReturn((Object)systemGeneratedKeyPairName);
        EasyMock.expect((Object)strategy.createNewPlacementGroupUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options)).andReturn((Object)generatedGroup);
        EasyMock.expect((Object)strategy.getSecurityGroupsForTagAndOptions(region, group, null, (TemplateOptions)options)).andReturn((Object)generatedGroups);
        EasyMock.expect((Object)options.getGroupIds()).andReturn((Object)ImmutableSet.of());
        EasyMock.expect((Object)options.getSubnetId()).andReturn(null);
        EasyMock.expect((Object)options.getUserData()).andReturn(null);
        EasyMock.expect((Object)options.isMonitoringEnabled()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{template});
        EasyMock.replay((Object[])new Object[]{strategy});
        AWSRunInstancesOptions customize = strategy.execute(region, group, template);
        Assert.assertEquals((Object)customize.buildQueryParameters(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((Collection)customize.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"InstanceType", (Object)size.getProviderId(), (Object)"SecurityGroup.1", (Object)generatedGroup, (Object)"KeyName", (Object)systemGeneratedKeyPairName, (Object)"Placement.GroupName", (Object)generatedGroup).entries());
        Assert.assertEquals((Object)customize.buildRequestHeaders(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((String)customize.buildStringPayload(), null);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{strategy});
    }

    @Test(enabled=false)
    public void testExecuteWithSubnet() throws SecurityException, NoSuchMethodException {
        String region = "ap-southeast-1";
        String group = "group";
        Hardware size = EC2HardwareBuilder.m1_small().build();
        String systemGeneratedKeyPairName = "systemGeneratedKeyPair";
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = (CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions)EasyMock.createMock(CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions.class, (Method[])new Method[]{CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getOptionsProvider", new Class[0]), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("createNewKeyPairUnlessUserSpecifiedOtherwise", String.class, String.class, TemplateOptions.class), CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("createNewPlacementGroupUnlessUserSpecifiedOtherwise", String.class, String.class, TemplateOptions.class), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getSecurityGroupsForTagAndOptions", String.class, String.class, String.class, TemplateOptions.class), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("vpcIdForSubnet", String.class)});
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)strategy.getOptionsProvider()).andReturn(OPTIONS_PROVIDER);
        EasyMock.expect((Object)template.getHardware()).andReturn((Object)size).atLeastOnce();
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)options).atLeastOnce();
        EasyMock.expect((Object)options.getBlockDeviceMappings()).andReturn((Object)ImmutableSet.of()).atLeastOnce();
        EasyMock.expect((Object)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options)).andReturn((Object)systemGeneratedKeyPairName);
        EasyMock.expect((Object)options.getGroupIds()).andReturn((Object)ImmutableSet.of());
        EasyMock.expect((Object)options.getSubnetId()).andReturn((Object)"1");
        EasyMock.expect((Object)options.getUserData()).andReturn(null);
        EasyMock.expect((Object)options.isMonitoringEnabled()).andReturn((Object)false);
        EasyMock.expect((Object)strategy.vpcIdForSubnet("1")).andReturn((Object)"vpc1");
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{template});
        EasyMock.replay((Object[])new Object[]{strategy});
        AWSRunInstancesOptions customize = strategy.execute(region, group, template);
        Assert.assertEquals((Object)customize.buildQueryParameters(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((Collection)customize.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"InstanceType", (Object)size.getProviderId(), (Object)"SubnetId", (Object)"1", (Object)"KeyName", (Object)systemGeneratedKeyPairName).entries());
        Assert.assertEquals((Object)customize.buildRequestHeaders(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((String)customize.buildStringPayload(), null);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{strategy});
    }

    @Test(enabled=false)
    public void testExecuteWithUserData() throws SecurityException, NoSuchMethodException {
        String region = "ap-southeast-1";
        String group = "group";
        Hardware size = EC2HardwareBuilder.m1_small().build();
        String systemGeneratedKeyPairName = "systemGeneratedKeyPair";
        String generatedGroup = "group";
        ImmutableSet generatedGroups = ImmutableSet.of((Object)generatedGroup);
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = (CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions)EasyMock.createMock(CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions.class, (Method[])new Method[]{CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getOptionsProvider", new Class[0]), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("createNewKeyPairUnlessUserSpecifiedOtherwise", String.class, String.class, TemplateOptions.class), CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("createNewPlacementGroupUnlessUserSpecifiedOtherwise", String.class, String.class, TemplateOptions.class), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getSecurityGroupsForTagAndOptions", String.class, String.class, String.class, TemplateOptions.class)});
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)strategy.getOptionsProvider()).andReturn(OPTIONS_PROVIDER);
        EasyMock.expect((Object)template.getHardware()).andReturn((Object)size).atLeastOnce();
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)options).atLeastOnce();
        EasyMock.expect((Object)options.getBlockDeviceMappings()).andReturn((Object)ImmutableSet.of()).atLeastOnce();
        EasyMock.expect((Object)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options)).andReturn((Object)systemGeneratedKeyPairName);
        EasyMock.expect((Object)strategy.getSecurityGroupsForTagAndOptions(region, group, null, (TemplateOptions)options)).andReturn((Object)generatedGroups);
        EasyMock.expect((Object)options.getGroupIds()).andReturn((Object)ImmutableSet.of());
        EasyMock.expect((Object)options.getSubnetId()).andReturn(null);
        EasyMock.expect((Object)options.getUserData()).andReturn((Object)"hello".getBytes());
        EasyMock.expect((Object)options.isMonitoringEnabled()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{template});
        EasyMock.replay((Object[])new Object[]{strategy});
        AWSRunInstancesOptions customize = strategy.execute(region, group, template);
        Assert.assertEquals((Object)customize.buildQueryParameters(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((Collection)customize.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"InstanceType", (Object)size.getProviderId(), (Object)"SecurityGroup.1", (Object)"group", (Object)"KeyName", (Object)systemGeneratedKeyPairName, (Object)"UserData", (Object)BaseEncoding.base64().encode("hello".getBytes(Charsets.UTF_8))).entries());
        Assert.assertEquals((Object)customize.buildRequestHeaders(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((String)customize.buildStringPayload(), null);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{strategy});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_reusesKeyWhenToldToWithRunScriptButNoCredentials() {
        String region = "ap-southeast-1";
        String group = "group";
        String userSuppliedKeyPair = "myKeyPair";
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)options.getKeyPair()).andReturn((Object)userSuppliedKeyPair);
        EasyMock.expect((Object)options.getPublicKey()).andReturn(null).times(2);
        EasyMock.expect((Object)options.getLoginPrivateKey()).andReturn(null);
        EasyMock.expect((Object)options.getRunScript()).andReturn((Object)Statements.exec((String)"echo foo"));
        EasyMock.expect((Object)strategy.credentialsMap.containsKey(new RegionAndName(region, userSuppliedKeyPair))).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)userSuppliedKeyPair);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_reusesKeyWhenToldToWithRunScriptAndCredentialsAlreadyInMap() {
        String region = "ap-southeast-1";
        String group = "group";
        String userSuppliedKeyPair = "myKeyPair";
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)options.getPublicKey()).andReturn(null).times(2);
        EasyMock.expect((Object)options.getKeyPair()).andReturn((Object)userSuppliedKeyPair);
        EasyMock.expect((Object)options.getLoginPrivateKey()).andReturn(null);
        EasyMock.expect((Object)options.getRunScript()).andReturn((Object)Statements.exec((String)"echo foo"));
        EasyMock.expect((Object)strategy.credentialsMap.containsKey(new RegionAndName(region, userSuppliedKeyPair))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)userSuppliedKeyPair);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_ImportPublicKeyWhenOptionIsSet() {
        String region = "ap-southeast-1";
        String group = "group";
        String userSuppliedKeyPair = "myKeyPair";
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)options.getPublicKey()).andReturn((Object)"ssh-rsa").times(2);
        EasyMock.expect((Object)options.getLoginPrivateKey()).andReturn(CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptionsTest.CREDENTIALS.getOptionalPrivateKey().get()).atLeastOnce();
        EasyMock.expect((Object)strategy.importExistingKeyPair.apply((Object)new RegionNameAndPublicKeyMaterial(region, group, "ssh-rsa"))).andReturn((Object)CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptionsTest.KEYPAIR);
        EasyMock.expect((Object)options.dontAuthorizePublicKey()).andReturn((Object)options);
        EasyMock.expect((Object)strategy.credentialsMap.put(new RegionAndName(region, group), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptionsTest.KEYPAIR)).andReturn(null);
        EasyMock.expect((Object)options.getRunScript()).andReturn((Object)Statements.exec((String)"echo foo"));
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)userSuppliedKeyPair);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    @Test
    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_importsKeyPairAndUnsetsTemplateInstructionWhenPublicKeySuppliedAndAddsCredentialToMapWhenOverridingCredsAreSet() {
        String region = "ap-southeast-1";
        String group = "group";
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.keyPair((String)group).authorizePublicKey("ssh-rsa").overrideLoginCredentials(LoginCredentials.builder().user("foo").privateKey(CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptionsTest.CREDENTIALS.credential).build());
        KeyPair keyPair = new KeyPair(region, group, "//TODO", null, null);
        EasyMock.expect((Object)strategy.importExistingKeyPair.apply((Object)new RegionNameAndPublicKeyMaterial(region, group, CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptionsTest.CREDENTIALS.credential))).andReturn((Object)keyPair);
        EasyMock.expect((Object)strategy.credentialsMap.put(new RegionAndName(region, group), keyPair.toBuilder().keyMaterial(CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptionsTest.CREDENTIALS.credential).build())).andReturn(null);
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)group);
        this.verifyStrategy(strategy);
    }

    @Test
    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_importsKeyPairAndUnsetsTemplateInstructionWhenPublicKeySupplied() {
        String region = "ap-southeast-1";
        String group = "group";
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.keyPair((String)group).authorizePublicKey("ssh-rsa");
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        KeyPair keyPair = new KeyPair(region, "jclouds#" + group, "fingerprint", null, null);
        EasyMock.expect((Object)strategy.importExistingKeyPair.apply((Object)new RegionNameAndPublicKeyMaterial(region, group, "ssh-rsa"))).andReturn((Object)keyPair);
        EasyMock.expect((Object)strategy.credentialsMap.put(new RegionAndName(region, group), keyPair)).andReturn(null);
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)("jclouds#" + group));
        this.verifyStrategy(strategy);
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_createsNewKeyPairAndReturnsItsNameWhenNoPublicKeySupplied() {
        String region = "ap-southeast-1";
        String group = "group";
        Object userSuppliedKeyPair = null;
        boolean shouldAutomaticallyCreateKeyPair = true;
        String systemGeneratedKeyPairName = "systemGeneratedKeyPair";
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)options.getKeyPair()).andReturn(userSuppliedKeyPair);
        EasyMock.expect((Object)options.shouldAutomaticallyCreateKeyPair()).andReturn((Object)shouldAutomaticallyCreateKeyPair);
        EasyMock.expect((Object)strategy.credentialsMap.putIfAbsent(EasyMock.anyObject(RegionAndName.class), EasyMock.anyObject(KeyPair.class))).andReturn((Object)keyPair);
        EasyMock.expect((Object)options.getPublicKey()).andReturn(null).times(2);
        EasyMock.expect((Object)keyPair.getKeyName()).andReturn((Object)systemGeneratedKeyPairName).atLeastOnce();
        EasyMock.expect((Object)options.getRunScript()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)systemGeneratedKeyPairName);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_returnsExistingKeyIfAlreadyPresent() {
        String region = "ap-southeast-1";
        String group = "group";
        String systemGeneratedKeyPairName = "systemGeneratedKeyPair";
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)options.getLoginPrivateKey()).andReturn(null);
        EasyMock.expect((Object)options.getRunScript()).andReturn((Object)Statements.exec((String)"echo hello"));
        EasyMock.expect((Object)options.getPublicKey()).andReturn(null).times(2);
        EasyMock.expect((Object)options.getKeyPair()).andReturn((Object)systemGeneratedKeyPairName);
        EasyMock.expect((Object)strategy.credentialsMap.containsKey(new RegionAndName(region, systemGeneratedKeyPairName))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)systemGeneratedKeyPairName);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_doesntCreateAKeyPairAndReturnsNullWhenToldNotTo() {
        String region = "ap-southeast-1";
        String group = "group";
        Object userSuppliedKeyPair = null;
        boolean shouldAutomaticallyCreateKeyPair = false;
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)options.getPublicKey()).andReturn(null).times(2);
        EasyMock.expect((Object)options.getKeyPair()).andReturn(userSuppliedKeyPair);
        EasyMock.expect((Object)options.getRunScript()).andReturn(null);
        EasyMock.expect((Object)options.shouldAutomaticallyCreateKeyPair()).andReturn((Object)shouldAutomaticallyCreateKeyPair);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), null);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testGetSecurityGroupsForTagAndOptions_createsNewGroupByDefaultWhenNoPortsAreSpecifiedWhenDoesntExist() {
        String region = "ap-southeast-1";
        String group = "group";
        String generatedMarkerGroup = "jclouds#group";
        ImmutableSet groupNames = ImmutableSet.of();
        int[] ports = new int[]{};
        boolean shouldAuthorizeSelf = true;
        ImmutableSet returnVal = ImmutableSet.of((Object)"sg-12345");
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        EasyMock.expect((Object)options.getGroupIds()).andReturn((Object)ImmutableSet.of());
        EasyMock.expect((Object)options.getGroups()).andReturn((Object)groupNames).atLeastOnce();
        EasyMock.expect((Object)options.getInboundPorts()).andReturn((Object)ports).atLeastOnce();
        RegionNameAndIngressRules regionNameAndIngressRules = new RegionNameAndIngressRules(region, generatedMarkerGroup, ports, shouldAuthorizeSelf, null);
        EasyMock.expect((Object)strategy.securityGroupMap.getUnchecked((Object)regionNameAndIngressRules)).andReturn((Object)"sg-12345");
        EasyMock.replay((Object[])new Object[]{options});
        this.replayStrategy(strategy);
        Assert.assertEquals((Set)strategy.getSecurityGroupsForTagAndOptions(region, group, null, (TemplateOptions)options), (Set)returnVal);
        EasyMock.verify((Object[])new Object[]{options});
        this.verifyStrategy(strategy);
    }

    public void testGetSecurityGroupsForTagAndOptions_createsNewGroupByDefaultWhenPortsAreSpecifiedWhenDoesntExist() {
        String region = "ap-southeast-1";
        String group = "group";
        String generatedMarkerGroup = "jclouds#group";
        ImmutableSet groupNames = ImmutableSet.of();
        int[] ports = new int[]{22, 80};
        boolean shouldAuthorizeSelf = true;
        ImmutableSet returnVal = ImmutableSet.of((Object)"sg-12345");
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        EasyMock.expect((Object)options.getGroupIds()).andReturn((Object)ImmutableSet.of());
        EasyMock.expect((Object)options.getGroups()).andReturn((Object)groupNames).atLeastOnce();
        EasyMock.expect((Object)options.getInboundPorts()).andReturn((Object)ports).atLeastOnce();
        RegionNameAndIngressRules regionNameAndIngressRules = new RegionNameAndIngressRules(region, generatedMarkerGroup, ports, shouldAuthorizeSelf, null);
        EasyMock.expect((Object)strategy.securityGroupMap.getUnchecked((Object)regionNameAndIngressRules)).andReturn((Object)"sg-12345");
        EasyMock.replay((Object[])new Object[]{options});
        this.replayStrategy(strategy);
        Assert.assertEquals((Set)strategy.getSecurityGroupsForTagAndOptions(region, group, null, (TemplateOptions)options), (Set)returnVal);
        EasyMock.verify((Object[])new Object[]{options});
        this.verifyStrategy(strategy);
    }

    public void testGetSecurityGroupsForTagAndOptions_reusesGroupByDefaultWhenNoPortsAreSpecifiedWhenDoesExist() {
        String region = "ap-southeast-1";
        String group = "group";
        String generatedMarkerGroup = "jclouds#group";
        ImmutableSet groupNames = ImmutableSet.of();
        int[] ports = new int[]{};
        boolean shouldAuthorizeSelf = true;
        ImmutableSet returnVal = ImmutableSet.of((Object)"sg-12345");
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        EasyMock.expect((Object)options.getGroupIds()).andReturn((Object)ImmutableSet.of());
        EasyMock.expect((Object)options.getGroups()).andReturn((Object)groupNames).atLeastOnce();
        EasyMock.expect((Object)options.getInboundPorts()).andReturn((Object)ports).atLeastOnce();
        RegionNameAndIngressRules regionNameAndIngressRules = new RegionNameAndIngressRules(region, generatedMarkerGroup, ports, shouldAuthorizeSelf, null);
        EasyMock.expect((Object)strategy.securityGroupMap.getUnchecked((Object)regionNameAndIngressRules)).andReturn((Object)"sg-12345");
        EasyMock.replay((Object[])new Object[]{options});
        this.replayStrategy(strategy);
        Assert.assertEquals((Set)strategy.getSecurityGroupsForTagAndOptions(region, group, null, (TemplateOptions)options), (Set)returnVal);
        EasyMock.verify((Object[])new Object[]{options});
        this.verifyStrategy(strategy);
    }

    public void testGetSecurityGroupsForTagAndOptions_DoesNotReuseGroupByDefaultWhenNoPortsAreSpecifiedWhenDoesExistAndAcceptsUserSuppliedGroups() {
        String region = "ap-southeast-1";
        String group = "group";
        ImmutableSet groupNames = ImmutableSet.of((Object)"group1", (Object)"group2");
        ImmutableSet returnVal = ImmutableSet.of((Object)"group1", (Object)"group2");
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        EasyMock.expect((Object)options.getGroupIds()).andReturn((Object)ImmutableSet.of());
        EasyMock.expect((Object)options.getGroups()).andReturn((Object)groupNames).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{options});
        this.replayStrategy(strategy);
        Assert.assertEquals((Set)strategy.getSecurityGroupsForTagAndOptions(region, group, null, (TemplateOptions)options), (Set)returnVal);
        EasyMock.verify((Object[])new Object[]{options});
        this.verifyStrategy(strategy);
    }

    public void testGetSecurityGroupsForTagAndOptions_DoesNotReuseGroupByDefaultWhenNoPortsAreSpecifiedWhenDoesExistAndAcceptsUserSuppliedGroupIds() {
        String region = "ap-southeast-1";
        String group = "group";
        ImmutableSet groupNames = ImmutableSet.of();
        ImmutableSet returnVal = ImmutableSet.of();
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        EasyMock.expect((Object)options.getGroupIds()).andReturn((Object)ImmutableSet.of((Object)"group1", (Object)"group2"));
        EasyMock.expect((Object)options.getGroups()).andReturn((Object)groupNames).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{options});
        this.replayStrategy(strategy);
        Assert.assertEquals((Set)strategy.getSecurityGroupsForTagAndOptions(region, group, null, (TemplateOptions)options), (Set)returnVal);
        EasyMock.verify((Object[])new Object[]{options});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewPlacementGroupUnlessUserSpecifiedOtherwise_reusesKeyWhenToldTo() {
        String region = "ap-southeast-1";
        String group = "group";
        String userSuppliedPlacementGroup = "myPlacementGroup";
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        PlacementGroup placementGroup = (PlacementGroup)EasyMock.createMock(PlacementGroup.class);
        EasyMock.expect((Object)options.getPlacementGroup()).andReturn((Object)userSuppliedPlacementGroup);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{placementGroup});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewPlacementGroupUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)userSuppliedPlacementGroup);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{placementGroup});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewPlacementGroupUnlessUserSpecifiedOtherwise_createsNewPlacementGroupAndReturnsItsNameByDefault() {
        String region = "ap-southeast-1";
        String group = "group";
        Object userSuppliedPlacementGroup = null;
        boolean shouldAutomaticallyCreatePlacementGroup = true;
        String generatedMarkerGroup = "jclouds#group#ap-southeast-1";
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        EasyMock.expect((Object)options.getPlacementGroup()).andReturn(userSuppliedPlacementGroup);
        EasyMock.expect((Object)options.shouldAutomaticallyCreatePlacementGroup()).andReturn((Object)shouldAutomaticallyCreatePlacementGroup);
        EasyMock.expect((Object)strategy.placementGroupMap.getUnchecked((Object)new RegionAndName(region, generatedMarkerGroup))).andReturn((Object)generatedMarkerGroup);
        EasyMock.replay((Object[])new Object[]{options});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewPlacementGroupUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)generatedMarkerGroup);
        EasyMock.verify((Object[])new Object[]{options});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewPlacementGroupUnlessUserSpecifiedOtherwise_doesntCreateAPlacementGroupAndReturnsNullWhenToldNotTo() {
        String region = "ap-southeast-1";
        String group = "group";
        Object userSuppliedPlacementGroup = null;
        boolean shouldAutomaticallyCreatePlacementGroup = false;
        CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)EasyMock.createMock(AWSEC2TemplateOptions.class);
        PlacementGroup placementGroup = (PlacementGroup)EasyMock.createMock(PlacementGroup.class);
        EasyMock.expect((Object)options.getPlacementGroup()).andReturn(userSuppliedPlacementGroup);
        EasyMock.expect((Object)options.shouldAutomaticallyCreatePlacementGroup()).andReturn((Object)shouldAutomaticallyCreatePlacementGroup);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{placementGroup});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewPlacementGroupUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), null);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{placementGroup});
        this.verifyStrategy(strategy);
    }

    private void verifyStrategy(CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy) {
        EasyMock.verify((Object[])new Object[]{strategy.makeKeyPair});
        EasyMock.verify((Object[])new Object[]{strategy.credentialsMap});
        EasyMock.verify((Object[])new Object[]{strategy.securityGroupMap});
        EasyMock.verify((Object[])new Object[]{strategy.placementGroupMap});
        EasyMock.verify((Object[])new Object[]{strategy.importExistingKeyPair});
        EasyMock.verify((Object[])new Object[]{strategy.createPlacementGroupIfNeeded});
    }

    private CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions setupStrategy() {
        Function makeKeyPair = (Function)EasyMock.createMock(Function.class);
        ConcurrentMap credentialsMap = (ConcurrentMap)EasyMock.createMock(ConcurrentMap.class);
        LoadingCache securityGroupMap = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        LoadingCache placementGroupMap = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        Function importExistingKeyPair = (Function)EasyMock.createMock(Function.class);
        CreatePlacementGroupIfNeeded createPlacementGroupIfNeeded = (CreatePlacementGroupIfNeeded)EasyMock.createMock(CreatePlacementGroupIfNeeded.class);
        GroupNamingConvention.Factory namingConventionFactory = (GroupNamingConvention.Factory)EasyMock.createMock(GroupNamingConvention.Factory.class);
        GroupNamingConvention namingConvention = (GroupNamingConvention)EasyMock.createMock(GroupNamingConvention.class);
        AWSEC2Api api = (AWSEC2Api)EasyMock.createMock(AWSEC2Api.class);
        EasyMock.expect((Object)namingConventionFactory.create()).andReturn((Object)namingConvention).anyTimes();
        EasyMock.expect((Object)namingConvention.sharedNameForGroup("group")).andReturn((Object)"jclouds#group").anyTimes();
        EasyMock.expect((Object)makeKeyPair.apply(EasyMock.anyObject(RegionAndName.class))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{namingConventionFactory});
        EasyMock.replay((Object[])new Object[]{namingConvention});
        return new CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions(makeKeyPair, credentialsMap, securityGroupMap, OPTIONS_PROVIDER, placementGroupMap, createPlacementGroupIfNeeded, importExistingKeyPair, namingConventionFactory, api);
    }

    private void replayStrategy(CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions strategy) {
        EasyMock.replay((Object[])new Object[]{strategy.makeKeyPair});
        EasyMock.replay((Object[])new Object[]{strategy.credentialsMap});
        EasyMock.replay((Object[])new Object[]{strategy.securityGroupMap});
        EasyMock.replay((Object[])new Object[]{strategy.placementGroupMap});
        EasyMock.replay((Object[])new Object[]{strategy.importExistingKeyPair});
        EasyMock.replay((Object[])new Object[]{strategy.createPlacementGroupIfNeeded});
    }
}

