/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Map;
import org.jclouds.aws.ec2.compute.strategy.AWSEC2ReviseParsedImage;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.VirtualizationType;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AWSEC2ReviseParsedImageTest {
    private Map<OsFamily, Map<String, String>> osVersionMap;

    @BeforeClass
    public void testFixtureSetUp() {
        this.osVersionMap = new BaseComputeServiceContextModule(){}.provideOsVersionMap(new ComputeServiceConstants.ReferenceData(), (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class));
    }

    @Test
    public void testNewWindowsName() throws Exception {
        AWSEC2ReviseParsedImage rpi = new AWSEC2ReviseParsedImage(this.osVersionMap);
        Image from = AWSEC2ReviseParsedImageTest.newImage("amazon", "Windows_Server-2008-R2_SP1-English-64Bit-Base-2012.03.13");
        OperatingSystem.Builder osBuilder = OperatingSystem.builder().description("test");
        ImageBuilder builder = new ImageBuilder().id("1").operatingSystem(osBuilder.build()).status(Image.Status.AVAILABLE).description("test");
        OsFamily family = OsFamily.WINDOWS;
        rpi.reviseParsedImage(from, builder, family, osBuilder);
        OperatingSystem os = osBuilder.build();
        Assert.assertEquals((Object)os.getFamily(), (Object)OsFamily.WINDOWS);
        Assert.assertEquals((String)os.getVersion(), (String)"2008");
        Assert.assertEquals((String)builder.build().getVersion(), (String)"2012.03.13");
    }

    @Test
    public void testOldWindowsName() throws Exception {
        AWSEC2ReviseParsedImage rpi = new AWSEC2ReviseParsedImage(this.osVersionMap);
        Image from = AWSEC2ReviseParsedImageTest.newImage("amazon", "Windows-2008R2-SP1-English-Base-2012.01.12");
        OperatingSystem.Builder osBuilder = OperatingSystem.builder().description("test");
        ImageBuilder builder = new ImageBuilder().id("1").operatingSystem(osBuilder.build()).status(Image.Status.AVAILABLE).description("test");
        OsFamily family = OsFamily.WINDOWS;
        rpi.reviseParsedImage(from, builder, family, osBuilder);
        OperatingSystem os = osBuilder.build();
        Assert.assertEquals((Object)os.getFamily(), (Object)OsFamily.WINDOWS);
        Assert.assertEquals((String)os.getVersion(), (String)"2008");
        Assert.assertEquals((String)builder.build().getVersion(), (String)"2012.01.12");
    }

    private static Image newImage(String imageOwnerId, String imageName) {
        String region = "us-east-1";
        Image.Architecture architecture = Image.Architecture.X86_64;
        String description = "";
        String imageId = "";
        Image.ImageState imageState = Image.ImageState.AVAILABLE;
        Image.ImageType imageType = Image.ImageType.MACHINE;
        boolean isPublic = true;
        ImmutableSet productCodes = ImmutableSet.of();
        String kernelId = "";
        String platform = "";
        String ramdiskId = "";
        RootDeviceType rootDeviceType = RootDeviceType.EBS;
        String rootDeviceName = "";
        ImmutableMap ebsBlockDevices = ImmutableMap.of();
        ImmutableMap tags = ImmutableMap.of();
        VirtualizationType virtualizationType = VirtualizationType.HVM;
        Hypervisor hypervisor = Hypervisor.XEN;
        Image from = new Image(region, architecture, imageName, description, imageId, imageOwnerId + "/" + imageName, imageOwnerId, imageState, "available", imageType, isPublic, (Iterable)productCodes, kernelId, platform, ramdiskId, rootDeviceType, rootDeviceName, (Map)ebsBlockDevices, (Map)tags, virtualizationType, hypervisor);
        return from;
    }
}

