/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.loaders;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.easymock.EasyMock;
import org.jclouds.aws.ec2.compute.loaders.AWSEC2CreateSecurityGroupIfNeeded;
import org.jclouds.aws.ec2.features.AWSSecurityGroupApi;
import org.jclouds.aws.ec2.options.CreateSecurityGroupOptions;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.compute.functions.EC2SecurityGroupIdFromName;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="AWSEC2CreateSecurityGroupIfNeeded")
public class AWSEC2CreateSecurityGroupIfNeededTest {
    @Test
    public void testWhenPort22AndToItselfAuthorizesIngressOnce() throws ExecutionException {
        AWSSecurityGroupApi client = (AWSSecurityGroupApi)EasyMock.createMock(AWSSecurityGroupApi.class);
        Predicate tester = Predicates.alwaysTrue();
        SecurityGroup group = (SecurityGroup)EasyMock.createNiceMock(SecurityGroup.class);
        ImmutableSet groups = ImmutableSet.of((Object)group);
        EC2SecurityGroupIdFromName groupIdFromName = (EC2SecurityGroupIdFromName)EasyMock.createMock(EC2SecurityGroupIdFromName.class);
        ImmutableSet.Builder permissions = ImmutableSet.builder();
        permissions.add((Object)IpPermission.builder().fromPort(22).toPort(22).ipProtocol(IpProtocol.TCP).cidrBlock("0.0.0.0/0").build());
        permissions.add((Object)IpPermission.builder().fromPort(0).toPort(65535).ipProtocol(IpProtocol.TCP).tenantIdGroupNamePair("ownerId", "sg-123456").build());
        permissions.add((Object)IpPermission.builder().fromPort(0).toPort(65535).ipProtocol(IpProtocol.UDP).tenantIdGroupNamePair("ownerId", "sg-123456").build());
        EasyMock.expect((Object)client.createSecurityGroupInRegionAndReturnId("region", "group", "group", new CreateSecurityGroupOptions[]{new CreateSecurityGroupOptions().vpcId("vpc")})).andReturn((Object)"sg-123456");
        EasyMock.expect((Object)group.getOwnerId()).andReturn((Object)"ownerId");
        client.authorizeSecurityGroupIngressInRegion("region", "sg-123456", (Iterable)permissions.build());
        EasyMock.expect((Object)client.describeSecurityGroupsInRegion("region", new String[]{"group"})).andReturn(Set.class.cast(groups));
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{group});
        EasyMock.replay((Object[])new Object[]{groupIdFromName});
        AWSEC2CreateSecurityGroupIfNeeded function = new AWSEC2CreateSecurityGroupIfNeeded(client, (Function)groupIdFromName, tester);
        Assert.assertEquals((String)"sg-123456", (String)function.load((RegionAndName)new RegionNameAndIngressRules("region", "group", new int[]{22}, true, "vpc")));
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{group});
        EasyMock.verify((Object[])new Object[]{groupIdFromName});
    }
}

