/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute;

import com.google.common.collect.Iterables;
import com.squareup.okhttp.mockwebserver.MockResponse;
import org.jclouds.aws.ec2.compute.AWSEC2ComputeService;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.aws.ec2.internal.BaseAWSEC2ApiMockTest;
import org.jclouds.aws.ec2.options.Tenancy;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSEC2ComputeServiceMockTest", singleThreaded=true)
public class AWSEC2ComputeServiceApiMockTest
extends BaseAWSEC2ApiMockTest {
    String iamInstanceProfileArn = "arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver";

    protected String getDefaultSmallestInstanceType() {
        return "m3.medium";
    }

    protected String getDefaultParavirtualInstanceType() {
        return "m3.medium";
    }

    protected String getDefaultImageId() {
        return "be3adfd7";
    }

    public void launchVPCSpotInstanceSubnetId() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/availabilityZones.xml");
        this.enqueueXml("us-east-1", "/describe_images.xml");
        this.enqueueXml("us-east-1", "/describe_images_cc.xml");
        this.enqueueXml("us-east-1", "/describe_subnets.xml");
        this.enqueueXml("us-east-1", "/created_securitygroup.xml");
        this.enqueueXml("us-east-1", "/new_securitygroup.xml");
        this.enqueueXml("us-east-1", "/new_securitygroup.xml");
        this.enqueueXml("us-east-1", "/authorize_securitygroup_ingress_response.xml");
        this.enqueueXml("us-east-1", "/request_spot_instances-ebs.xml");
        this.enqueueXml("us-east-1", "/request_spot_instances-ebs.xml");
        this.enqueueXml("us-east-1", "/describe_images_ebs.xml");
        this.enqueue("us-east-1", new MockResponse());
        ComputeService computeService = this.computeService();
        Template template = computeService.templateBuilder().locationId("us-east-1a").build();
        ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).spotPrice(Float.valueOf(1.0f)).subnetId("subnet-9d4a7b6c").keyPair("Demo").blockUntilRunning(false);
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)computeService.createNodesInGroup("test", 1, template));
        Assert.assertEquals((String)node.getId(), (String)"us-east-1/sir-228e6406");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeAvailabilityZones");
        this.assertPosted("us-east-1", "Action=DescribeImages&Filter.1.Name=owner-id&Filter.1.Value.1=137112412989&Filter.1.Value.2=801119661308&Filter.1.Value.3=063491364108&Filter.1.Value.4=099720109477&Filter.1.Value.5=411009282317&Filter.2.Name=state&Filter.2.Value.1=available&Filter.3.Name=image-type&Filter.3.Value.1=machine");
        this.assertPosted("us-east-1", "Action=DescribeImages&Filter.1.Name=virtualization-type&Filter.1.Value.1=hvm&Filter.2.Name=architecture&Filter.2.Value.1=x86_64&Filter.3.Name=owner-id&Filter.3.Value.1=137112412989&Filter.3.Value.2=099720109477&Filter.4.Name=hypervisor&Filter.4.Value.1=xen&Filter.5.Name=state&Filter.5.Value.1=available&Filter.6.Name=image-type&Filter.6.Value.1=machine&Filter.7.Name=root-device-type&Filter.7.Value.1=ebs");
        this.assertPosted("us-east-1", "Action=DescribeSubnets&Filter.1.Name=subnet-id&Filter.1.Value.1=subnet-9d4a7b6c");
        this.assertPosted("us-east-1", "Action=CreateSecurityGroup&GroupName=jclouds%23test&GroupDescription=jclouds%23test&VpcId=vpc-1a2b3c4d");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23test");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23test");
        this.assertPosted("us-east-1", "Action=AuthorizeSecurityGroupIngress&GroupId=sg-3c6ef654&IpPermissions.0.IpProtocol=tcp&IpPermissions.0.FromPort=22&IpPermissions.0.ToPort=22&IpPermissions.0.IpRanges.0.CidrIp=0.0.0.0/0&IpPermissions.1.IpProtocol=tcp&IpPermissions.1.FromPort=0&IpPermissions.1.ToPort=65535&IpPermissions.1.Groups.0.UserId=993194456877&IpPermissions.1.Groups.0.GroupId=sg-3c6ef654&IpPermissions.2.IpProtocol=udp&IpPermissions.2.FromPort=0&IpPermissions.2.ToPort=65535&IpPermissions.2.Groups.0.UserId=993194456877&IpPermissions.2.Groups.0.GroupId=sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=RequestSpotInstances&SpotPrice=1.0&InstanceCount=1&LaunchSpecification.ImageId=ami-" + this.getDefaultImageId() + "&LaunchSpecification.Placement.AvailabilityZone=us-east-1a&LaunchSpecification.SecurityGroupId.1=sg-3c6ef654&LaunchSpecification.InstanceType=" + this.getDefaultSmallestInstanceType() + "&LaunchSpecification.SubnetId=subnet-9d4a7b6c&LaunchSpecification.KeyName=Demo&LaunchSpecification.UserData=I2Nsb3VkLWNvbmZpZwpyZXBvX3VwZ3JhZGU6IG5vbmUK");
        this.assertPosted("us-east-1", "Action=DescribeSpotInstanceRequests&SpotInstanceRequestId.1=sir-228e6406");
        this.assertPosted("us-east-1", "Action=DescribeImages&ImageId.1=ami-595a0a1c");
        this.assertPosted("us-east-1", "Action=CreateTags&Tag.1.Key=Name&Tag.1.Value=test-228e6406&ResourceId.1=sir-228e6406");
    }

    public void launchSpotInstanceIAMInstanceProfileArn() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/availabilityZones.xml");
        this.enqueueXml("us-east-1", "/describe_images.xml");
        this.enqueueXml("us-east-1", "/describe_images_cc.xml");
        this.enqueueXml("us-east-1", "/created_securitygroup.xml");
        this.enqueueXml("us-east-1", "/new_securitygroup.xml");
        this.enqueueXml("us-east-1", "/new_securitygroup.xml");
        this.enqueueXml("us-east-1", "/authorize_securitygroup_ingress_response.xml");
        this.enqueueXml("us-east-1", "/request_spot_instances-ebs.xml");
        this.enqueueXml("us-east-1", "/request_spot_instances-ebs.xml");
        this.enqueueXml("us-east-1", "/describe_images_ebs.xml");
        this.enqueue("us-east-1", new MockResponse());
        ComputeService computeService = this.computeService();
        Template template = computeService.templateBuilder().locationId("us-east-1a").build();
        ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).spotPrice(Float.valueOf(1.0f)).iamInstanceProfileArn(this.iamInstanceProfileArn).noKeyPair().blockUntilRunning(false);
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)computeService.createNodesInGroup("test", 1, template));
        Assert.assertEquals((String)node.getId(), (String)"us-east-1/sir-228e6406");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeAvailabilityZones");
        this.assertPosted("us-east-1", "Action=DescribeImages&Filter.1.Name=owner-id&Filter.1.Value.1=137112412989&Filter.1.Value.2=801119661308&Filter.1.Value.3=063491364108&Filter.1.Value.4=099720109477&Filter.1.Value.5=411009282317&Filter.2.Name=state&Filter.2.Value.1=available&Filter.3.Name=image-type&Filter.3.Value.1=machine");
        this.assertPosted("us-east-1", "Action=DescribeImages&Filter.1.Name=virtualization-type&Filter.1.Value.1=hvm&Filter.2.Name=architecture&Filter.2.Value.1=x86_64&Filter.3.Name=owner-id&Filter.3.Value.1=137112412989&Filter.3.Value.2=099720109477&Filter.4.Name=hypervisor&Filter.4.Value.1=xen&Filter.5.Name=state&Filter.5.Value.1=available&Filter.6.Name=image-type&Filter.6.Value.1=machine&Filter.7.Name=root-device-type&Filter.7.Value.1=ebs");
        this.assertPosted("us-east-1", "Action=CreateSecurityGroup&GroupName=jclouds%23test&GroupDescription=jclouds%23test");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23test");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23test");
        this.assertPosted("us-east-1", "Action=AuthorizeSecurityGroupIngress&GroupId=sg-3c6ef654&IpPermissions.0.IpProtocol=tcp&IpPermissions.0.FromPort=22&IpPermissions.0.ToPort=22&IpPermissions.0.IpRanges.0.CidrIp=0.0.0.0/0&IpPermissions.1.IpProtocol=tcp&IpPermissions.1.FromPort=0&IpPermissions.1.ToPort=65535&IpPermissions.1.Groups.0.UserId=993194456877&IpPermissions.1.Groups.0.GroupId=sg-3c6ef654&IpPermissions.2.IpProtocol=udp&IpPermissions.2.FromPort=0&IpPermissions.2.ToPort=65535&IpPermissions.2.Groups.0.UserId=993194456877&IpPermissions.2.Groups.0.GroupId=sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=RequestSpotInstances&SpotPrice=1.0&InstanceCount=1&LaunchSpecification.ImageId=ami-" + this.getDefaultImageId() + "&LaunchSpecification.Placement.AvailabilityZone=us-east-1a&LaunchSpecification.SecurityGroupId.1=sg-3c6ef654&LaunchSpecification.InstanceType=" + this.getDefaultSmallestInstanceType() + "&LaunchSpecification.UserData=I2Nsb3VkLWNvbmZpZwpyZXBvX3VwZ3JhZGU6IG5vbmUK&LaunchSpecification.IamInstanceProfile.Arn=arn%3Aaws%3Aiam%3A%3A123456789012%3Ainstance-profile/application_abc/component_xyz/Webserver");
        this.assertPosted("us-east-1", "Action=DescribeSpotInstanceRequests&SpotInstanceRequestId.1=sir-228e6406");
        this.assertPosted("us-east-1", "Action=DescribeImages&ImageId.1=ami-595a0a1c");
        this.assertPosted("us-east-1", "Action=CreateTags&Tag.1.Key=Name&Tag.1.Value=test-228e6406&ResourceId.1=sir-228e6406");
    }

    public void launchSpotInstanceIAMInstanceProfileName() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/availabilityZones.xml");
        this.enqueueXml("us-east-1", "/describe_images.xml");
        this.enqueueXml("us-east-1", "/describe_images_cc.xml");
        this.enqueueXml("us-east-1", "/created_securitygroup.xml");
        this.enqueueXml("us-east-1", "/new_securitygroup.xml");
        this.enqueueXml("us-east-1", "/new_securitygroup.xml");
        this.enqueueXml("us-east-1", "/authorize_securitygroup_ingress_response.xml");
        this.enqueueXml("us-east-1", "/request_spot_instances-ebs.xml");
        this.enqueueXml("us-east-1", "/request_spot_instances-ebs.xml");
        this.enqueueXml("us-east-1", "/describe_images_ebs.xml");
        this.enqueue("us-east-1", new MockResponse());
        ComputeService computeService = this.computeService();
        Template template = computeService.templateBuilder().locationId("us-east-1a").build();
        ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).spotPrice(Float.valueOf(1.0f)).iamInstanceProfileName("Webserver").noKeyPair().blockUntilRunning(false);
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)computeService.createNodesInGroup("test", 1, template));
        Assert.assertEquals((String)node.getId(), (String)"us-east-1/sir-228e6406");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeAvailabilityZones");
        this.assertPosted("us-east-1", "Action=DescribeImages&Filter.1.Name=owner-id&Filter.1.Value.1=137112412989&Filter.1.Value.2=801119661308&Filter.1.Value.3=063491364108&Filter.1.Value.4=099720109477&Filter.1.Value.5=411009282317&Filter.2.Name=state&Filter.2.Value.1=available&Filter.3.Name=image-type&Filter.3.Value.1=machine");
        this.assertPosted("us-east-1", "Action=DescribeImages&Filter.1.Name=virtualization-type&Filter.1.Value.1=hvm&Filter.2.Name=architecture&Filter.2.Value.1=x86_64&Filter.3.Name=owner-id&Filter.3.Value.1=137112412989&Filter.3.Value.2=099720109477&Filter.4.Name=hypervisor&Filter.4.Value.1=xen&Filter.5.Name=state&Filter.5.Value.1=available&Filter.6.Name=image-type&Filter.6.Value.1=machine&Filter.7.Name=root-device-type&Filter.7.Value.1=ebs");
        this.assertPosted("us-east-1", "Action=CreateSecurityGroup&GroupName=jclouds%23test&GroupDescription=jclouds%23test");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23test");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23test");
        this.assertPosted("us-east-1", "Action=AuthorizeSecurityGroupIngress&GroupId=sg-3c6ef654&IpPermissions.0.IpProtocol=tcp&IpPermissions.0.FromPort=22&IpPermissions.0.ToPort=22&IpPermissions.0.IpRanges.0.CidrIp=0.0.0.0/0&IpPermissions.1.IpProtocol=tcp&IpPermissions.1.FromPort=0&IpPermissions.1.ToPort=65535&IpPermissions.1.Groups.0.UserId=993194456877&IpPermissions.1.Groups.0.GroupId=sg-3c6ef654&IpPermissions.2.IpProtocol=udp&IpPermissions.2.FromPort=0&IpPermissions.2.ToPort=65535&IpPermissions.2.Groups.0.UserId=993194456877&IpPermissions.2.Groups.0.GroupId=sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=RequestSpotInstances&SpotPrice=1.0&InstanceCount=1&LaunchSpecification.ImageId=ami-" + this.getDefaultImageId() + "&LaunchSpecification.Placement.AvailabilityZone=us-east-1a&LaunchSpecification.SecurityGroupId.1=sg-3c6ef654&LaunchSpecification.InstanceType=" + this.getDefaultSmallestInstanceType() + "&LaunchSpecification.UserData=I2Nsb3VkLWNvbmZpZwpyZXBvX3VwZ3JhZGU6IG5vbmUK&LaunchSpecification.IamInstanceProfile.Name=Webserver");
        this.assertPosted("us-east-1", "Action=DescribeSpotInstanceRequests&SpotInstanceRequestId.1=sir-228e6406");
        this.assertPosted("us-east-1", "Action=DescribeImages&ImageId.1=ami-595a0a1c");
        this.assertPosted("us-east-1", "Action=CreateTags&Tag.1.Key=Name&Tag.1.Value=test-228e6406&ResourceId.1=sir-228e6406");
    }

    public void createNodeWithIAMInstanceProfileArn() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/amzn_images.xml");
        this.enqueueXml("us-east-1", "/describe_images_cc.xml");
        this.enqueueXml("us-east-1", "/availabilityZones.xml");
        this.enqueueXml("us-east-1", "/created_securitygroup.xml");
        this.enqueueXml("us-east-1", "/new_securitygroup.xml");
        this.enqueueXml("us-east-1", "/new_securitygroup.xml");
        this.enqueueXml("us-east-1", "/authorize_securitygroup_ingress_response.xml");
        this.enqueueXml("us-east-1", "/new_instance.xml");
        this.enqueueXml("us-east-1", "/describe_instances_running-1.xml");
        this.enqueueXml("us-east-1", "/describe_images.xml");
        this.enqueue("us-east-1", new MockResponse());
        ComputeService computeService = this.computeService();
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)computeService.createNodesInGroup("test", 1, (TemplateOptions)AWSEC2TemplateOptions.Builder.blockUntilRunning((boolean)false).iamInstanceProfileArn(this.iamInstanceProfileArn).noKeyPair()));
        Assert.assertEquals((String)node.getId(), (String)"us-east-1/i-2baa5550");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeImages&Filter.1.Name=owner-id&Filter.1.Value.1=137112412989&Filter.1.Value.2=801119661308&Filter.1.Value.3=063491364108&Filter.1.Value.4=099720109477&Filter.1.Value.5=411009282317&Filter.2.Name=state&Filter.2.Value.1=available&Filter.3.Name=image-type&Filter.3.Value.1=machine");
        this.assertPosted("us-east-1", "Action=DescribeImages&Filter.1.Name=virtualization-type&Filter.1.Value.1=hvm&Filter.2.Name=architecture&Filter.2.Value.1=x86_64&Filter.3.Name=owner-id&Filter.3.Value.1=137112412989&Filter.3.Value.2=099720109477&Filter.4.Name=hypervisor&Filter.4.Value.1=xen&Filter.5.Name=state&Filter.5.Value.1=available&Filter.6.Name=image-type&Filter.6.Value.1=machine&Filter.7.Name=root-device-type&Filter.7.Value.1=ebs");
        this.assertPosted("us-east-1", "Action=DescribeAvailabilityZones");
        this.assertPosted("us-east-1", "Action=CreateSecurityGroup&GroupName=jclouds%23test&GroupDescription=jclouds%23test");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23test");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23test");
        this.assertPosted("us-east-1", "Action=AuthorizeSecurityGroupIngress&GroupId=sg-3c6ef654&IpPermissions.0.IpProtocol=tcp&IpPermissions.0.FromPort=22&IpPermissions.0.ToPort=22&IpPermissions.0.IpRanges.0.CidrIp=0.0.0.0/0&IpPermissions.1.IpProtocol=tcp&IpPermissions.1.FromPort=0&IpPermissions.1.ToPort=65535&IpPermissions.1.Groups.0.UserId=993194456877&IpPermissions.1.Groups.0.GroupId=sg-3c6ef654&IpPermissions.2.IpProtocol=udp&IpPermissions.2.FromPort=0&IpPermissions.2.ToPort=65535&IpPermissions.2.Groups.0.UserId=993194456877&IpPermissions.2.Groups.0.GroupId=sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=RunInstances&ImageId=ami-8ce4b5c9&MinCount=1&MaxCount=1&InstanceType=" + this.getDefaultParavirtualInstanceType() + "&SecurityGroupId.1=sg-3c6ef654&UserData=I2Nsb3VkLWNvbmZpZwpyZXBvX3VwZ3JhZGU6IG5vbmUK&IamInstanceProfile.Arn=arn%3Aaws%3Aiam%3A%3A123456789012%3Ainstance-profile/application_abc/component_xyz/Webserver");
        this.assertPosted("us-east-1", "Action=DescribeInstances&InstanceId.1=i-2baa5550");
        this.assertPosted("us-east-1", "Action=DescribeImages&ImageId.1=ami-aecd60c7");
        this.assertPosted("us-east-1", "Action=CreateTags&Tag.1.Key=Name&Tag.1.Value=test-2baa5550&ResourceId.1=i-2baa5550");
    }

    public void createNodeWithIAMInstanceProfileName() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/amzn_images.xml");
        this.enqueueXml("us-east-1", "/describe_images_cc.xml");
        this.enqueueXml("us-east-1", "/availabilityZones.xml");
        this.enqueueXml("us-east-1", "/created_securitygroup.xml");
        this.enqueueXml("us-east-1", "/new_securitygroup.xml");
        this.enqueueXml("us-east-1", "/new_securitygroup.xml");
        this.enqueueXml("us-east-1", "/authorize_securitygroup_ingress_response.xml");
        this.enqueueXml("us-east-1", "/new_instance.xml");
        this.enqueueXml("us-east-1", "/describe_instances_running-1.xml");
        this.enqueueXml("us-east-1", "/describe_images.xml");
        this.enqueue("us-east-1", new MockResponse());
        ComputeService computeService = this.computeService();
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)computeService.createNodesInGroup("test", 1, (TemplateOptions)AWSEC2TemplateOptions.Builder.blockUntilRunning((boolean)false).iamInstanceProfileName("Webserver").noKeyPair()));
        Assert.assertEquals((String)node.getId(), (String)"us-east-1/i-2baa5550");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeImages&Filter.1.Name=owner-id&Filter.1.Value.1=137112412989&Filter.1.Value.2=801119661308&Filter.1.Value.3=063491364108&Filter.1.Value.4=099720109477&Filter.1.Value.5=411009282317&Filter.2.Name=state&Filter.2.Value.1=available&Filter.3.Name=image-type&Filter.3.Value.1=machine");
        this.assertPosted("us-east-1", "Action=DescribeImages&Filter.1.Name=virtualization-type&Filter.1.Value.1=hvm&Filter.2.Name=architecture&Filter.2.Value.1=x86_64&Filter.3.Name=owner-id&Filter.3.Value.1=137112412989&Filter.3.Value.2=099720109477&Filter.4.Name=hypervisor&Filter.4.Value.1=xen&Filter.5.Name=state&Filter.5.Value.1=available&Filter.6.Name=image-type&Filter.6.Value.1=machine&Filter.7.Name=root-device-type&Filter.7.Value.1=ebs");
        this.assertPosted("us-east-1", "Action=DescribeAvailabilityZones");
        this.assertPosted("us-east-1", "Action=CreateSecurityGroup&GroupName=jclouds%23test&GroupDescription=jclouds%23test");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23test");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23test");
        this.assertPosted("us-east-1", "Action=AuthorizeSecurityGroupIngress&GroupId=sg-3c6ef654&IpPermissions.0.IpProtocol=tcp&IpPermissions.0.FromPort=22&IpPermissions.0.ToPort=22&IpPermissions.0.IpRanges.0.CidrIp=0.0.0.0/0&IpPermissions.1.IpProtocol=tcp&IpPermissions.1.FromPort=0&IpPermissions.1.ToPort=65535&IpPermissions.1.Groups.0.UserId=993194456877&IpPermissions.1.Groups.0.GroupId=sg-3c6ef654&IpPermissions.2.IpProtocol=udp&IpPermissions.2.FromPort=0&IpPermissions.2.ToPort=65535&IpPermissions.2.Groups.0.UserId=993194456877&IpPermissions.2.Groups.0.GroupId=sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=RunInstances&ImageId=ami-8ce4b5c9&MinCount=1&MaxCount=1&InstanceType=" + this.getDefaultParavirtualInstanceType() + "&SecurityGroupId.1=sg-3c6ef654&UserData=I2Nsb3VkLWNvbmZpZwpyZXBvX3VwZ3JhZGU6IG5vbmUK&IamInstanceProfile.Name=Webserver");
        this.assertPosted("us-east-1", "Action=DescribeInstances&InstanceId.1=i-2baa5550");
        this.assertPosted("us-east-1", "Action=DescribeImages&ImageId.1=ami-aecd60c7");
        this.assertPosted("us-east-1", "Action=CreateTags&Tag.1.Key=Name&Tag.1.Value=test-2baa5550&ResourceId.1=i-2baa5550");
    }

    public void createNodeWithDedicatedTenancyAndHostId() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/amzn_images.xml");
        this.enqueueXml("us-east-1", "/describe_images_cc.xml");
        this.enqueueXml("us-east-1", "/availabilityZones.xml");
        this.enqueueXml("us-east-1", "/created_securitygroup.xml");
        this.enqueueXml("us-east-1", "/new_securitygroup.xml");
        this.enqueueXml("us-east-1", "/new_securitygroup.xml");
        this.enqueueXml("us-east-1", "/authorize_securitygroup_ingress_response.xml");
        this.enqueueXml("us-east-1", "/new_instance.xml");
        this.enqueueXml("us-east-1", "/describe_instances_running-1.xml");
        this.enqueueXml("us-east-1", "/describe_images.xml");
        this.enqueue("us-east-1", new MockResponse());
        ComputeService computeService = this.computeService();
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)computeService.createNodesInGroup("test", 1, (TemplateOptions)AWSEC2TemplateOptions.Builder.blockUntilRunning((boolean)false).noKeyPair().tenancy(Tenancy.HOST).dedicatedHostId("TestHostId")));
        Assert.assertEquals((String)node.getId(), (String)"us-east-1/i-2baa5550");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeImages&Filter.1.Name=owner-id&Filter.1.Value.1=137112412989&Filter.1.Value.2=801119661308&Filter.1.Value.3=063491364108&Filter.1.Value.4=099720109477&Filter.1.Value.5=411009282317&Filter.2.Name=state&Filter.2.Value.1=available&Filter.3.Name=image-type&Filter.3.Value.1=machine");
        this.assertPosted("us-east-1", "Action=DescribeImages&Filter.1.Name=virtualization-type&Filter.1.Value.1=hvm&Filter.2.Name=architecture&Filter.2.Value.1=x86_64&Filter.3.Name=owner-id&Filter.3.Value.1=137112412989&Filter.3.Value.2=099720109477&Filter.4.Name=hypervisor&Filter.4.Value.1=xen&Filter.5.Name=state&Filter.5.Value.1=available&Filter.6.Name=image-type&Filter.6.Value.1=machine&Filter.7.Name=root-device-type&Filter.7.Value.1=ebs");
        this.assertPosted("us-east-1", "Action=DescribeAvailabilityZones");
        this.assertPosted("us-east-1", "Action=CreateSecurityGroup&GroupName=jclouds%23test&GroupDescription=jclouds%23test");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23test");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23test");
        this.assertPosted("us-east-1", "Action=AuthorizeSecurityGroupIngress&GroupId=sg-3c6ef654&IpPermissions.0.IpProtocol=tcp&IpPermissions.0.FromPort=22&IpPermissions.0.ToPort=22&IpPermissions.0.IpRanges.0.CidrIp=0.0.0.0/0&IpPermissions.1.IpProtocol=tcp&IpPermissions.1.FromPort=0&IpPermissions.1.ToPort=65535&IpPermissions.1.Groups.0.UserId=993194456877&IpPermissions.1.Groups.0.GroupId=sg-3c6ef654&IpPermissions.2.IpProtocol=udp&IpPermissions.2.FromPort=0&IpPermissions.2.ToPort=65535&IpPermissions.2.Groups.0.UserId=993194456877&IpPermissions.2.Groups.0.GroupId=sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=RunInstances&ImageId=ami-8ce4b5c9&MinCount=1&MaxCount=1&InstanceType=" + this.getDefaultParavirtualInstanceType() + "&SecurityGroupId.1=sg-3c6ef654&UserData=I2Nsb3VkLWNvbmZpZwpyZXBvX3VwZ3JhZGU6IG5vbmUK&Placement.Tenancy=host&Placement.HostId=TestHostId");
        this.assertPosted("us-east-1", "Action=DescribeInstances&InstanceId.1=i-2baa5550");
        this.assertPosted("us-east-1", "Action=DescribeImages&ImageId.1=ami-aecd60c7");
        this.assertPosted("us-east-1", "Action=CreateTags&Tag.1.Key=Name&Tag.1.Value=test-2baa5550&ResourceId.1=i-2baa5550");
    }

    public void listNodesWhereImageDoesntExist() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/describe_instances_running-1.xml");
        this.enqueueXml("us-east-1", "/availabilityZones.xml");
        this.enqueue("us-east-1", new MockResponse().setBody("<DescribeImagesResponse><imagesSet></imagesSet></DescribeImagesResponse>"));
        this.enqueue("us-east-1", new MockResponse().setBody("<DescribeSpotInstanceRequestsResponse><spotInstanceRequestSet></spotInstanceRequestSet></DescribeSpotInstanceRequestsResponse>"));
        ComputeService computeService = this.computeService();
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)computeService.listNodesDetailsMatching(NodePredicates.all()));
        Assert.assertEquals((String)node.getId(), (String)"us-east-1/i-2baa5550");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeInstances");
        this.assertPosted("us-east-1", "Action=DescribeAvailabilityZones");
        this.assertPosted("us-east-1", "Action=DescribeImages&ImageId.1=ami-aecd60c7");
        this.assertPosted("us-east-1", "Action=DescribeSpotInstanceRequests");
    }

    public void deleteIncidentalResourcesSuccessfully() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/describe_securitygroups_extension_single.xml");
        this.enqueueXml("us-east-1", "/delete_securitygroup.xml");
        this.enqueueXml("us-east-1", "/describe_keypairs_jcloudssingle.xml");
        this.enqueueXml("us-east-1", "/describe_instances_empty.xml");
        this.enqueueXml("us-east-1", "/delete_keypair.xml");
        this.enqueueXml("us-east-1", "/describe_placement_groups.xml");
        this.enqueueXml("us-east-1", "/delete_placementgroup.xml");
        this.enqueueXml("us-east-1", "/describe_placement_groups_empty.xml");
        AWSEC2ComputeService computeService = (AWSEC2ComputeService)this.computeService();
        computeService.cleanUpIncidentalResources("us-east-1", "sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DeleteSecurityGroup&GroupName=jclouds%23sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DescribeKeyPairs&Filter.1.Name=key-name&Filter.1.Value.1=jclouds%23sg-3c6ef654%23%2A");
        this.assertPosted("us-east-1", "Action=DescribeInstances&Filter.1.Name=instance-state-name&Filter.1.Value.1=terminated&Filter.1.Value.2=shutting-down&Filter.2.Name=key-name&Filter.2.Value.1=jclouds%23sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DeleteKeyPair&KeyName=jclouds%23sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DescribePlacementGroups&GroupName.1=jclouds%23sg-3c6ef654%23us-east-1");
        this.assertPosted("us-east-1", "Action=DeletePlacementGroup&GroupName=jclouds%23sg-3c6ef654%23us-east-1");
        this.assertPosted("us-east-1", "Action=DescribePlacementGroups&GroupName.1=jclouds%23sg-3c6ef654%23us-east-1");
    }

    public void deleteIncidentalResourcesGivingDependencyViolationForSecurityGroup() throws Exception {
        this.runDeleteIncidentalResourcesGivingErrForSecurityGroup("DependencyViolation");
    }

    public void deleteIncidentalResourcesGivingInUseForSecurityGroup() throws Exception {
        this.runDeleteIncidentalResourcesGivingErrForSecurityGroup("InvalidGroup.InUse");
    }

    protected void runDeleteIncidentalResourcesGivingErrForSecurityGroup(String errCode) throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/describe_securitygroups_extension_single.xml");
        this.enqueue("us-east-1", new MockResponse().setResponseCode(400).setBody("<Response><Errors><Error><Code>" + errCode + "</Code><Message>resource sg-3c6ef654 has a dependent object</Message></Error></Errors><RequestID>e4f4c78f-4455-43dd-b5cb-9af0bc4bc804</RequestID></Response>"));
        this.enqueueXml("us-east-1", "/describe_placement_groups.xml");
        this.enqueueXml("us-east-1", "/delete_placementgroup.xml");
        this.enqueueXml("us-east-1", "/describe_placement_groups_empty.xml");
        AWSEC2ComputeService computeService = (AWSEC2ComputeService)this.computeService();
        computeService.cleanUpIncidentalResources("us-east-1", "sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=DescribeSecurityGroups&GroupName.1=jclouds%23sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DeleteSecurityGroup&GroupName=jclouds%23sg-3c6ef654");
        this.assertPosted("us-east-1", "Action=DescribePlacementGroups&GroupName.1=jclouds%23sg-3c6ef654%23us-east-1");
        this.assertPosted("us-east-1", "Action=DeletePlacementGroup&GroupName=jclouds%23sg-3c6ef654%23us-east-1");
        this.assertPosted("us-east-1", "Action=DescribePlacementGroups&GroupName.1=jclouds%23sg-3c6ef654%23us-east-1");
    }
}

