/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.binders;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import org.jclouds.aws.ec2.binders.BindTagsToIndexedFormParams;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindTagsToIndexedFormParamsTest {
    Injector injector = Guice.createInjector((Module[])new Module[0]);
    BindTagsToIndexedFormParams binder = (BindTagsToIndexedFormParams)this.injector.getInstance(BindTagsToIndexedFormParams.class);

    public void test() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)ImmutableMap.builder().put((Object)"one", (Object)"alpha").put((Object)"two", (Object)"beta").build());
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"Tag.1.Key=one&Tag.1.Value=alpha&Tag.2.Key=two&Tag.2.Value=beta");
    }

    public void testEmpty() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)ImmutableMap.builder().put((Object)"empty", (Object)"").build());
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"Tag.1.Key=empty&Tag.1.Value=");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeArray() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        this.binder.bindToRequest(request, null);
    }
}

