/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.View;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.AWSEC2ProviderMetadata;
import org.jclouds.aws.ec2.compute.config.ImageQuery;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.ec2.EC2Api;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.reflect.Reflection2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSEC2ContextBuilderTest")
public class AWSEC2ContextBuilderTest {
    private Map<String, String> queriesForProperties(Properties input) {
        return (Map)ContextBuilder.newBuilder((ProviderMetadata)new AWSEC2ProviderMetadata()).overrides(input).credentials("foo", "bar").buildInjector().getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, String>>(){}, ImageQuery.class));
    }

    public void testAssignability() {
        View view = ContextBuilder.newBuilder((ProviderMetadata)new AWSEC2ProviderMetadata()).credentials("foo", "bar").buildView(Reflection2.typeToken(ComputeServiceContext.class));
        view.unwrapApi(EC2Api.class);
        view.unwrapApi(AWSEC2Api.class);
    }

    public void testConvertImageSyntax() {
        Properties input = new Properties();
        input.setProperty("jclouds.ec2.ami-owners", "137112412989,063491364108,099720109477,411009282317");
        Map<String, String> queries = this.queriesForProperties(input);
        Assert.assertEquals((String)queries.get("jclouds.ec2.ami-owners"), null);
        Assert.assertEquals((String)queries.get("jclouds.ec2.ami-query"), (String)"owner-id=137112412989,063491364108,099720109477,411009282317;state=available;image-type=machine");
    }

    public void testConvertImageSyntaxWhenStar() {
        Properties input = new Properties();
        input.setProperty("jclouds.ec2.ami-owners", "*");
        Map<String, String> queries = this.queriesForProperties(input);
        Assert.assertEquals((String)queries.get("jclouds.ec2.ami-owners"), null);
        Assert.assertEquals((String)queries.get("jclouds.ec2.ami-query"), (String)"state=available;image-type=machine");
    }

    public void testBlankAmiOwnersRemovesAmiQuery() {
        Properties input = new Properties();
        input.setProperty("jclouds.ec2.ami-owners", "");
        Map<String, String> queries = this.queriesForProperties(input);
        Assert.assertEquals((String)queries.get("jclouds.ec2.ami-owners"), null);
        Assert.assertEquals((String)queries.get("jclouds.ec2.ami-query"), null);
    }
}

