/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.aws.ec2.xml.AWSDescribeInstancesResponseHandler;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.location.Region;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSDescribeInstancesResponseHandlerTest")
public class AWSDescribeInstancesResponseHandlerTest
extends BaseEC2HandlerTest {
    private DateService dateService;

    @BeforeTest
    protected void setUpInjector() {
        super.setUpInjector();
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
        assert (this.dateService != null);
    }

    public void testWhenRunningLatest() throws UnknownHostException {
        ImmutableSet contents = ImmutableSet.of((Object)Reservation.builder().region(this.defaultRegion).reservationId("r-0f4c2160").groupName("jclouds#zkclustertest#us-east-1").instance((RunningInstance)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)AWSRunningInstance.builder().region(this.defaultRegion)).instanceId("i-911444f0")).imageId("ami-63be790a")).instanceState(InstanceState.RUNNING)).rawState("running")).privateDnsName("ip-10-212-81-7.ec2.internal")).dnsName("ec2-174-129-173-155.compute-1.amazonaws.com")).keyName("jclouds#zkclustertest#us-east-1#23")).amiLaunchIndex("0")).instanceType("t1.micro")).launchTime(this.dateService.iso8601DateParse("2011-08-16T13:40:50.000Z"))).availabilityZone("us-east-1c")).kernelId("aki-427d952b")).monitoringState(MonitoringState.DISABLED).privateIpAddress("10.212.81.7")).ipAddress("174.129.173.155")).securityGroupIdToName("sg-ef052b86", "jclouds#zkclustertest#us-east-1").tag("Name", "ec2-o")).tag("Empty", "")).rootDeviceType(RootDeviceType.EBS)).rootDeviceName("/dev/sda1")).device("/dev/sda1", new BlockDevice("vol-5829fc32", Attachment.Status.ATTACHED, this.dateService.iso8601DateParse("2011-08-16T13:41:19.000Z"), true))).hypervisor(Hypervisor.XEN).virtualizationType("paravirtual")).build()).instance((RunningInstance)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)AWSRunningInstance.builder().region(this.defaultRegion)).instanceId("i-931444f2")).imageId("ami-63be790a")).instanceState(InstanceState.RUNNING)).rawState("running")).privateDnsName("ip-10-212-185-8.ec2.internal")).dnsName("ec2-50-19-207-248.compute-1.amazonaws.com")).keyName("jclouds#zkclustertest#us-east-1#23")).amiLaunchIndex("0")).instanceType("t1.micro")).launchTime(this.dateService.iso8601DateParse("2011-08-16T13:40:50.000Z"))).availabilityZone("us-east-1c")).kernelId("aki-427d952b")).monitoringState(MonitoringState.DISABLED).privateIpAddress("10.212.185.8")).ipAddress("50.19.207.248")).securityGroupIdToNames((Map)ImmutableMap.of((Object)"sg-ef052b86", (Object)"jclouds#zkclustertest#us-east-1")).rootDeviceType(RootDeviceType.EBS)).rootDeviceName("/dev/sda1")).device("/dev/sda1", new BlockDevice("vol-5029fc3a", Attachment.Status.ATTACHED, this.dateService.iso8601DateParse("2011-08-16T13:41:19.000Z"), true))).hypervisor(Hypervisor.XEN).virtualizationType("paravirtual")).iamInstanceProfileArn("arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver").iamInstanceProfileId("AIPAD5ARO2C5EXAMPLE3G").build()).build());
        Set<Reservation<? extends RunningInstance>> result = AWSDescribeInstancesResponseHandlerTest.parseAWSRunningInstances("/describe_instances_latest.xml");
        Assert.assertEquals((String)result.toString(), (String)contents.toString());
    }

    public void testParseNoNPE() {
        AWSDescribeInstancesResponseHandlerTest.parseAWSRunningInstances("/describe_instances_1.xml");
        AWSDescribeInstancesResponseHandlerTest.parseAWSRunningInstances("/describe_instances_2.xml");
        AWSDescribeInstancesResponseHandlerTest.parseAWSRunningInstances("/describe_instances_3.xml");
    }

    static ParseSax<Set<Reservation<? extends RunningInstance>>> createParser() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).annotatedWith(Region.class).toInstance((Object)Suppliers.ofInstance((Object)"us-east-1"));
                this.bind(RunningInstance.Builder.class).to(AWSRunningInstance.Builder.class);
            }
        }});
        ParseSax parser = ((ParseSax.Factory)injector.getInstance(ParseSax.Factory.class)).create((ParseSax.HandlerWithResult)injector.getInstance(AWSDescribeInstancesResponseHandler.class));
        return parser;
    }

    public static Set<Reservation<? extends RunningInstance>> parseAWSRunningInstances(String resource) {
        InputStream is = AWSDescribeInstancesResponseHandlerTest.class.getResourceAsStream(resource);
        return (Set)AWSDescribeInstancesResponseHandlerTest.createParser().parse(is);
    }
}

