/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.jclouds.aws.ec2.options.AWSDescribeImagesOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AWSDescribeImagesOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(AWSDescribeImagesOptions.class));
        assert (!String.class.isAssignableFrom(AWSDescribeImagesOptions.class));
    }

    @Test
    public void testExecutableBy() {
        AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
        options.executableBy("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ExecutableBy"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullExecutableBy() {
        AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ExecutableBy"), (Collection)ImmutableList.of());
    }

    @Test
    public void testExecutableByStatic() {
        AWSDescribeImagesOptions options = AWSDescribeImagesOptions.Builder.executableBy((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ExecutableBy"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testExecutableByNPE() {
        AWSDescribeImagesOptions.Builder.executableBy(null);
    }

    @Test
    public void testOwners() {
        AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
        options.ownedBy(new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testMultipleOwners() {
        AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
        options.ownedBy(new String[]{"test", "trouble"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.1"), (Collection)ImmutableList.of((Object)"test"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.2"), (Collection)ImmutableList.of((Object)"trouble"));
    }

    @Test
    public void testNullOwners() {
        AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.1"), (Collection)ImmutableList.of());
    }

    @Test
    public void testOwnersStatic() {
        AWSDescribeImagesOptions options = AWSDescribeImagesOptions.Builder.ownedBy((String[])new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    public void testNoOwners() {
        AWSDescribeImagesOptions.Builder.ownedBy((String[])new String[0]);
    }

    @Test
    public void testImageIds() {
        AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
        options.imageIds(new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ImageId.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testMultipleImageIds() {
        AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
        options.imageIds(new String[]{"test", "trouble"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ImageId.1"), (Collection)ImmutableList.of((Object)"test"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ImageId.2"), (Collection)ImmutableList.of((Object)"trouble"));
    }

    @Test
    public void testNullImageIds() {
        AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ImageId.1"), (Collection)ImmutableList.of());
    }

    @Test
    public void testImageIdsStatic() {
        AWSDescribeImagesOptions options = AWSDescribeImagesOptions.Builder.imageIds((String[])new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ImageId.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    public void testNoImageIds() {
        AWSDescribeImagesOptions.Builder.imageIds((String[])new String[0]);
    }

    @Test
    public void testMapFilters() {
        AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
        options.filters((Map)ImmutableMap.of((Object)"is-public", (Object)"true", (Object)"architecture", (Object)"x86_64", (Object)"platform", (Object)"windows"));
        this.testMapFilters(options);
    }

    private void testMapFilters(AWSDescribeImagesOptions options) {
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Filter.1.Name"), (Collection)ImmutableList.of((Object)"is-public"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Filter.1.Value.1"), (Collection)ImmutableList.of((Object)"true"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Filter.2.Name"), (Collection)ImmutableList.of((Object)"architecture"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Filter.2.Value.1"), (Collection)ImmutableList.of((Object)"x86_64"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Filter.3.Name"), (Collection)ImmutableList.of((Object)"platform"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Filter.3.Value.1"), (Collection)ImmutableList.of((Object)"windows"));
    }

    @Test
    public void testMapFiltersStatic() {
        AWSDescribeImagesOptions options = AWSDescribeImagesOptions.Builder.filters((Map)ImmutableMap.of((Object)"is-public", (Object)"true", (Object)"architecture", (Object)"x86_64", (Object)"platform", (Object)"windows"));
        this.testMapFilters(options);
    }

    @Test
    public void testMultimapFilters() {
        AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
        options.filters((Multimap)ImmutableMultimap.of((Object)"is-public", (Object)"true", (Object)"architecture", (Object)"x86_64", (Object)"platform", (Object)"windows"));
        this.testMultimapFilters(options);
    }

    private void testMultimapFilters(AWSDescribeImagesOptions options) {
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Filter.1.Name"), (Collection)ImmutableList.of((Object)"is-public"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Filter.1.Value.1"), (Collection)ImmutableList.of((Object)"true"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Filter.2.Name"), (Collection)ImmutableList.of((Object)"architecture"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Filter.2.Value.1"), (Collection)ImmutableList.of((Object)"x86_64"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Filter.3.Name"), (Collection)ImmutableList.of((Object)"platform"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Filter.3.Value.1"), (Collection)ImmutableList.of((Object)"windows"));
    }

    @Test
    public void testMultimapFiltersStatic() {
        AWSDescribeImagesOptions options = AWSDescribeImagesOptions.Builder.filters((Multimap)ImmutableMultimap.of((Object)"is-public", (Object)"true", (Object)"architecture", (Object)"x86_64", (Object)"platform", (Object)"windows"));
        this.testMultimapFilters(options);
    }
}

