/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import java.util.Map;
import org.jclouds.aws.ec2.features.MonitoringApi;
import org.jclouds.aws.ec2.internal.BaseAWSEC2ApiMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="MonitoringApiMockTest", singleThreaded=true)
public class MonitoringApiMockTest
extends BaseAWSEC2ApiMockTest {
    public void monitorInstancesInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/monitoring.xml");
        Map result = this.monitoringApi().monitorInstancesInRegion("us-east-1", "i-911444f0", new String[]{"i-911444f1"});
        Assert.assertFalse((boolean)result.isEmpty());
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=MonitorInstances&InstanceId.0=i-911444f0&InstanceId.1=i-911444f1");
    }

    public void unmonitorInstancesInRegion() throws Exception {
        this.enqueueRegions("us-east-1");
        this.enqueueXml("us-east-1", "/monitoring.xml");
        Map result = this.monitoringApi().unmonitorInstancesInRegion("us-east-1", "i-911444f0", new String[]{"i-911444f1"});
        Assert.assertFalse((boolean)result.isEmpty());
        this.assertPosted("us-east-1", "Action=DescribeRegions");
        this.assertPosted("us-east-1", "Action=UnmonitorInstances&InstanceId.0=i-911444f0&InstanceId.1=i-911444f1");
    }

    private MonitoringApi monitoringApi() {
        return (MonitoringApi)this.api().getMonitoringApi().get();
    }
}

