/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.ec2.compute.strategy.AWSEC2ReviseParsedImage;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.config.EC2ComputeServiceDependenciesModule;
import org.jclouds.ec2.compute.functions.EC2ImageParser;
import org.jclouds.ec2.compute.strategy.EC2PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.ec2.compute.strategy.ReviseParsedImage;
import org.jclouds.ec2.xml.DescribeImagesResponseHandlerTest;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSEC2ImageParserTest")
public class AWSEC2ImageParserTest {
    static Location defaultLocation = new LocationBuilder().scope(LocationScope.REGION).id("us-east-1").description("us-east-1").build();

    public void testParseAlesticCanonicalImage() {
        Set<Image> result = AWSEC2ImageParserTest.convertImages("/alestic_canonical.xml");
        Assert.assertEquals((Object)Iterables.get(result, (int)0), (Object)new ImageBuilder().operatingSystem(new OperatingSystem.Builder().family(OsFamily.UBUNTU).arch("paravirtual").version("8.04").description("ubuntu-images-us/ubuntu-hardy-8.04-i386-server-20091130.manifest.xml").is64Bit(false).build()).description("ubuntu-images-us/ubuntu-hardy-8.04-i386-server-20091130.manifest.xml").defaultCredentials(LoginCredentials.builder().user("ubuntu").build()).id("us-east-1/ami-7e28ca17").providerId("ami-7e28ca17").location(defaultLocation).version("20091130").userMetadata((Map)ImmutableMap.of((Object)"owner", (Object)"099720109477", (Object)"rootDeviceType", (Object)"instance-store", (Object)"virtualizationType", (Object)"paravirtual", (Object)"hypervisor", (Object)"xen")).status(Image.Status.AVAILABLE).backendStatus("available").build());
        Assert.assertEquals((Object)((Image)Iterables.get(result, (int)0)).getStatus(), (Object)Image.Status.AVAILABLE);
        Assert.assertEquals((Object)Iterables.get(result, (int)4), (Object)new ImageBuilder().operatingSystem(new OperatingSystem.Builder().family(OsFamily.UBUNTU).arch("paravirtual").version("8.04").description("alestic/ubuntu-8.04-hardy-base-20080905.manifest.xml").is64Bit(false).build()).description("alestic/ubuntu-8.04-hardy-base-20080905.manifest.xml").defaultCredentials(LoginCredentials.builder().user("ubuntu").build()).id("us-east-1/ami-c0fa1ea9").providerId("ami-c0fa1ea9").location(defaultLocation).version("20080905").userMetadata((Map)ImmutableMap.of((Object)"owner", (Object)"063491364108", (Object)"rootDeviceType", (Object)"instance-store")).status(Image.Status.AVAILABLE).backendStatus("available").build());
        Assert.assertEquals((Object)((Image)Iterables.get(result, (int)4)).getStatus(), (Object)Image.Status.AVAILABLE);
        Assert.assertEquals((Object)Iterables.get(result, (int)6), (Object)new ImageBuilder().name("ebs/ubuntu-images/ubuntu-lucid-10.04-i386-server-20100827").operatingSystem(new OperatingSystem.Builder().family(OsFamily.UBUNTU).arch("paravirtual").version("10.04").description("099720109477/ebs/ubuntu-images/ubuntu-lucid-10.04-i386-server-20100827").is64Bit(false).build()).description("099720109477/ebs/ubuntu-images/ubuntu-lucid-10.04-i386-server-20100827").defaultCredentials(LoginCredentials.builder().user("ubuntu").build()).id("us-east-1/ami-10f3a255").providerId("ami-10f3a255").location(defaultLocation).version("20100827").userMetadata((Map)ImmutableMap.of((Object)"owner", (Object)"099720109477", (Object)"rootDeviceType", (Object)"ebs", (Object)"virtualizationType", (Object)"paravirtual", (Object)"hypervisor", (Object)"xen")).status(Image.Status.AVAILABLE).backendStatus("available").build());
        Assert.assertEquals((Object)((Image)Iterables.get(result, (int)6)).getStatus(), (Object)Image.Status.AVAILABLE);
    }

    public void testParseVostokImage() {
        Set<Image> result = AWSEC2ImageParserTest.convertImages("/vostok.xml");
        Assert.assertEquals((Object)Iterables.get(result, (int)0), (Object)new ImageBuilder().operatingSystem(new OperatingSystem.Builder().family(OsFamily.UNRECOGNIZED).arch("paravirtual").version("").description("vostok-builds/vostok-0.95-5622/vostok-0.95-5622.manifest.xml").is64Bit(false).build()).description("vostok-builds/vostok-0.95-5622/vostok-0.95-5622.manifest.xml").defaultCredentials(LoginCredentials.builder().user("root").build()).id("us-east-1/ami-870de2ee").providerId("ami-870de2ee").location(defaultLocation).version("5622").userMetadata((Map)ImmutableMap.of((Object)"owner", (Object)"133804938231", (Object)"rootDeviceType", (Object)"instance-store")).status(Image.Status.AVAILABLE).build());
    }

    public void testParseCCImage() {
        Set<Image> result = AWSEC2ImageParserTest.convertImages("/describe_images_cc.xml");
        Assert.assertEquals((Object)Iterables.get(result, (int)0), (Object)new ImageBuilder().name("EC2 CentOS 5.4 HVM AMI").operatingSystem(new OperatingSystem.Builder().family(OsFamily.CENTOS).arch("hvm").version("5.4").description("amazon/EC2 CentOS 5.4 HVM AMI").is64Bit(true).build()).description("EC2 CentOS 5.4 HVM AMI").defaultCredentials(LoginCredentials.builder().user("root").build()).id("us-east-1/ami-7ea24a17").providerId("ami-7ea24a17").location(defaultLocation).userMetadata((Map)ImmutableMap.of((Object)"owner", (Object)"206029621532", (Object)"rootDeviceType", (Object)"ebs", (Object)"virtualizationType", (Object)"hvm", (Object)"hypervisor", (Object)"xen")).status(Image.Status.AVAILABLE).build());
        Assert.assertEquals((Object)((Image)Iterables.get(result, (int)0)).getStatus(), (Object)Image.Status.AVAILABLE);
    }

    public void testParseRightScaleImage() {
        Set<Image> result = AWSEC2ImageParserTest.convertImages("/rightscale_images.xml");
        Assert.assertEquals((Object)Iterables.get(result, (int)0), (Object)new ImageBuilder().operatingSystem(new OperatingSystem.Builder().family(OsFamily.CENTOS).arch("paravirtual").version("5.4").description("rightscale-us-east/CentOS_5.4_x64_v4.4.10.manifest.xml").is64Bit(true).build()).description("rightscale-us-east/CentOS_5.4_x64_v4.4.10.manifest.xml").defaultCredentials(LoginCredentials.builder().user("root").build()).id("us-east-1/ami-ccb35ea5").providerId("ami-ccb35ea5").location(defaultLocation).version("4.4.10").userMetadata((Map)ImmutableMap.of((Object)"owner", (Object)"admin", (Object)"rootDeviceType", (Object)"instance-store")).status(Image.Status.AVAILABLE).backendStatus("available").build());
        Assert.assertEquals((Object)((Image)Iterables.get(result, (int)0)).getStatus(), (Object)Image.Status.AVAILABLE);
        Assert.assertEquals((String)new Gson().toJson(Iterables.get(result, (int)1)), (String)"{\"operatingSystem\":{\"family\":\"UBUNTU\",\"arch\":\"paravirtual\",\"version\":\"9.10\",\"description\":\"411009282317/RightImage_Ubuntu_9.10_x64_v4.5.3_EBS_Alpha\",\"is64Bit\":true},\"status\":\"AVAILABLE\",\"backendStatus\":\"available\",\"version\":\"4.5.3_EBS_Alpha\",\"description\":\"RightImage_Ubuntu_9.10_x64_v4.5.3_EBS_Alpha\",\"defaultCredentials\":{\"authenticateSudo\":false,\"password\":{},\"privateKey\":{},\"identity\":\"root\"},\"id\":\"us-east-1/ami-c19db6b5\",\"type\":\"IMAGE\",\"tags\":[],\"providerId\":\"ami-c19db6b5\",\"name\":\"RightImage_Ubuntu_9.10_x64_v4.5.3_EBS_Alpha\",\"location\":{\"scope\":\"REGION\",\"id\":\"us-east-1\",\"description\":\"us-east-1\",\"iso3166Codes\":[],\"metadata\":{}},\"userMetadata\":{\"owner\":\"411009282317\",\"rootDeviceType\":\"ebs\",\"virtualizationType\":\"paravirtual\",\"hypervisor\":\"xen\"}}");
        Assert.assertEquals((String)new Gson().toJson(Iterables.get(result, (int)2)), (String)"{\"operatingSystem\":{\"family\":\"WINDOWS\",\"arch\":\"hvm\",\"version\":\"2003\",\"description\":\"411009282317/RightImage Windows_2003_i386_v5.4.3\",\"is64Bit\":false},\"status\":\"AVAILABLE\",\"backendStatus\":\"available\",\"version\":\"5.4.3\",\"description\":\"Built by RightScale\",\"defaultCredentials\":{\"authenticateSudo\":false,\"password\":{},\"privateKey\":{},\"identity\":\"root\"},\"id\":\"us-east-1/ami-710c2605\",\"type\":\"IMAGE\",\"tags\":[],\"providerId\":\"ami-710c2605\",\"name\":\"RightImage Windows_2003_i386_v5.4.3\",\"location\":{\"scope\":\"REGION\",\"id\":\"us-east-1\",\"description\":\"us-east-1\",\"iso3166Codes\":[],\"metadata\":{}},\"userMetadata\":{\"owner\":\"411009282317\",\"rootDeviceType\":\"ebs\",\"virtualizationType\":\"hvm\",\"hypervisor\":\"xen\"}}");
        Assert.assertEquals((String)new Gson().toJson(Iterables.get(result, (int)3)), (String)"{\"operatingSystem\":{\"family\":\"CENTOS\",\"arch\":\"paravirtual\",\"version\":\"6.5\",\"description\":\"411009282317/RightImage_CentOS_6.5_x64_v13.5.2.2_EBS\",\"is64Bit\":true},\"status\":\"AVAILABLE\",\"backendStatus\":\"available\",\"version\":\"13.5.2.2_EBS\",\"description\":\"RightImage_CentOS_6.5_x64_v13.5.2.2_EBS\",\"defaultCredentials\":{\"authenticateSudo\":false,\"password\":{},\"privateKey\":{},\"identity\":\"root\"},\"id\":\"us-east-1/ami-05ebd06c\",\"type\":\"IMAGE\",\"tags\":[],\"providerId\":\"ami-05ebd06c\",\"name\":\"RightImage_CentOS_6.5_x64_v13.5.2.2_EBS\",\"location\":{\"scope\":\"REGION\",\"id\":\"us-east-1\",\"description\":\"us-east-1\",\"iso3166Codes\":[],\"metadata\":{}},\"userMetadata\":{\"owner\":\"411009282317\",\"rootDeviceType\":\"ebs\",\"virtualizationType\":\"paravirtual\",\"hypervisor\":\"xen\"}}");
        Assert.assertEquals((String)new Gson().toJson(Iterables.get(result, (int)4)), (String)"{\"operatingSystem\":{\"family\":\"UBUNTU\",\"arch\":\"paravirtual\",\"version\":\"10.04\",\"description\":\"411009282317/RightImage_Ubuntu_10.04_x64_v12.11.4_EBS\",\"is64Bit\":true},\"status\":\"AVAILABLE\",\"backendStatus\":\"available\",\"version\":\"12.11.4_EBS\",\"description\":\"RightImage_Ubuntu_10.04_x64_v12.11.4_EBS\",\"defaultCredentials\":{\"authenticateSudo\":false,\"password\":{},\"privateKey\":{},\"identity\":\"root\"},\"id\":\"us-east-1/ami-08bffe61\",\"type\":\"IMAGE\",\"tags\":[],\"providerId\":\"ami-08bffe61\",\"name\":\"RightImage_Ubuntu_10.04_x64_v12.11.4_EBS\",\"location\":{\"scope\":\"REGION\",\"id\":\"us-east-1\",\"description\":\"us-east-1\",\"iso3166Codes\":[],\"metadata\":{}},\"userMetadata\":{\"owner\":\"411009282317\",\"rootDeviceType\":\"ebs\",\"virtualizationType\":\"paravirtual\",\"hypervisor\":\"xen\"}}");
    }

    public void testParseAmznImage() {
        Set<Image> result = AWSEC2ImageParserTest.convertImages("/amzn_images.xml");
        Assert.assertEquals((Object)Iterables.get(result, (int)0), (Object)new ImageBuilder().name("amzn-ami-0.9.7-beta.i386-ebs").operatingSystem(new OperatingSystem.Builder().family(OsFamily.AMZN_LINUX).arch("paravirtual").version("0.9.7-beta").description("137112412989/amzn-ami-0.9.7-beta.i386-ebs").is64Bit(false).build()).description("Amazon").defaultCredentials(LoginCredentials.builder().user("ec2-user").build()).id("us-east-1/ami-82e4b5c7").providerId("ami-82e4b5c7").location(defaultLocation).version("0.9.7-beta").userMetadata((Map)ImmutableMap.of((Object)"owner", (Object)"137112412989", (Object)"rootDeviceType", (Object)"ebs", (Object)"virtualizationType", (Object)"paravirtual", (Object)"hypervisor", (Object)"xen")).status(Image.Status.AVAILABLE).build());
        Assert.assertEquals((Object)((Image)Iterables.get(result, (int)0)).getStatus(), (Object)Image.Status.AVAILABLE);
        Assert.assertEquals((Object)Iterables.get(result, (int)3), (Object)new ImageBuilder().name("amzn-ami-0.9.7-beta.x86_64-S3").operatingSystem(new OperatingSystem.Builder().family(OsFamily.AMZN_LINUX).arch("paravirtual").version("0.9.7-beta").description("amzn-ami-us-west-1/amzn-ami-0.9.7-beta.x86_64.manifest.xml").is64Bit(true).build()).description("Amazon Linux AMI x86_64 S3").defaultCredentials(LoginCredentials.builder().user("ec2-user").build()).id("us-east-1/ami-f2e4b5b7").providerId("ami-f2e4b5b7").location(defaultLocation).version("0.9.7-beta").userMetadata((Map)ImmutableMap.of((Object)"owner", (Object)"137112412989", (Object)"rootDeviceType", (Object)"ebs", (Object)"virtualizationType", (Object)"paravirtual", (Object)"hypervisor", (Object)"xen")).status(Image.Status.AVAILABLE).build());
        Assert.assertEquals((Object)((Image)Iterables.get(result, (int)3)).getStatus(), (Object)Image.Status.AVAILABLE);
    }

    public static Set<Image> convertImages(String resource) {
        Map map = new BaseComputeServiceContextModule(){}.provideOsVersionMap(new ComputeServiceConstants.ReferenceData(), (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class));
        Set result = DescribeImagesResponseHandlerTest.parseImages((String)resource);
        EC2ImageParser parser = new EC2ImageParser(EC2ComputeServiceDependenciesModule.toPortableImageStatus, (PopulateDefaultLoginCredentialsForImageStrategy)new EC2PopulateDefaultLoginCredentialsForImageStrategy(), map, Suppliers.ofInstance((Object)ImmutableSet.of((Object)defaultLocation)), Suppliers.ofInstance((Object)defaultLocation), (ReviseParsedImage)new AWSEC2ReviseParsedImage(map));
        return Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)result, (Function)parser), (Predicate)Predicates.notNull()));
    }
}

