/*
 * Decompiled with CFR 0.152.
 */
package com.amitshekhar.utils;

import android.content.Context;
import android.content.SharedPreferences;
import com.amitshekhar.model.Response;
import com.amitshekhar.model.RowDataRequest;
import com.amitshekhar.model.TableDataResponse;
import com.amitshekhar.model.UpdateRowResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;

public class PrefHelper {
    private static final String PREFS_SUFFIX = ".xml";

    private PrefHelper() {
    }

    public static List<String> getSharedPreferenceTags(Context context) {
        ArrayList<String> tags = new ArrayList<String>();
        String rootPath = context.getApplicationInfo().dataDir + "/shared_prefs";
        File root = new File(rootPath);
        if (root.exists()) {
            for (File file : root.listFiles()) {
                String fileName = file.getName();
                if (!fileName.endsWith(PREFS_SUFFIX)) continue;
                tags.add(fileName.substring(0, fileName.length() - PREFS_SUFFIX.length()));
            }
        }
        Collections.sort(tags);
        return tags;
    }

    public static Response getAllPrefTableName(Context context) {
        Response response = new Response();
        List<String> prefTags = PrefHelper.getSharedPreferenceTags(context);
        for (String tag : prefTags) {
            response.rows.add(tag);
        }
        response.isSuccessful = true;
        return response;
    }

    public static TableDataResponse getAllPrefData(Context context, String tag) {
        TableDataResponse response = new TableDataResponse();
        response.isEditable = true;
        response.isSuccessful = true;
        response.isSelectQuery = true;
        TableDataResponse.TableInfo keyInfo = new TableDataResponse.TableInfo();
        keyInfo.isPrimary = true;
        keyInfo.title = "Key";
        TableDataResponse.TableInfo valueInfo = new TableDataResponse.TableInfo();
        valueInfo.isPrimary = false;
        valueInfo.title = "Value";
        response.tableInfos = new ArrayList<TableDataResponse.TableInfo>();
        response.tableInfos.add(keyInfo);
        response.tableInfos.add(valueInfo);
        response.rows = new ArrayList<Object>();
        SharedPreferences preferences = context.getSharedPreferences(tag, 0);
        Map allEntries = preferences.getAll();
        for (Map.Entry entry : allEntries.entrySet()) {
            ArrayList<TableDataResponse.ColumnData> row = new ArrayList<TableDataResponse.ColumnData>();
            TableDataResponse.ColumnData keyColumnData = new TableDataResponse.ColumnData();
            keyColumnData.dataType = "text";
            keyColumnData.value = entry.getKey();
            row.add(keyColumnData);
            TableDataResponse.ColumnData valueColumnData = new TableDataResponse.ColumnData();
            valueColumnData.value = entry.getValue().toString();
            if (entry.getValue() != null) {
                if (entry.getValue() instanceof String) {
                    valueColumnData.dataType = "text";
                } else if (entry.getValue() instanceof Integer) {
                    valueColumnData.dataType = "integer";
                } else if (entry.getValue() instanceof Long) {
                    valueColumnData.dataType = "long";
                } else if (entry.getValue() instanceof Float) {
                    valueColumnData.dataType = "float";
                } else if (entry.getValue() instanceof Boolean) {
                    valueColumnData.dataType = "boolean";
                } else if (entry.getValue() instanceof Set) {
                    valueColumnData.dataType = "string_set";
                }
            } else {
                valueColumnData.dataType = "text";
            }
            row.add(valueColumnData);
            response.rows.add(row);
        }
        return response;
    }

    public static UpdateRowResponse addOrUpdateRow(Context context, String tableName, List<RowDataRequest> rowDataRequests) {
        UpdateRowResponse updateRowResponse = new UpdateRowResponse();
        if (tableName == null) {
            return updateRowResponse;
        }
        RowDataRequest rowDataKey = rowDataRequests.get(0);
        RowDataRequest rowDataValue = rowDataRequests.get(1);
        String key = rowDataKey.value;
        String value = rowDataValue.value;
        String dataType = rowDataValue.dataType;
        if ("null".equals(value)) {
            value = null;
        }
        SharedPreferences preferences = context.getSharedPreferences(tableName, 0);
        try {
            switch (dataType) {
                case "text": {
                    preferences.edit().putString(key, value).apply();
                    updateRowResponse.isSuccessful = true;
                    break;
                }
                case "integer": {
                    preferences.edit().putInt(key, Integer.valueOf(value).intValue()).apply();
                    updateRowResponse.isSuccessful = true;
                    break;
                }
                case "long": {
                    preferences.edit().putLong(key, Long.valueOf(value).longValue()).apply();
                    updateRowResponse.isSuccessful = true;
                    break;
                }
                case "float": {
                    preferences.edit().putFloat(key, Float.valueOf(value).floatValue()).apply();
                    updateRowResponse.isSuccessful = true;
                    break;
                }
                case "boolean": {
                    preferences.edit().putBoolean(key, Boolean.valueOf(value).booleanValue()).apply();
                    updateRowResponse.isSuccessful = true;
                    break;
                }
                case "string_set": {
                    JSONArray jsonArray = new JSONArray(value);
                    HashSet<String> stringSet = new HashSet<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        stringSet.add(jsonArray.getString(i));
                    }
                    preferences.edit().putStringSet(key, stringSet).apply();
                    updateRowResponse.isSuccessful = true;
                    break;
                }
                default: {
                    preferences.edit().putString(key, value).apply();
                    updateRowResponse.isSuccessful = true;
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return updateRowResponse;
    }

    public static UpdateRowResponse deleteRow(Context context, String tableName, List<RowDataRequest> rowDataRequests) {
        UpdateRowResponse updateRowResponse = new UpdateRowResponse();
        if (tableName == null) {
            return updateRowResponse;
        }
        RowDataRequest rowDataKey = rowDataRequests.get(0);
        String key = rowDataKey.value;
        SharedPreferences preferences = context.getSharedPreferences(tableName, 0);
        try {
            preferences.edit().remove(key).apply();
            updateRowResponse.isSuccessful = true;
        }
        catch (Exception ex) {
            updateRowResponse.isSuccessful = false;
        }
        return updateRowResponse;
    }
}

